/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.StringUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class FlatToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.createSharedUI(FlatToolTipUI.class, FlatToolTipUI::new);
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        FlatHTML.updateRendererCSSFontBaseSize(c15);
    }

    @Override
    protected void installListeners(JComponent c15) {
        super.installListeners(c15);
        c15.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent c15) {
        super.uninstallListeners(c15);
        c15.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        FlatHTML.propertyChange(e15);
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        String text = ((JToolTip)c15).getTipText();
        if (text == null || text.isEmpty()) {
            return new Dimension();
        }
        if (this.isMultiLine(c15)) {
            FontMetrics fm4 = c15.getFontMetrics(c15.getFont());
            Insets insets = c15.getInsets();
            List<String> lines = StringUtils.split(((JToolTip)c15).getTipText(), '\n');
            int width = 0;
            int height = fm4.getHeight() * Math.max(lines.size(), 1);
            for (String line : lines) {
                width = Math.max(width, SwingUtilities.computeStringWidth(fm4, line));
            }
            return new Dimension(insets.left + width + insets.right + 6, insets.top + height + insets.bottom);
        }
        return super.getPreferredSize(c15);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        if (this.isMultiLine(c15)) {
            FontMetrics fm4 = c15.getFontMetrics(c15.getFont());
            Insets insets = c15.getInsets();
            g15.setColor(c15.getForeground());
            List<String> lines = StringUtils.split(((JToolTip)c15).getTipText(), '\n');
            int x15 = insets.left + 3;
            int x25 = c15.getWidth() - insets.right - 3;
            int y15 = insets.top - fm4.getDescent();
            int lineHeight = fm4.getHeight();
            JComponent comp = ((JToolTip)c15).getComponent();
            boolean leftToRight = (comp != null ? comp : c15).getComponentOrientation().isLeftToRight();
            for (String line : lines) {
                FlatUIUtils.drawString(c15, g15, line, leftToRight ? x15 : x25 - SwingUtilities.computeStringWidth(fm4, line), y15 += lineHeight);
            }
        } else {
            super.paint(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g15), c15);
        }
    }

    private boolean isMultiLine(JComponent c15) {
        String text = ((JToolTip)c15).getTipText();
        return c15.getClientProperty("html") == null && text != null && text.indexOf(10) >= 0;
    }
}

