/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FlatToolBarUI
extends BasicToolBarUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    @FlatStylingSupport.Styleable
    protected boolean focusableButtons;
    @FlatStylingSupport.Styleable
    protected boolean arrowKeysOnlyNavigation;
    @FlatStylingSupport.Styleable
    protected int hoverButtonGroupArc;
    @FlatStylingSupport.Styleable
    protected Color hoverButtonGroupBackground;
    @FlatStylingSupport.Styleable
    protected Insets borderMargins;
    @FlatStylingSupport.Styleable
    protected Color gripColor;
    @FlatStylingSupport.Styleable
    protected Integer separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private FocusTraversalPolicy focusTraversalPolicy;
    private Boolean oldFloatable;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatToolBarUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installFocusTraversalPolicy();
        this.installStyle();
        if (!this.focusableButtons) {
            this.setButtonsFocusable(false);
        }
    }

    @Override
    public void uninstallUI(JComponent c15) {
        super.uninstallUI(c15);
        if (!this.focusableButtons) {
            this.setButtonsFocusable(true);
        }
        this.uninstallFocusTraversalPolicy();
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusableButtons = UIManager.getBoolean("ToolBar.focusableButtons");
        this.arrowKeysOnlyNavigation = UIManager.getBoolean("ToolBar.arrowKeysOnlyNavigation");
        this.hoverButtonGroupArc = UIManager.getInt("ToolBar.hoverButtonGroupArc");
        this.hoverButtonGroupBackground = UIManager.getColor("ToolBar.hoverButtonGroupBackground");
        if (!UIManager.getBoolean("ToolBar.floatable")) {
            this.oldFloatable = this.toolBar.isFloatable();
            this.toolBar.setFloatable(false);
        } else {
            this.oldFloatable = null;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverButtonGroupBackground = null;
        if (this.oldFloatable != null) {
            this.toolBar.setFloatable(this.oldFloatable);
            this.oldFloatable = null;
        }
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        RootPaneContainer floatingWindow = super.createFloatingWindow(toolbar);
        floatingWindow.getRootPane().putClientProperty("Window.style", "small");
        return floatingWindow;
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new BasicToolBarUI.ToolBarContListener(){

            @Override
            public void componentAdded(ContainerEvent e15) {
                super.componentAdded(e15);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(e15.getChild(), false);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e15) {
                super.componentRemoved(e15);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(e15.getChild(), true);
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.toolBar, this::installStyle, super.createPropertyListener());
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.toolBar, "ToolBar"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        boolean oldFocusableButtons = this.focusableButtons;
        boolean oldArrowKeysOnlyNavigation = this.arrowKeysOnlyNavigation;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
        if (this.focusableButtons != oldFocusableButtons) {
            this.setButtonsFocusable(this.focusableButtons);
        }
        if (this.arrowKeysOnlyNavigation != oldArrowKeysOnlyNavigation || this.focusableButtons != oldFocusableButtons) {
            if (this.arrowKeysOnlyNavigation) {
                this.installFocusTraversalPolicy();
            } else {
                this.uninstallFocusTraversalPolicy();
            }
        }
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.toolBar, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    protected void setButtonsFocusable(boolean focusable) {
        for (Component c15 : this.toolBar.getComponents()) {
            this.setButtonFocusable(c15, focusable);
        }
    }

    private void setButtonFocusable(Component c15, boolean focusable) {
        if (c15 instanceof AbstractButton && focusable != c15.isFocusable()) {
            c15.setFocusable(focusable);
        }
    }

    protected void installFocusTraversalPolicy() {
        if (!this.arrowKeysOnlyNavigation || !this.focusableButtons || this.toolBar.getFocusTraversalPolicy() != null) {
            return;
        }
        this.focusTraversalPolicy = this.createFocusTraversalPolicy();
        if (this.focusTraversalPolicy != null) {
            this.toolBar.setFocusTraversalPolicy(this.focusTraversalPolicy);
            this.toolBar.setFocusTraversalPolicyProvider(true);
        }
    }

    protected void uninstallFocusTraversalPolicy() {
        if (this.focusTraversalPolicy != null && this.toolBar.getFocusTraversalPolicy() == this.focusTraversalPolicy) {
            this.toolBar.setFocusTraversalPolicy(null);
            this.toolBar.setFocusTraversalPolicyProvider(false);
        }
        this.focusTraversalPolicy = null;
    }

    protected FocusTraversalPolicy createFocusTraversalPolicy() {
        return new FlatToolBarFocusTraversalPolicy();
    }

    @Override
    protected void navigateFocusedComp(int direction) {
        block9: {
            Component c15;
            int add;
            int count = this.toolBar.getComponentCount();
            if (this.focusedCompIndex < 0 || this.focusedCompIndex >= count) {
                return;
            }
            switch (direction) {
                case 3: 
                case 5: {
                    add = 1;
                    break;
                }
                case 1: 
                case 7: {
                    add = -1;
                    break;
                }
                default: {
                    return;
                }
            }
            int i15 = this.focusedCompIndex;
            do {
                if ((i15 += add) < 0) {
                    i15 = count - 1;
                } else if (i15 >= count) {
                    i15 = 0;
                }
                if (i15 == this.focusedCompIndex) break block9;
            } while (!FlatToolBarUI.canBeFocusOwner(c15 = this.toolBar.getComponentAtIndex(i15)));
            c15.requestFocus();
            return;
        }
    }

    private static boolean canBeFocusOwner(Component c15) {
        if (!(c15 != null && c15.isEnabled() && c15.isVisible() && c15.isDisplayable() && c15.isFocusable())) {
            return false;
        }
        if (c15 instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c15;
            return comboBox.getUI().isFocusTraversable(comboBox);
        }
        if (c15 instanceof JComponent) {
            InputMap inputMap;
            for (inputMap = ((JComponent)c15).getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
            }
            if (inputMap == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setBorderToRollover(Component c15) {
    }

    @Override
    protected void setBorderToNonRollover(Component c15) {
    }

    @Override
    protected void setBorderToNormal(Component c15) {
    }

    @Override
    protected void installRolloverBorders(JComponent c15) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent c15) {
    }

    @Override
    protected void installNormalBorders(JComponent c15) {
    }

    @Override
    protected Border createRolloverBorder() {
        return null;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return null;
    }

    @Override
    public void setOrientation(int orientation) {
        Insets margin;
        Insets newMargin;
        if (orientation != this.toolBar.getOrientation() && !(newMargin = new Insets(margin.left, margin.top, margin.right, margin.bottom)).equals(margin = this.toolBar.getMargin())) {
            this.toolBar.setMargin(newMargin);
        }
        super.setOrientation(orientation);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        super.paint(g15, c15);
        this.paintButtonGroup(g15);
    }

    protected void paintButtonGroup(Graphics g15) {
        Component b15;
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        ButtonGroup group = null;
        Component[] componentArray = this.toolBar.getComponents();
        int n15 = componentArray.length;
        for (int i15 = 0; !(i15 >= n15 || (b15 = componentArray[i15]) instanceof AbstractButton && ((AbstractButton)b15).getModel().isRollover() && (group = this.getButtonGroup((AbstractButton)b15)) != null); ++i15) {
        }
        if (group == null) {
            return;
        }
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        Enumeration<AbstractButton> e15 = group.getElements();
        while (e15.hasMoreElements()) {
            AbstractButton gb5 = e15.nextElement();
            if (gb5.getParent() != this.toolBar) continue;
            rects.add(gb5.getBounds());
        }
        boolean horizontal = this.toolBar.getOrientation() == 0;
        rects.sort((r15, r25) -> horizontal ? r15.x - r25.x : r15.y - r25.y);
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        g15.setColor(FlatUIUtils.deriveColor(this.hoverButtonGroupBackground, this.toolBar.getBackground()));
        int maxSepWidth = UIScale.scale(10);
        Rectangle gr4 = null;
        for (Rectangle r16 : rects) {
            if (gr4 == null) {
                gr4 = r16;
                continue;
            }
            if (horizontal ? gr4.x + gr4.width + maxSepWidth >= r16.x : gr4.y + gr4.height + maxSepWidth >= r16.y) {
                gr4 = gr4.union(r16);
                continue;
            }
            FlatUIUtils.paintComponentBackground((Graphics2D)g15, gr4.x, gr4.y, gr4.width, gr4.height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
            gr4 = r16;
        }
        if (gr4 != null) {
            FlatUIUtils.paintComponentBackground((Graphics2D)g15, gr4.x, gr4.y, gr4.width, gr4.height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
        }
        FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
    }

    protected void repaintButtonGroup(AbstractButton b15) {
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        ButtonGroup group = this.getButtonGroup(b15);
        if (group == null) {
            return;
        }
        Rectangle gr4 = null;
        Enumeration<AbstractButton> e15 = group.getElements();
        while (e15.hasMoreElements()) {
            AbstractButton gb5 = e15.nextElement();
            Container parent = gb5.getParent();
            if (parent != this.toolBar) continue;
            gr4 = gr4 != null ? gr4.union(gb5.getBounds()) : gb5.getBounds();
        }
        if (gr4 != null) {
            HiDPIUtils.repaint(this.toolBar, gr4);
        }
    }

    private ButtonGroup getButtonGroup(AbstractButton b15) {
        ButtonModel model = b15.getModel();
        return model instanceof DefaultButtonModel ? ((DefaultButtonModel)model).getGroup() : null;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int x15, int y15) {
        return null;
    }

    protected class FlatToolBarFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected FlatToolBarFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (!(aComponent instanceof AbstractButton)) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            Component c15 = aComponent;
            while ((c15 = super.getComponentAfter(aContainer, c15)) != null) {
                if (c15 instanceof AbstractButton) continue;
                return c15;
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (!(aComponent instanceof AbstractButton)) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            Component c15 = aComponent;
            while ((c15 = super.getComponentBefore(aContainer, c15)) != null) {
                if (c15 instanceof AbstractButton) continue;
                return c15;
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getRecentComponent(aContainer, true);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getRecentComponent(aContainer, false);
        }

        private Component getRecentComponent(Container aContainer, boolean first) {
            Component c15;
            if (FlatToolBarUI.this.focusedCompIndex >= 0 && FlatToolBarUI.this.focusedCompIndex < FlatToolBarUI.this.toolBar.getComponentCount() && this.accept(c15 = FlatToolBarUI.this.toolBar.getComponent(FlatToolBarUI.this.focusedCompIndex))) {
                return c15;
            }
            return first ? super.getFirstComponent(aContainer) : super.getLastComponent(aContainer);
        }
    }
}

