/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable;

import com.android.tools.smali.dexlib2.HiddenApiRestriction;
import com.android.tools.smali.dexlib2.base.reference.BaseFieldReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.immutable.ImmutableAnnotation;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import com.android.tools.smali.util.CollectionUtils;
import com.android.tools.smali.util.ImmutableConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableField
extends BaseFieldReference
implements Field {
    @Nonnull
    protected final String definingClass;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String type;
    protected final int accessFlags;
    @Nullable
    protected final ImmutableEncodedValue initialValue;
    @Nonnull
    protected final Set<? extends ImmutableAnnotation> annotations;
    @Nonnull
    protected final Set<HiddenApiRestriction> hiddenApiRestrictions;
    private static final ImmutableConverter<ImmutableField, Field> CONVERTER = new ImmutableConverter<ImmutableField, Field>(){

        @Override
        protected boolean isImmutable(@Nonnull Field item) {
            return item instanceof ImmutableField;
        }

        @Override
        @Nonnull
        protected ImmutableField makeImmutable(@Nonnull Field item) {
            return ImmutableField.of(item);
        }
    };

    public ImmutableField(@Nonnull String definingClass, @Nonnull String name, @Nonnull String type, int accessFlags, @Nullable EncodedValue initialValue, @Nullable Collection<? extends Annotation> annotations, @Nullable Set<HiddenApiRestriction> hiddenApiRestrictions) {
        this.definingClass = definingClass;
        this.name = name;
        this.type = type;
        this.accessFlags = accessFlags;
        this.initialValue = ImmutableEncodedValueFactory.ofNullable(initialValue);
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.hiddenApiRestrictions = hiddenApiRestrictions == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<HiddenApiRestriction>(hiddenApiRestrictions));
    }

    public static ImmutableField of(Field field) {
        if (field instanceof ImmutableField) {
            return (ImmutableField)field;
        }
        return new ImmutableField(field.getDefiningClass(), field.getName(), field.getType(), field.getAccessFlags(), field.getInitialValue(), field.getAnnotations(), field.getHiddenApiRestrictions());
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    @Nonnull
    public Set<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nonnull
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        return this.hiddenApiRestrictions;
    }

    @Nonnull
    public static SortedSet<ImmutableField> immutableSetOf(@Nullable Iterable<? extends Field> list2) {
        return CONVERTER.toSortedSet(CollectionUtils.naturalOrdering(), list2);
    }
}

