/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.DexFileFactory;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.analysis.ClassPathResolver;
import com.android.tools.smali.dexlib2.analysis.ClassProvider;
import com.android.tools.smali.dexlib2.analysis.DexClassProvider;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.OatFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class PathEntryLoader {
    Opcodes opcodes;
    final Set<File> loadedFiles = new HashSet<File>();
    final List<ClassProvider> classProviders = new ArrayList<ClassProvider>();

    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public List<ClassProvider> getClassProviders() {
        return this.classProviders;
    }

    public PathEntryLoader(Opcodes opcodes) {
        this.opcodes = opcodes;
    }

    @Nonnull
    public List<ClassProvider> getResolvedClassProviders() {
        return this.classProviders;
    }

    public void loadEntry(@Nonnull File entryFile, boolean loadOatDependencies) throws IOException, NoDexException {
        List<String> oatDependencies;
        MultiDexContainer<? extends DexBackedDexFile> container;
        if (this.loadedFiles.contains(entryFile)) {
            return;
        }
        try {
            container = DexFileFactory.loadDexContainer(entryFile, this.opcodes);
        }
        catch (DexFileFactory.UnsupportedFileTypeException ex4) {
            throw new ClassPathResolver.ResolveException(ex4);
        }
        List<String> entryNames = container.getDexEntryNames();
        if (entryNames.isEmpty()) {
            throw new NoDexException("%s contains no dex file", entryFile);
        }
        this.loadedFiles.add(entryFile);
        for (String entryName : entryNames) {
            this.classProviders.add(new DexClassProvider(container.getEntry(entryName).getDexFile()));
        }
        if (loadOatDependencies && container instanceof OatFile && !(oatDependencies = ((OatFile)container).getBootClassPath()).isEmpty()) {
            try {
                this.loadOatDependencies(entryFile.getParentFile(), oatDependencies);
            }
            catch (ClassPathResolver.NotFoundException ex5) {
                throw new ClassPathResolver.ResolveException(ex5, "Error while loading oat file %s", entryFile);
            }
            catch (NoDexException ex6) {
                throw new ClassPathResolver.ResolveException(ex6, "Error while loading dependencies for oat file %s", entryFile);
            }
        }
    }

    private void loadOatDependencies(@Nonnull File directory, @Nonnull List<String> oatDependencies) throws IOException, NoDexException, ClassPathResolver.NotFoundException {
        for (String oatDependency : oatDependencies) {
            String oatDependencyName = this.getFilenameForOatDependency(oatDependency);
            File file2 = new File(directory, oatDependencyName);
            if (!file2.exists()) {
                throw new ClassPathResolver.NotFoundException("Cannot find dependency %s in %s", oatDependencyName, directory);
            }
            this.loadEntry(file2, false);
        }
    }

    @Nonnull
    private String getFilenameForOatDependency(String oatDependency) {
        int index = oatDependency.lastIndexOf(47);
        String dependencyLeaf = oatDependency.substring(index + 1);
        if (dependencyLeaf.endsWith(".art")) {
            return dependencyLeaf.substring(0, dependencyLeaf.length() - 4) + ".oat";
        }
        return dependencyLeaf;
    }

    static class NoDexException
    extends Exception {
        public NoDexException(String message2, Object ... formatArgs) {
            super(String.format(message2, formatArgs));
        }
    }
}

