/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.internal.ax;
import com.android.tools.r8.internal.r80;
import com.android.tools.r8.internal.s80;
import com.android.tools.r8.internal.uv0;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JdkClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    static final /* synthetic */ boolean g;
    private final Origin b;
    private final HashSet c;
    private final HashMap d;
    private final URLClassLoader e;
    private FileSystem f;

    public static ClassFileResourceProvider fromSystemJdk() throws IOException {
        return new JdkClassFileProvider();
    }

    public static ClassFileResourceProvider fromSystemModulesJdk(Path home) throws IOException {
        Path path = home.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(path, new LinkOption[0])) {
            Path path2;
            return new JdkClassFileProvider(path2);
        }
        throw new NoSuchFileException(path.toString());
    }

    public static ClassFileResourceProvider fromJdkHome(Path home) throws IOException {
        Path path;
        if (Files.exists(home.resolve("lib").resolve("jrt-fs.jar"), new LinkOption[0])) {
            return JdkClassFileProvider.fromSystemModulesJdk(path);
        }
        Path path2 = path.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        path2 = path.resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        throw new IOException("Path " + path + " does not look like a Java home");
    }

    public static ClassFileResourceProvider fromJavaRuntimeJar(Path archive) throws IOException {
        Path path;
        return new ArchiveClassFileProvider(path);
    }

    private JdkClassFileProvider() {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.c = new HashSet();
        jdkClassFileProvider.d = new HashMap();
        jdkClassFileProvider.b = Origin.unknown();
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), Collections.EMPTY_MAP));
    }

    private JdkClassFileProvider(Path path) {
        HashMap hashMap;
        URLClassLoader uRLClassLoader;
        closeable.c = new HashSet();
        closeable.d = new HashMap();
        closeable.b = new PathOrigin(path);
        HashMap hashMap2 = path.resolve("lib").resolve("jrt-fs.jar");
        if (!g && !Files.exists((Path)((Object)hashMap2), new LinkOption[0])) {
            throw new AssertionError();
        }
        JdkClassFileProvider jdkClassFileProvider = closeable;
        Closeable closeable = uRLClassLoader;
        hashMap2 = hashMap2.toUri().toURL();
        jdkClassFileProvider.e = new URLClassLoader(new URL[]{hashMap2});
        hashMap2 = hashMap;
        hashMap2();
        hashMap.put("java.home", path.toString());
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), hashMap2, (ClassLoader)((Object)closeable)));
    }

    private void a(FileSystem fileSystem) {
        this.f = fileSystem;
        Files.walk(fileSystem.getPath("/modules", new String[0]), new FileVisitOption[0]).forEach(this::a);
    }

    private void a(Path object) {
        if (uv0.b((Path)object)) {
            JdkClassFileProvider jdkClassFileProvider = this;
            Object object2 = this = s80.x(object.toString());
            object = ((r80)object2).b;
            jdkClassFileProvider.d.put(object, ((r80)object2).a);
            jdkClassFileProvider.c.add(((r80)this).b);
            return;
        }
    }

    static {
        g = JdkClassFileProvider.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.c);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgramResource getProgramResource(String descriptor2) {
        ProgramResource.Kind kind2;
        JdkClassFileProvider jdkClassFileProvider;
        void v15;
        Origin origin;
        void var1_1;
        if (!((JdkClassFileProvider)((Object)this_)).c.contains(var1_1)) {
            return null;
        }
        try {
            origin = Origin.unknown();
            v15 = var1_1;
            jdkClassFileProvider = this_;
            kind2 = ProgramResource.Kind.CF;
        }
        catch (IOException iOException) {
            JdkClassFileProvider jdkClassFileProvider2 = this_;
            String this_ = "Failed to read '" + (String)var1_1;
            throw new ax(this_, jdkClassFileProvider2.b);
        }
        FileSystem fileSystem = jdkClassFileProvider.f;
        void v65 = var1_1;
        String string = this_;
        Object[] objectArray = "modules";
        Object object = (String)((JdkClassFileProvider)((Object)string)).d.get(var1_1);
        String string2 = s80.s((String)v65);
        String[] stringArray = objectArray;
        String[] stringArray2 = new String[2];
        objectArray = stringArray2;
        stringArray2[0] = object;
        stringArray2[1] = string2;
        objectArray = Files.readAllBytes(fileSystem.getPath((String)stringArray, (String[])objectArray));
        object = Collections.singleton(v15);
        return ProgramResource.fromBytes(origin, kind2, (byte[])objectArray, (Set<String>)object);
    }

    protected void finalize() throws Throwable {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        JdkClassFileProvider jdkClassFileProvider = this_;
        jdkClassFileProvider.f.close();
        Closeable this_ = jdkClassFileProvider.e;
        if (this_ != null) {
            ((URLClassLoader)this_).close();
            return;
        }
    }
}

