/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.PlatformVcsPathPresenter;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ModuleVcsPathPresenter
extends VcsPathPresenter {
    private final Project myProject;

    public ModuleVcsPathPresenter(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getPresentableRelativePathFor(VirtualFile file) {
        if (file == null) {
            return "";
        }
        String string = (String)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return file.getPresentableUrl();
            }
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module module = fileIndex.getModuleForFile(file, hideExcludedFiles);
            VirtualFile contentRoot = fileIndex.getContentRootForFile(file, hideExcludedFiles);
            if (module == null || contentRoot == null) {
                return file.getPresentableUrl();
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)File.separatorChar);
            assert (relativePath != null);
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(module, contentRoot, relativePath);
        });
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPresentableRelativePath(@NotNull ContentRevision fromRevision, @NotNull ContentRevision toRevision) {
        String moduleResult;
        if (fromRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(1);
        }
        if (toRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(2);
        }
        FilePath fromPath = fromRevision.getFile();
        FilePath toPath = toRevision.getFile();
        VirtualFile fromParent = VcsImplUtil.findValidParentAccurately(fromPath);
        VirtualFile toParent = VcsImplUtil.findValidParentAccurately(toPath);
        if (fromParent != null && toParent != null && (moduleResult = (String)ReadAction.compute(() -> {
            String relativePath;
            if (this.myProject.isDisposed()) {
                return null;
            }
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module fromModule = fileIndex.getModuleForFile(fromParent, hideExcludedFiles);
            Module toModule = fileIndex.getModuleForFile(toParent, hideExcludedFiles);
            if (fromModule == null) {
                return null;
            }
            if ((toModule == null || fromModule.equals((Object)toModule)) && (relativePath = RelativePathCalculator.computeRelativePath((String)toPath.getPath(), (String)fromPath.getPath(), (boolean)true)) != null) {
                return FileUtilRt.toSystemDependentName((String)relativePath);
            }
            if (ModuleType.isInternal((Module)fromModule)) {
                return null;
            }
            VirtualFile fromContentRoot = fileIndex.getContentRootForFile(fromParent, hideExcludedFiles);
            if (fromContentRoot == null) {
                return null;
            }
            Object relativePath2 = VfsUtilCore.getRelativePath((VirtualFile)fromParent, (VirtualFile)fromContentRoot, (char)File.separatorChar);
            if (relativePath2 == null) {
                return null;
            }
            if (!((String)relativePath2).isEmpty()) {
                relativePath2 = (String)relativePath2 + File.separatorChar;
            }
            if (!fromPath.getName().equals(toPath.getName())) {
                relativePath2 = (String)relativePath2 + fromPath.getName();
            }
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(fromModule, fromContentRoot, (String)relativePath2);
        })) != null) {
            String string = moduleResult;
            if (string == null) {
                ModuleVcsPathPresenter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PlatformVcsPathPresenter.getPresentableRelativePath((FilePath)toPath, (FilePath)fromPath);
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsContexts.Label
    @NotNull
    private static String getPresentableRelativePathFor(@NotNull Module module, @NotNull VirtualFile contentRoot, @NlsSafe @NotNull String relativePath) {
        if (module == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(5);
        }
        if (contentRoot == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(7);
        }
        String string = "[" + module.getName() + "] " + contentRoot.getName() + File.separatorChar + relativePath;
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRevision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePathFor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePathFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

