/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslContextModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslElementModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReferenceTo {
    private static final Logger LOG = Logger.getInstance(ReferenceTo.class);
    @NotNull
    private final String fullyQualifiedName;
    @NotNull
    private final GradleDslElementModel elementModel;
    @NotNull
    private final GradleDslElement scope;

    public ReferenceTo(@NotNull GradleDslElementModel model) {
        if (model == null) {
            ReferenceTo.$$$reportNull$$$0(0);
        }
        this(model, model);
    }

    public ReferenceTo(@NotNull GradleDslElementModel model, @NotNull GradleDslContextModel context) {
        if (model == null) {
            ReferenceTo.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ReferenceTo.$$$reportNull$$$0(2);
        }
        this.elementModel = model;
        this.scope = context.getRawPropertyHolder();
        if (model.getRawElement() != null) {
            this.fullyQualifiedName = model.getFullyQualifiedName();
        } else {
            LOG.warn((Throwable)new IllegalArgumentException("Invalid model property: please check the property exists."));
            this.fullyQualifiedName = "invalid.model.in.ReferenceTo";
        }
    }

    @Nullable
    public static ReferenceTo createReferenceFromText(@NotNull String referredElementName, @NotNull GradlePropertyModel propertyContext) {
        GradlePropertyModel referenceModel;
        if (referredElementName == null) {
            ReferenceTo.$$$reportNull$$$0(3);
        }
        if (propertyContext == null) {
            ReferenceTo.$$$reportNull$$$0(4);
        }
        if ((referenceModel = GradlePropertyModelBuilder.getModelFromExternalText(referredElementName, propertyContext.getHolder())) == null) {
            return null;
        }
        return new ReferenceTo(referenceModel, propertyContext);
    }

    @NotNull
    public GradleDslElement getReferredElement() {
        GradleDslElement gradleDslElement = this.elementModel.getRawElement();
        if (gradleDslElement == null) {
            ReferenceTo.$$$reportNull$$$0(5);
        }
        return gradleDslElement;
    }

    @NotNull
    public String getFullyQualifiedName() {
        String string = this.fullyQualifiedName;
        if (string == null) {
            ReferenceTo.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceTo text = (ReferenceTo)o;
        return com.google.common.base.Objects.equal((Object)this.fullyQualifiedName, (Object)text.fullyQualifiedName);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.fullyQualifiedName});
    }

    @NotNull
    public String toString() {
        List<String> scopeNameParts = GradleNameElement.split(this.scope.getQualifiedName());
        List<String> resultParts = GradleNameElement.split(this.elementModel.getFullyQualifiedName());
        int r = 0;
        int s = 0;
        if ("buildscript".equals(scopeNameParts.get(s))) {
            ++s;
        }
        if ("buildscript".equals(resultParts.get(r))) {
            ++r;
        }
        if ("ext".equals(scopeNameParts.get(s))) {
            ++s;
        }
        if ("ext".equals(resultParts.get(r))) {
            ++r;
        }
        if (r >= resultParts.size()) {
            String string = GradleNameElement.join(resultParts);
            if (string == null) {
                ReferenceTo.$$$reportNull$$$0(7);
            }
            return string;
        }
        while (r < resultParts.size() && s < scopeNameParts.size() && Objects.equals(resultParts.get(r), scopeNameParts.get(s))) {
            ++r;
            ++s;
        }
        String string = GradleNameElement.join(resultParts.subList(r, resultParts.size()));
        if (string == null) {
            ReferenceTo.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referredElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/api/ext/ReferenceTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/api/ext/ReferenceTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferredElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceFromText";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

