/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitReferenceValidator;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class GitResetDialog
extends DialogWrapper {
    private JComboBox myGitRootComboBox;
    private JLabel myCurrentBranchLabel;
    private ComboBox<ResetMode> myResetTypeComboBox;
    private JTextField myCommitTextField;
    private JButton myValidateButton;
    private JPanel myPanel;
    private final Project myProject;
    private final GitReferenceValidator myGitReferenceValidator;

    public GitResetDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.message("reset.title", objectArray));
        this.setOKButtonText(GitBundle.message("git.reset.button", new Object[0]));
        this.myResetTypeComboBox.addItem((Object)ResetMode.MIXED);
        this.myResetTypeComboBox.addItem((Object)ResetMode.SOFT);
        this.myResetTypeComboBox.addItem((Object)ResetMode.HARD);
        this.myResetTypeComboBox.setSelectedItem((Object)ResetMode.MIXED);
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranchLabel);
        this.myGitReferenceValidator = new GitReferenceValidator(this.myProject, this.myGitRootComboBox, this.myCommitTextField, this.myValidateButton, () -> this.validateFields());
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCommitTextField;
    }

    void validateFields() {
        if (this.myGitReferenceValidator.isInvalid()) {
            this.setErrorText(GitBundle.message("reset.commit.invalid", new Object[0]));
            this.setOKActionEnabled(false);
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public GitLineHandler handler() {
        GitLineHandler handler = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.RESET);
        ResetMode type = (ResetMode)((Object)this.myResetTypeComboBox.getItem());
        if (type == ResetMode.SOFT) {
            handler.addParameters("--soft");
        } else if (type == ResetMode.HARD) {
            handler.addParameters("--hard");
        } else if (type == ResetMode.MIXED) {
            handler.addParameters("--mixed");
        }
        String commit = this.myCommitTextField.getText().trim();
        if (!commit.isEmpty()) {
            handler.addParameters(commit);
        }
        handler.endOptions();
        return handler;
    }

    public VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "gitResetHead";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        ComboBox comboBox;
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranchLabel = jLabel = new JLabel();
        jLabel.setText("");
        jLabel.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("reset.type"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myResetTypeComboBox = comboBox = new ComboBox();
        comboBox.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("reset.type.tooltip"));
        jPanel2.add((Component)comboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("reset.commit.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCommitTextField = jTextField = new JTextField();
        jTextField.setText("HEAD");
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("reset.commit.tooltip"));
        jPanel3.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValidateButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/GitBundle", GitResetDialog.class).getString("reset.validate"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)comboBox);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum ResetMode {
        SOFT("git.reset.mode.soft"),
        MIXED("git.reset.mode.mixed"),
        HARD("git.reset.mode.hard");

        private final String myId;

        private ResetMode(String id) {
            if (id == null) {
                ResetMode.$$$reportNull$$$0(0);
            }
            this.myId = id;
        }

        public String toString() {
            return GitBundle.message(this.myId, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "git4idea/ui/GitResetDialog$ResetMode", "<init>"));
        }
    }
}

