/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class FreezeDetector {
    private static final Logger LOG = Logger.getInstance(FreezeDetector.class);
    private static final long SLEEP_INTERVAL_MS = 5000L;
    private static final long EXPECTED_DELTA_MS = 7000L;
    private volatile boolean myStopped;
    private long myPeriodBegin = -1L;
    private final List<TimeRange> myPeriods = Collections.synchronizedList(new ArrayList());

    public void start() {
        Thread thread = new Thread(() -> this.runDetectLoop(), "FreezeDetector Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAdjustedDuration(long begin, long end) {
        long duration = end - begin;
        List<TimeRange> list = this.myPeriods;
        synchronized (list) {
            for (TimeRange freeze : this.myPeriods) {
                long freezeStart = freeze.begin;
                if (freezeStart <= begin || freezeStart >= end) continue;
                duration -= Math.min(end, freeze.end) - freezeStart;
            }
        }
        return duration;
    }

    private void runDetectLoop() {
        while (!this.myStopped) {
            long pauseDuration = this.checkFreeze();
            if (pauseDuration <= 0L) continue;
            try {
                Thread.sleep(pauseDuration);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private long checkFreeze() {
        long current = System.currentTimeMillis();
        long previous = this.myPeriodBegin;
        if (previous > 0L && current - previous > 7000L) {
            this.myPeriods.add(new TimeRange(previous, current));
            LOG.info("System sleep/hibernate detected from " + String.valueOf(new Date(previous)) + " till " + String.valueOf(new Date(current)) + "; " + StringUtil.formatDuration((long)(current - previous)));
        }
        this.myPeriodBegin = current;
        return 5000L - (System.currentTimeMillis() - current);
    }

    public static final class TimeRange {
        public final long begin;
        public final long end;

        public TimeRange(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

