/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigDescribableElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptorUtilKt;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnsetValueDescriptor;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.editorconfig.language.util.EditorConfigTextMatchingUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "getInvertedValue", "element", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigDescribableElement;", "value", "union", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigUnionDescriptor;", "getDescribableElement", "file", "descriptor", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "constantMatches", "findUnionDescriptor", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigInvertValueIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigInvertValueIntention.kt\norg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,72:1\n67#2:73\n*S KotlinDebug\n*F\n+ 1 EditorConfigInvertValueIntention.kt\norg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention\n*L\n55#1:73\n*E\n"})
public final class EditorConfigInvertValueIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value", new Object[0]);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, psiFile);
        if (editorConfigDescribableElement == null) {
            return false;
        }
        EditorConfigDescribableElement value = editorConfigDescribableElement;
        return this.getInvertedValue(value) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, psiFile);
        if (editorConfigDescribableElement == null) {
            return;
        }
        EditorConfigDescribableElement optionValue = editorConfigDescribableElement;
        String string = this.getInvertedValue(optionValue);
        if (string == null) {
            return;
        }
        String notValue = string;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        TextRange textRange = optionValue.getTextRange();
        document2.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)notValue);
    }

    private final String getInvertedValue(EditorConfigDescribableElement element) {
        EditorConfigUnionDescriptor descriptor = this.findUnionDescriptor(EditorConfigDescriptorUtilKt.getDescriptor(element, true));
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this.getInvertedValue(string, descriptor);
    }

    private final String getInvertedValue(String value, EditorConfigUnionDescriptor union) {
        Object object = union;
        if (!(object != null && (object = ((EditorConfigUnionDescriptor)object).getChildren()) != null ? object.size() == 2 : false)) {
            return null;
        }
        EditorConfigDescriptor first = union.getChildren().get(0);
        EditorConfigDescriptor second = union.getChildren().get(1);
        return this.constantMatches(first, value) ? this.getText(second) : (this.constantMatches(second, value) ? this.getText(first) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final EditorConfigDescribableElement getDescribableElement(Editor editor, PsiFile file) {
        EditorConfigDescribableElement editorConfigDescribableElement;
        PsiElement psiElement = EditorConfigPsiTreeUtil.INSTANCE.findIdentifierUnderCaret(editor, file);
        if (psiElement != null) {
            void $this$parentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            editorConfigDescribableElement = (EditorConfigDescribableElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, EditorConfigDescribableElement.class, (boolean)false);
        } else {
            editorConfigDescribableElement = null;
        }
        return editorConfigDescribableElement;
    }

    private final String getText(EditorConfigDescriptor descriptor) {
        if (!(descriptor instanceof EditorConfigConstantDescriptor)) {
            return null;
        }
        return ((EditorConfigConstantDescriptor)descriptor).getText();
    }

    private final boolean constantMatches(EditorConfigDescriptor descriptor, String value) {
        if (!(descriptor instanceof EditorConfigConstantDescriptor)) {
            return false;
        }
        return EditorConfigTextMatchingUtil.INSTANCE.textMatchesToIgnoreCase(((EditorConfigConstantDescriptor)descriptor).getText(), (CharSequence)value);
    }

    private final EditorConfigUnionDescriptor findUnionDescriptor(EditorConfigDescriptor descriptor) {
        if (descriptor instanceof EditorConfigUnsetValueDescriptor) {
            return null;
        }
        EditorConfigDescriptor editorConfigDescriptor = descriptor;
        EditorConfigDescriptor editorConfigDescriptor2 = editorConfigDescriptor != null ? editorConfigDescriptor.getParent() : null;
        return editorConfigDescriptor2 instanceof EditorConfigUnionDescriptor ? (EditorConfigUnionDescriptor)editorConfigDescriptor2 : null;
    }
}

