/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerDownloadListenerWrapper;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerLoggerWrapper;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MavenWatchdogAware;
import org.jetbrains.idea.maven.server.security.MavenToken;

public abstract class MavenServerBase
extends MavenWatchdogAware
implements MavenServer {
    @Override
    public MavenPullServerLogger createPullLogger(MavenToken token) {
        MavenServerUtil.checkToken(token);
        try {
            MavenServerLoggerWrapper result = MavenServerGlobals.getLogger();
            UnicastRemoteObject.exportObject((Remote)result, 0);
            return result;
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @Override
    public MavenPullDownloadListener createPullDownloadListener(MavenToken token) {
        MavenServerUtil.checkToken(token);
        try {
            MavenServerDownloadListenerWrapper result = MavenServerGlobals.getDownloadListener();
            UnicastRemoteObject.exportObject((Remote)result, 0);
            return result;
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    public synchronized void unreferenced() {
        System.exit(0);
    }
}

