/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tools.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzedTokenReadings
implements Iterable<AnalyzedToken> {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzedTokenReadings.class);
    private static final Pattern NON_WORD_REGEX = Pattern.compile("[.?!\u2026:;,~\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]\\-\u2013\u2014*\u00d7\u2217\u00b7+\u00f7/=]");
    private final boolean isWhitespace;
    private final boolean isLinebreak;
    private final boolean isSentStart;
    private final boolean isPosTagUnknown;
    private AnalyzedToken[] anTokReadings;
    private int startPos;
    private int fixPos;
    private String token;
    private String cleanToken;
    private List<ChunkTag> chunkTags = Collections.emptyList();
    private boolean isSentEnd;
    private boolean isParaEnd;
    private boolean isWhitespaceBefore;
    private String whitespaceBeforeChar;
    private boolean hasTypographicApostrophe = false;
    private boolean isImmunized;
    private int immunizationSourceLine;
    private boolean isIgnoredBySpeller;
    private String historicalAnnotations = "";
    private boolean hasSameLemmas;

    public AnalyzedTokenReadings(AnalyzedToken[] tokens, int startPos) {
        this(Arrays.asList(tokens), startPos);
    }

    public AnalyzedTokenReadings(AnalyzedToken token, int startPos) {
        this(Collections.singletonList(token), startPos);
    }

    public AnalyzedTokenReadings(List<AnalyzedToken> tokens, int startPos) {
        this.anTokReadings = tokens.toArray(new AnalyzedToken[0]);
        this.startPos = startPos;
        this.token = this.anTokReadings[0].getToken();
        this.isWhitespace = StringTools.isWhitespace(this.token);
        this.isWhitespaceBefore = this.anTokReadings[0].isWhitespaceBefore();
        this.isLinebreak = "\n".equals(this.token) || "\r\n".equals(this.token) || "\r".equals(this.token) || "\n\r".equals(this.token);
        this.isSentStart = "SENT_START".equals(this.anTokReadings[0].getPOSTag());
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.isPosTagUnknown = tokens.size() == 1 && tokens.get(0).getPOSTag() == null;
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
        this.whitespaceBeforeChar = "";
    }

    public AnalyzedTokenReadings(AnalyzedTokenReadings oldAtr, List<AnalyzedToken> newReadings, String ruleApplied) {
        this(newReadings, oldAtr.getStartPos());
        if (oldAtr.isSentenceEnd()) {
            this.setSentEnd();
        }
        if (oldAtr.isParagraphEnd()) {
            this.setParagraphEnd();
        }
        this.setWhitespaceBefore(oldAtr.getWhitespaceBefore());
        this.setChunkTags(oldAtr.getChunkTags());
        if (oldAtr.isImmunized()) {
            this.immunize(oldAtr.getImmunizationSourceLine());
        }
        if (oldAtr.isIgnoredBySpeller()) {
            this.ignoreSpelling();
        }
        if (oldAtr.hasTypographicApostrophe()) {
            this.setTypographicApostrophe();
        }
        this.setHistoricalAnnotations(oldAtr.getHistoricalAnnotations());
        this.addHistoricalAnnotations(oldAtr.toString(), ruleApplied);
    }

    public AnalyzedTokenReadings(AnalyzedToken token) {
        this(Collections.singletonList(token), 0);
    }

    public List<AnalyzedToken> getReadings() {
        return Arrays.asList(this.anTokReadings);
    }

    public AnalyzedToken getAnalyzedToken(int idx) {
        return this.anTokReadings[idx];
    }

    public boolean hasPosTag(String posTag) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (!posTag.equals(reading.getPOSTag())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPosTagAndLemma(String posTag, String lemma) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (!posTag.equals(reading.getPOSTag()) || !lemma.equals(reading.getLemma())) continue;
            return true;
        }
        return false;
    }

    public boolean hasReading() {
        return this.anTokReadings != null && this.anTokReadings.length > 0;
    }

    public boolean hasLemma(String lemma) {
        boolean found = false;
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getLemma() == null || !lemma.equals(reading.getLemma())) continue;
            return true;
        }
        return found;
    }

    public boolean hasAnyLemma(String ... lemmas) {
        for (String lemma : lemmas) {
            for (AnalyzedToken reading : this.anTokReadings) {
                if (!lemma.equals(reading.getLemma())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPartialPosTag(String posTag) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !reading.getPOSTag().contains(posTag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPartialPosTag(String ... posTags) {
        for (String posTag : posTags) {
            if (!this.hasPartialPosTag(posTag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPosTagStartingWith(String posTag) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !reading.getPOSTag().startsWith(posTag)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPosTagRegex(String posTagRegex) {
        Pattern pattern = Pattern.compile(posTagRegex);
        return this.matchesPosTagRegex(pattern);
    }

    public boolean matchesPosTagRegex(Pattern pattern) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !pattern.matcher(reading.getPOSTag()).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean matchesChunkRegex(String chunkRegex) {
        Pattern pattern = Pattern.compile(chunkRegex);
        for (ChunkTag chunk : this.getChunkTags()) {
            if (chunk == null || !pattern.matcher(chunk.getChunkTag()).matches()) continue;
            return true;
        }
        return false;
    }

    public AnalyzedToken readingWithTagRegex(String posTagRegex) {
        Pattern pattern = Pattern.compile(posTagRegex);
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !pattern.matcher(reading.getPOSTag()).matches()) continue;
            return reading;
        }
        return null;
    }

    public AnalyzedToken readingWithTagRegex(Pattern pattern) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !pattern.matcher(reading.getPOSTag()).matches()) continue;
            return reading;
        }
        return null;
    }

    public AnalyzedToken readingWithLemma(String lemma) {
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getLemma() == null || !reading.getLemma().equals(lemma)) continue;
            return reading;
        }
        return null;
    }

    public void addReading(AnalyzedToken token, String ruleApplied) {
        String oldValue = this.toString();
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>(Arrays.asList(this.anTokReadings).subList(0, this.anTokReadings.length - 1));
        if (this.anTokReadings[this.anTokReadings.length - 1].getPOSTag() != null) {
            l.add(this.anTokReadings[this.anTokReadings.length - 1]);
        }
        token.setWhitespaceBefore(this.isWhitespaceBefore);
        l.add(token);
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        if (token.getToken().length() > this.token.length()) {
            this.token = token.getToken();
        }
        this.anTokReadings[this.anTokReadings.length - 1].setWhitespaceBefore(this.isWhitespaceBefore);
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
        this.addHistoricalAnnotations(oldValue, ruleApplied);
    }

    public void removeReading(AnalyzedToken token, String ruleApplied) {
        String oldValue = this.toString();
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        boolean removedSentEnd = false;
        boolean removedParaEnd = false;
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (!anTokReading.matches(tmpTok)) {
                l.add(anTokReading);
                continue;
            }
            if ("SENT_END".equals(anTokReading.getPOSTag())) {
                removedSentEnd = true;
                continue;
            }
            if (!"PARA_END".equals(anTokReading.getPOSTag())) continue;
            removedParaEnd = true;
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        this.setNoRealPOStag();
        if (removedSentEnd) {
            this.isSentEnd = false;
            this.setSentEnd();
        }
        if (removedParaEnd) {
            this.isParaEnd = false;
            this.setParagraphEnd();
        }
        this.hasSameLemmas = this.areLemmasSame();
        this.addHistoricalAnnotations(oldValue, ruleApplied);
    }

    public void leaveReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (!anTokReading.matches(tmpTok)) continue;
            l.add(anTokReading);
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public int getReadingsLength() {
        return this.anTokReadings.length;
    }

    public boolean isWhitespace() {
        return this.isWhitespace;
    }

    public boolean isLinebreak() {
        return this.isLinebreak;
    }

    public boolean isSentenceStart() {
        return this.isSentStart;
    }

    public boolean isParagraphEnd() {
        return this.isParaEnd;
    }

    public void setParagraphEnd() {
        if (!this.isParagraphEnd()) {
            AnalyzedToken paragraphEnd = new AnalyzedToken(this.getToken(), "PARA_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(paragraphEnd, "add_paragaph_end");
        }
    }

    public boolean isSentenceEnd() {
        return this.isSentEnd;
    }

    public boolean isFieldCode() {
        return "\u0001".equals(this.token) || "\u0002".equals(this.token);
    }

    public void setSentEnd() {
        if (!this.isSentenceEnd()) {
            AnalyzedToken sentenceEnd = new AnalyzedToken(this.getToken(), "SENT_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(sentenceEnd, "");
        }
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.startPos + this.token.length();
    }

    public void setStartPos(int position) {
        this.startPos = position;
    }

    public void setPosFix(int fix) {
        this.fixPos = fix;
    }

    public int getPosFix() {
        return this.fixPos;
    }

    public String getToken() {
        return this.token;
    }

    public void setWhitespaceBefore(String prevToken) {
        this.isWhitespaceBefore = !prevToken.isEmpty() && StringTools.isWhitespace(prevToken);
        for (AnalyzedToken aTok : this.anTokReadings) {
            aTok.setWhitespaceBefore(this.isWhitespaceBefore);
        }
        if (this.isWhitespaceBefore) {
            this.whitespaceBeforeChar = prevToken;
        }
    }

    public String getWhitespaceBefore() {
        return this.whitespaceBeforeChar;
    }

    public boolean isWhitespaceBefore() {
        return this.isWhitespaceBefore;
    }

    public void immunize(int sourceLine) {
        this.isImmunized = true;
        this.immunizationSourceLine = sourceLine;
    }

    public boolean isImmunized() {
        if (this.isImmunized && logger.isDebugEnabled()) {
            logger.debug("'" + this.getToken() + "' is immunized by antipattern in line " + this.immunizationSourceLine);
        }
        return this.isImmunized;
    }

    public int getImmunizationSourceLine() {
        return this.immunizationSourceLine;
    }

    public void ignoreSpelling() {
        this.isIgnoredBySpeller = true;
    }

    public boolean isIgnoredBySpeller() {
        return this.isIgnoredBySpeller;
    }

    public boolean isPosTagUnknown() {
        return this.isPosTagUnknown;
    }

    private void setNoRealPOStag() {
        boolean hasNoPOStag = !this.isLinebreak();
        for (AnalyzedToken an : this.anTokReadings) {
            String posTag = an.getPOSTag();
            if ("PARA_END".equals(posTag) || "SENT_END".equals(posTag) || posTag == null) continue;
            hasNoPOStag = false;
            break;
        }
        for (AnalyzedToken an : this.anTokReadings) {
            an.setNoPOSTag(hasNoPOStag);
        }
    }

    public String getHistoricalAnnotations() {
        return this.historicalAnnotations;
    }

    private void setHistoricalAnnotations(String historicalAnnotations) {
        if (GlobalConfig.isVerbose()) {
            this.historicalAnnotations = historicalAnnotations;
        }
    }

    private void addHistoricalAnnotations(String oldValue, String ruleApplied) {
        if (!ruleApplied.isEmpty() && GlobalConfig.isVerbose()) {
            this.historicalAnnotations = this.getHistoricalAnnotations() + "\n" + ruleApplied + ": " + oldValue + " -> " + String.valueOf(this);
        }
    }

    public void setChunkTags(List<ChunkTag> chunkTags) {
        this.chunkTags = Objects.requireNonNull(chunkTags);
    }

    public List<ChunkTag> getChunkTags() {
        return this.chunkTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.token);
        sb.append('[');
        for (AnalyzedToken element : this.anTokReadings) {
            sb.append(element);
            if (!element.isWhitespaceBefore()) {
                sb.append('*');
            }
            sb.append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        if (!this.chunkTags.isEmpty()) {
            sb.append(',');
            sb.append(StringUtils.join(this.chunkTags, (String)"|"));
        }
        sb.append(']');
        if (this.isImmunized()) {
            sb.append("{!},");
        }
        return sb.toString();
    }

    public boolean isTagged() {
        for (AnalyzedToken element : this.anTokReadings) {
            if (element.hasNoTag()) continue;
            return true;
        }
        return false;
    }

    private boolean areLemmasSame() {
        String previousLemma = this.anTokReadings[0].getLemma();
        if (previousLemma == null) {
            for (AnalyzedToken element : this.anTokReadings) {
                if (element.getLemma() == null) continue;
                return false;
            }
            return true;
        }
        for (AnalyzedToken element : this.anTokReadings) {
            if (previousLemma.equals(element.getLemma())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameLemmas() {
        return this.hasSameLemmas;
    }

    public boolean isNonWord() {
        return NON_WORD_REGEX.matcher(this.token).matches();
    }

    public int hashCode() {
        return Arrays.hashCode(this.anTokReadings) + Objects.hash(this.isLinebreak, this.isParaEnd, this.isSentEnd, this.isSentStart, this.isWhitespace, this.isWhitespaceBefore, this.chunkTags, this.startPos, this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedTokenReadings other = (AnalyzedTokenReadings)obj;
        return new EqualsBuilder().append((Object[])this.anTokReadings, (Object[])other.anTokReadings).append(this.isLinebreak, other.isLinebreak).append(this.isParaEnd, other.isParaEnd).append(this.isSentEnd, other.isSentEnd).append(this.isSentStart, other.isSentStart).append(this.isWhitespace, other.isWhitespace).append(this.isWhitespaceBefore, other.isWhitespaceBefore).append(this.isImmunized, other.isImmunized).append(this.startPos, other.startPos).append(this.chunkTags, other.chunkTags).append(this.hasSameLemmas, other.hasSameLemmas).append(this.isIgnoredBySpeller, other.isIgnoredBySpeller).append((Object)this.token, (Object)other.token).append(this.hasTypographicApostrophe, other.hasTypographicApostrophe).isEquals();
    }

    @Override
    @NotNull
    public Iterator<AnalyzedToken> iterator() {
        final AtomicInteger i = new AtomicInteger(0);
        return new Iterator<AnalyzedToken>(){

            @Override
            public boolean hasNext() {
                return i.get() < AnalyzedTokenReadings.this.getReadingsLength();
            }

            @Override
            public AnalyzedToken next() {
                try {
                    return AnalyzedTokenReadings.this.anTokReadings[i.getAndAdd(1)];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException("No such element: " + String.valueOf(i) + ", element count: " + AnalyzedTokenReadings.this.anTokReadings.length);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Experimental
    public void setCleanToken(String cleanToken) {
        this.cleanToken = cleanToken;
    }

    @Experimental
    public String getCleanToken() {
        return this.cleanToken != null ? this.cleanToken : this.token;
    }

    public void setTypographicApostrophe() {
        this.hasTypographicApostrophe = true;
    }

    public boolean hasTypographicApostrophe() {
        return this.hasTypographicApostrophe;
    }
}

