/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.impl.fs.EelReadFileImplKt;
import com.intellij.platform.eel.impl.fs.LocalEelFileSystemApiKt;
import com.intellij.platform.eel.impl.fs.LocalEelOpenedFileReader;
import com.intellij.platform.eel.impl.fs.LocalEelOpenedFileWriter;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0004J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0010J8\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\f\"\u0004\b\u0000\u0010\u0012\"\n\b\u0001\u0010\u0013\u0018\u0001*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0086\b\u00f8\u0001\u0000JJ\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\f\"\u0004\b\u0000\u0010\u0012\"\n\b\u0001\u0010\u0013\u0018\u0001*\u00020\u00142\u0010\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0086\b\u00f8\u0001\u0000J(\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0004\u0012\u00020\u001d0\f2\u0006\u0010\u000f\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0010J>\u0010\u001e\u001a\"\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u001f0\u001b\u0012\u0004\u0012\u00020\u001d0\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020%0\f2\u0006\u0010\u000f\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0010J,\u0010&\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020 \u0012\u0004\u0012\u00020'0\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010#J*\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)0\f2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010,J\"\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0\f2\u0006\u00100\u001a\u000201H\u0096@\u00a2\u0006\u0002\u00102J3\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020/0\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u00105\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u00108J\"\u00109\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020/0\f2\u0006\u00100\u001a\u00020;H\u0096@\u00a2\u0006\u0002\u0010<J\"\u0010=\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0\f2\u0006\u0010@\u001a\u00020AH\u0096@\u00a2\u0006\u0002\u0010BJ\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010@\u001a\u00020AH\u0002J\"\u0010F\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020?0\f2\u0006\u0010@\u001a\u00020AH\u0096@\u00a2\u0006\u0002\u0010BJ*\u0010H\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020J0\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010LJ\"\u0010M\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020N0\f2\u0006\u0010@\u001a\u00020OH\u0096@\u00a2\u0006\u0002\u0010PJ:\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020R0\f2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010VR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006W"}, d2={"Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "fs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/nio/file/FileSystem;)V", "getFs", "()Ljava/nio/file/FileSystem;", "toNioPath", "Ljava/nio/file/Path;", "Lcom/intellij/platform/eel/path/EelPath;", "getDiskInfo", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$DiskInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$DiskInfoError;", "path", "(Lcom/intellij/platform/eel/path/EelPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wrapIntoEelResult", "T", "E", "Lcom/intellij/platform/eel/fs/EelFsError;", "body", "Lkotlin/Function0;", "isClosed", "Ljava/util/concurrent/atomic/AtomicReference;", "", "listDirectory", "", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ListDirectoryError;", "listDirectoryWithAttrs", "Lkotlin/Pair;", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "symlinkPolicy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canonicalize", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CanonicalizeError;", "stat", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$StatError;", "sameFile", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SameFileError;", "source", "target", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/path/EelPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openForReading", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileReaderError;", "args", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$OpenForReadingArgs;", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi$OpenForReadingArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openForReadingImpl", "Lcom/intellij/platform/eel/impl/fs/LocalEelOpenedFileReader;", "autoCloseAfterLastChunk", "closeImmediatelyIfFileBiggerThan", "", "(Lcom/intellij/platform/eel/path/EelPath;ZLjava/lang/Long;)Lcom/intellij/platform/eel/EelResult;", "readFile", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReadFileResult;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReadFileArgs;", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReadFileArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openForWriting", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileWriterError;", "options", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WriteOptions;", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi$WriteOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeOptionsToNioOptions", "", "Ljava/nio/file/StandardOpenOption;", "openForReadingAndWriting", "Lcom/intellij/platform/eel/fs/EelOpenedFile$ReaderWriter;", "delete", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$DeleteError;", "removeContent", "(Lcom/intellij/platform/eel/path/EelPath;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CopyError;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CopyOptions;", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi$CopyOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "move", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$MoveError;", "replaceExisting", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReplaceExistingDuringMove;", "followLinks", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReplaceExistingDuringMove;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nLocalEelFileSystemApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1029:1\n54#1,28:1030\n51#1,5:1058\n56#1,26:1066\n51#1,5:1092\n56#1,26:1102\n51#1,31:1128\n51#1,31:1159\n51#1,31:1190\n51#1,31:1221\n51#1,31:1252\n51#1,31:1283\n51#1,31:1314\n51#1,5:1345\n56#1,26:1352\n51#1,31:1378\n1163#2,3:1063\n1152#2:1097\n1321#2:1098\n1322#2:1100\n1153#2:1101\n1#3:1099\n37#4,2:1350\n*S KotlinDebug\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n*L\n51#1:1030,28\n84#1:1058,5\n84#1:1066,26\n93#1:1092,5\n93#1:1102,26\n109#1:1128,31\n118#1:1159,31\n124#1:1190,31\n151#1:1221,31\n184#1:1252,31\n211#1:1283,31\n231#1:1314,31\n254#1:1345,5\n254#1:1352,26\n271#1:1378,31\n86#1:1063,3\n95#1:1097\n95#1:1098\n95#1:1100\n95#1:1101\n95#1:1099\n261#1:1350,2\n*E\n"})
public abstract class NioBasedEelFileSystemApi
implements EelFileSystemApi {
    @VisibleForTesting
    @NotNull
    private final FileSystem fs;

    public NioBasedEelFileSystemApi(@NotNull FileSystem fs2) {
        Intrinsics.checkNotNullParameter((Object)fs2, (String)"fs");
        this.fs = fs2;
    }

    @NotNull
    public final FileSystem getFs() {
        return this.fs;
    }

    @NotNull
    protected final Path toNioPath(@NotNull EelPath $this$toNioPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toNioPath, (String)"<this>");
        Path path = this.fs.getPath($this$toNioPath.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @Nullable
    public Object getDiskInfo(@NotNull EelPath path, @NotNull Continuation<? super EelResult<? extends EelFileSystemApi.DiskInfo, ? extends EelFileSystemApi.DiskInfoError>> $completion) {
        return NioBasedEelFileSystemApi.getDiskInfo$suspendImpl(this, path, $completion);
    }

    static /* synthetic */ Object getDiskInfo$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, Continuation<? super EelResult<? extends EelFileSystemApi.DiskInfo, ? extends EelFileSystemApi.DiskInfoError>> $completion) {
        FileStore fileStore = Files.getFileStore($this.toNioPath(path));
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
        FileStore store = fileStore;
        return new EelFsResultImpl.Ok<EelFsResultImpl.DiskInfoImpl>(new EelFsResultImpl.DiskInfoImpl(ULong.constructor-impl((long)store.getTotalSpace()), ULong.constructor-impl((long)store.getUsableSpace()), null));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T, E extends EelFsError> EelResult<T, E> wrapIntoEelResult(Function0<? extends T> body) {
        EelResult eelResult;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this;
        Object isClosed$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            EelFsResultImpl.Ok<Object> result$iv = new EelFsResultImpl.Ok<Object>(body.invoke());
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError eelFsError2;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            EelFsError err$iv2 = eelFsError2;
            Intrinsics.reifiedOperationMarker((int)2, (String)"E");
            EelFsError eelFsError3 = err$iv2;
            if (eelFsError3 != null) {
                eelFsError = eelFsError3;
            } else {
                EelFsResultImpl.Other other = new EelFsResultImpl.Other(path$iv, err$iv2.getMessage());
                Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                eelFsError = (EelFsError)other;
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    public final /* synthetic */ <T, E extends EelFsError> EelResult<T, E> wrapIntoEelResult(AtomicReference<Boolean> isClosed, Function0<? extends T> body) {
        EelResult eelResult;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$wrapIntoEelResult = false;
        try {
            EelFsResultImpl.Ok<Object> result = new EelFsResultImpl.Ok<Object>(body.invoke());
            AtomicReference<Boolean> atomicReference = isClosed;
            if (atomicReference != null) {
                atomicReference.updateAndGet(wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result;
        }
        catch (FileSystemException err) {
            EelFsError eelFsError;
            EelFsError eelFsError2;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                Iterable<Path> iterable = this.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path = eelPath;
            FileSystemException fileSystemException = err;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.PermissionDenied(path, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.DoesNotExist(path, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.AlreadyExists(path, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.NotDirectory(path, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path, string);
            } else {
                String string = err.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError2 = (EelFsError)new EelFsResultImpl.Other(path, string);
            }
            EelFsError err2 = eelFsError2;
            Intrinsics.reifiedOperationMarker((int)2, (String)"E");
            EelFsError eelFsError3 = err2;
            if (eelFsError3 != null) {
                eelFsError = eelFsError3;
            } else {
                EelFsResultImpl.Other other = new EelFsResultImpl.Other(path, err2.getMessage());
                Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                eelFsError = (EelFsError)other;
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object listDirectory(@NotNull EelPath path, @NotNull Continuation<? super EelResult<? extends Collection<String>, ? extends EelFileSystemApi.ListDirectoryError>> $completion) {
        return NioBasedEelFileSystemApi.listDirectory$suspendImpl(this, path, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ Object listDirectory$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, Continuation<? super EelResult<? extends Collection<String>, ? extends EelFileSystemApi.ListDirectoryError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            List list;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.list($this.toNioPath(path));
            Throwable throwable = null;
            try {
                void destination$iv;
                void $this$mapTo$iv;
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)stream);
                Sequence sequence = StreamsKt.asSequence((Stream)stream);
                Collection collection = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Path path2 = (Path)item$iv;
                    void var19_25 = destination$iv;
                    boolean bl3 = false;
                    var19_25.add(((Object)it.getFileName()).toString());
                }
                list = (List)destination$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List list2 = list;
            EelFsResultImpl.Ok<List> result$iv$iv = new EelFsResultImpl.Ok<List>(list2);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            try {
                bl = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = bl;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.ListDirectoryError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.ListDirectoryError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.ListDirectoryError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object listDirectoryWithAttrs(@NotNull EelPath path, @NotNull EelFileSystemApi.SymlinkPolicy symlinkPolicy, @NotNull Continuation<? super EelResult<? extends Collection<? extends Pair<String, ? extends EelFileInfo>>, ? extends EelFileSystemApi.ListDirectoryError>> $completion) {
        return NioBasedEelFileSystemApi.listDirectoryWithAttrs$suspendImpl(this, path, symlinkPolicy, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ Object listDirectoryWithAttrs$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, EelFileSystemApi.SymlinkPolicy symlinkPolicy, Continuation<? super EelResult<? extends Collection<? extends Pair<String, ? extends EelFileInfo>>, ? extends EelFileSystemApi.ListDirectoryError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            List list;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.list($this.toNioPath(path));
            Throwable throwable = null;
            try {
                void destination$iv;
                void $this$mapNotNullTo$iv;
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)stream);
                Sequence sequence = StreamsKt.asSequence((Stream)stream);
                Collection collection = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair it$iv;
                    Pair pair;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    Path child = (Path)element$iv;
                    boolean bl4 = false;
                    try {
                        Intrinsics.checkNotNull((Object)child);
                        EelFileInfo fileAttributes = LocalEelFileSystemApiKt.access$getFileAttributes(child, symlinkPolicy);
                        pair = TuplesKt.to((Object)((Object)child.getFileName()).toString(), (Object)fileAttributes);
                    }
                    catch (FileSystemException fileSystemException) {
                        pair = null;
                    }
                    if (pair == null) continue;
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                list = (List)destination$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List list2 = list;
            EelFsResultImpl.Ok<List> result$iv$iv = new EelFsResultImpl.Ok<List>(list2);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.ListDirectoryError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.ListDirectoryError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.ListDirectoryError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object canonicalize(@NotNull EelPath path, @NotNull Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CanonicalizeError>> $completion) {
        return NioBasedEelFileSystemApi.canonicalize$suspendImpl(this, path, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object canonicalize$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CanonicalizeError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            Path realPath = $this.toNioPath(path).toRealPath(new LinkOption[0]);
            EelPath eelPath = EelPath.Companion.parse(((Object)realPath).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            EelFsResultImpl.Ok<EelPath> result$iv$iv = new EelFsResultImpl.Ok<EelPath>(eelPath);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            try {
                bl = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = bl;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.CanonicalizeError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.CanonicalizeError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.CanonicalizeError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object stat(@NotNull EelPath path, @NotNull EelFileSystemApi.SymlinkPolicy symlinkPolicy, @NotNull Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
        return NioBasedEelFileSystemApi.stat$suspendImpl(this, path, symlinkPolicy, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object stat$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, EelFileSystemApi.SymlinkPolicy symlinkPolicy, Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            EelFileInfo eelFileInfo = LocalEelFileSystemApiKt.access$getFileAttributes($this.toNioPath(path), symlinkPolicy);
            EelFsResultImpl.Ok<EelFileInfo> result$iv$iv = new EelFsResultImpl.Ok<EelFileInfo>(eelFileInfo);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.StatError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.StatError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.StatError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object sameFile(@NotNull EelPath source, @NotNull EelPath target, @NotNull Continuation<? super EelResult<Boolean, ? extends EelFileSystemApi.SameFileError>> $completion) {
        return NioBasedEelFileSystemApi.sameFile$suspendImpl(this, source, target, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object sameFile$suspendImpl(NioBasedEelFileSystemApi $this, EelPath source, EelPath target, Continuation<? super EelResult<Boolean, ? extends EelFileSystemApi.SameFileError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            Boolean bl2 = Boxing.boxBoolean((boolean)Files.isSameFile($this.toNioPath(source), $this.toNioPath(target)));
            EelFsResultImpl.Ok<Boolean> result$iv$iv = new EelFsResultImpl.Ok<Boolean>(bl2);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.SameFileError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.SameFileError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.SameFileError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object openForReading(@NotNull EelFileSystemApi.OpenForReadingArgs args, @NotNull Continuation<? super EelResult<? extends EelOpenedFile.Reader, ? extends EelFileSystemApi.FileReaderError>> $completion) {
        return NioBasedEelFileSystemApi.openForReading$suspendImpl(this, args, $completion);
    }

    static /* synthetic */ Object openForReading$suspendImpl(NioBasedEelFileSystemApi $this, EelFileSystemApi.OpenForReadingArgs args, Continuation<? super EelResult<? extends EelOpenedFile.Reader, ? extends EelFileSystemApi.FileReaderError>> $completion) {
        EelResult<LocalEelOpenedFileReader, EelFileSystemApi.FileReaderError> result;
        block0: {
            result = $this.openForReadingImpl(args.getPath(), args.getAutoCloseAfterLastChunk(), args.getCloseImmediatelyIfFileBiggerThan());
            ByteBuffer byteBuffer = args.getReadFirstChunkInto();
            if (byteBuffer == null) break block0;
            ByteBuffer $this$openForReading_u24lambda_u240 = byteBuffer;
            boolean bl = false;
            $this$openForReading_u24lambda_u240.position(0);
            $this$openForReading_u24lambda_u240.limit(0);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final EelResult<LocalEelOpenedFileReader, EelFileSystemApi.FileReaderError> openForReadingImpl(EelPath path, boolean autoCloseAfterLastChunk, Long closeImmediatelyIfFileBiggerThan) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            Path nioPath = this.toNioPath(path);
            SeekableByteChannel seekableByteChannel = nioPath.getFileSystem().provider().newByteChannel(nioPath, SetsKt.setOf((Object)StandardOpenOption.READ), new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
            SeekableByteChannel byteChannel = seekableByteChannel;
            AtomicReference<Object> isClosed = new AtomicReference<Object>(null);
            if (closeImmediatelyIfFileBiggerThan != null && byteChannel.size() > closeImmediatelyIfFileBiggerThan) {
                isClosed.set(true);
                try {
                    LocalEelFileSystemApiKt.access$doClose(this, byteChannel, path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return (EelResult)new EelFsResultImpl.Error<EelFsError>((EelFsError)new EelFsResultImpl.FileBiggerThanRequested(path, "The file is bigger than the requested size"));
            }
            LocalEelOpenedFileReader localEelOpenedFileReader = new LocalEelOpenedFileReader(this, byteChannel, path, isClosed, autoCloseAfterLastChunk);
            EelFsResultImpl.Ok<LocalEelOpenedFileReader> result$iv$iv = new EelFsResultImpl.Ok<LocalEelOpenedFileReader>(localEelOpenedFileReader);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.FileReaderError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.FileReaderError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.FileReaderError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object readFile(@NotNull EelFileSystemApi.ReadFileArgs args, @NotNull Continuation<? super EelResult<? extends EelFileSystemApi.ReadFileResult, ? extends EelFileSystemApi.FileReaderError>> $completion) {
        return NioBasedEelFileSystemApi.readFile$suspendImpl(this, args, $completion);
    }

    static /* synthetic */ Object readFile$suspendImpl(NioBasedEelFileSystemApi $this, EelFileSystemApi.ReadFileArgs args, Continuation<? super EelResult<? extends EelFileSystemApi.ReadFileResult, ? extends EelFileSystemApi.FileReaderError>> $completion) {
        return EelReadFileImplKt.readFileImpl($this, args, $completion);
    }

    @Nullable
    public Object openForWriting(@NotNull EelFileSystemApi.WriteOptions options, @NotNull Continuation<? super EelResult<? extends EelOpenedFile.Writer, ? extends EelFileSystemApi.FileWriterError>> $completion) {
        return NioBasedEelFileSystemApi.openForWriting$suspendImpl(this, options, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object openForWriting$suspendImpl(NioBasedEelFileSystemApi $this, EelFileSystemApi.WriteOptions options, Continuation<? super EelResult<? extends EelOpenedFile.Writer, ? extends EelFileSystemApi.FileWriterError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            EelPath path = options.getPath();
            Path nioPath = $this.toNioPath(path);
            Set<StandardOpenOption> nioOptions = $this.writeOptionsToNioOptions(options);
            SeekableByteChannel seekableByteChannel = nioPath.getFileSystem().provider().newByteChannel(nioPath, nioOptions, new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
            SeekableByteChannel byteChannel = seekableByteChannel;
            LocalEelOpenedFileWriter localEelOpenedFileWriter = new LocalEelOpenedFileWriter($this, byteChannel, path, new AtomicReference<Object>(null));
            EelFsResultImpl.Ok<LocalEelOpenedFileWriter> result$iv$iv = new EelFsResultImpl.Ok<LocalEelOpenedFileWriter>(localEelOpenedFileWriter);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            try {
                bl = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = bl;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.FileWriterError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.FileWriterError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.FileWriterError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    private final Set<StandardOpenOption> writeOptionsToNioOptions(EelFileSystemApi.WriteOptions options) {
        Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.WRITE};
        Set nioOptions = SetsKt.mutableSetOf((Object[])objectArray);
        switch (WhenMappings.$EnumSwitchMapping$0[options.getCreationMode().ordinal()]) {
            case 1: {
                ((Collection)nioOptions).add(StandardOpenOption.CREATE);
                break;
            }
            case 2: {
                ((Collection)nioOptions).add(StandardOpenOption.CREATE_NEW);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (options.getAppend()) {
            ((Collection)nioOptions).add(StandardOpenOption.APPEND);
        }
        if (options.getTruncateExisting()) {
            ((Collection)nioOptions).add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        return nioOptions;
    }

    @Nullable
    public Object openForReadingAndWriting(@NotNull EelFileSystemApi.WriteOptions options, @NotNull Continuation<? super EelResult<? extends EelOpenedFile.ReaderWriter, ? extends EelFileSystemApi.FileWriterError>> $completion) {
        return NioBasedEelFileSystemApi.openForReadingAndWriting$suspendImpl(this, options, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object openForReadingAndWriting$suspendImpl(NioBasedEelFileSystemApi $this, EelFileSystemApi.WriteOptions options, Continuation<? super EelResult<? extends EelOpenedFile.ReaderWriter, ? extends EelFileSystemApi.FileWriterError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            EelPath path = options.getPath();
            Path nioPath = $this.toNioPath(path);
            Set<StandardOpenOption> nioOptions = $this.writeOptionsToNioOptions(options);
            ((Collection)nioOptions).add(StandardOpenOption.READ);
            SeekableByteChannel seekableByteChannel = nioPath.getFileSystem().provider().newByteChannel(nioPath, nioOptions, new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
            SeekableByteChannel byteChannel = seekableByteChannel;
            AtomicReference<Object> isClosed = new AtomicReference<Object>(null);
            EelOpenedFile.ReaderWriter readerWriter = new EelOpenedFile.ReaderWriter($this, byteChannel, path, isClosed){
                private final /* synthetic */ LocalEelOpenedFileWriter $$delegate_0;
                final /* synthetic */ NioBasedEelFileSystemApi this$0;
                final /* synthetic */ SeekableByteChannel $byteChannel;
                final /* synthetic */ AtomicReference<Boolean> $isClosed;
                {
                    this.this$0 = $receiver;
                    this.$byteChannel = $byteChannel;
                    this.$isClosed = $isClosed;
                    this.$$delegate_0 = new LocalEelOpenedFileWriter($receiver, $byteChannel, $path, $isClosed);
                }

                public Object read(ByteBuffer buf, Continuation<? super EelResult<? extends ReadResult, ? extends EelOpenedFile.Reader.ReadError>> $completion) {
                    return LocalEelFileSystemApiKt.access$doRead(this.this$0, this.$byteChannel, buf, this.$isClosed, false);
                }

                public Object read(ByteBuffer buf, long offset, Continuation<? super EelResult<? extends ReadResult, ? extends EelOpenedFile.Reader.ReadError>> $completion) {
                    return LocalEelFileSystemApiKt.access$doRead(this.this$0, this.$byteChannel, offset, buf, this.$isClosed);
                }

                @CheckReturnValue
                public Object close(Continuation<? super EelResult<Unit, ? extends EelOpenedFile.CloseError>> $completion) {
                    return this.$$delegate_0.close($completion);
                }

                @CheckReturnValue
                public Object tell(Continuation<? super EelResult<Long, ? extends EelOpenedFile.TellError>> $completion) {
                    return this.$$delegate_0.tell($completion);
                }

                @CheckReturnValue
                public Object seek(long offset, EelOpenedFile.SeekWhence whence, Continuation<? super EelResult<Long, ? extends EelOpenedFile.SeekError>> $completion) {
                    return this.$$delegate_0.seek(offset, whence, $completion);
                }

                @CheckReturnValue
                public Object stat(Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
                    return this.$$delegate_0.stat($completion);
                }

                public EelPath getPath() {
                    return this.$$delegate_0.getPath();
                }

                public Boolean isClosed() {
                    return this.$$delegate_0.isClosed();
                }

                @CheckReturnValue
                public Object write(ByteBuffer buf, Continuation<? super EelResult<Integer, ? extends EelOpenedFile.Writer.WriteError>> $completion) {
                    return this.$$delegate_0.write(buf, $completion);
                }

                @CheckReturnValue
                public Object write(ByteBuffer buf, long pos, Continuation<? super EelResult<Integer, ? extends EelOpenedFile.Writer.WriteError>> $completion) {
                    return this.$$delegate_0.write(buf, pos, $completion);
                }

                @CheckReturnValue
                public Object flush(Continuation<? super EelResult<Unit, ? extends EelOpenedFile.Writer.FlushError>> $completion) {
                    return this.$$delegate_0.flush($completion);
                }

                @CheckReturnValue
                public Object truncate(long size, Continuation<? super EelResult<Unit, ? extends EelOpenedFile.Writer.TruncateError>> $completion) {
                    return this.$$delegate_0.truncate(size, $completion);
                }
            };
            EelFsResultImpl.Ok<openForReadingAndWriting.2.1> result$iv$iv = new EelFsResultImpl.Ok<openForReadingAndWriting.2.1>(readerWriter);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            try {
                bl = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = bl;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.FileWriterError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.FileWriterError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.FileWriterError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object delete(@NotNull EelPath path, boolean removeContent, @NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.DeleteError>> $completion) {
        return NioBasedEelFileSystemApi.delete$suspendImpl(this, path, removeContent, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object delete$suspendImpl(NioBasedEelFileSystemApi $this, EelPath path, boolean removeContent, Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.DeleteError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            if (removeContent) {
                Files.walkFileTree(EelNioBridgeServiceKt.asNioPath((EelPath)path), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                        if (exc != null) {
                            throw exc;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.delete($this.toNioPath(path));
            }
            Unit unit = Unit.INSTANCE;
            EelFsResultImpl.Ok<Unit> result$iv$iv = new EelFsResultImpl.Ok<Unit>(unit);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.DeleteError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.DeleteError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.DeleteError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object copy(@NotNull EelFileSystemApi.CopyOptions options, @NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.CopyError>> $completion) {
        return NioBasedEelFileSystemApi.copy$suspendImpl(this, options, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object copy$suspendImpl(NioBasedEelFileSystemApi $this, EelFileSystemApi.CopyOptions options, Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.CopyError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = $this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            void $this$toTypedArray$iv;
            boolean bl = false;
            Object object = new StandardCopyOption[]{options.getReplaceExisting() ? StandardCopyOption.REPLACE_EXISTING : null, options.getPreserveAttributes() ? StandardCopyOption.COPY_ATTRIBUTES : null};
            object = CollectionsKt.listOfNotNull((Object[])object);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            StandardCopyOption[] standardCopyOptionArray = thisCollection$iv.toArray(new StandardCopyOption[0]);
            Files.copy($this.toNioPath(options.getSource()), $this.toNioPath(options.getTarget()), (CopyOption[])Arrays.copyOf(standardCopyOptionArray, standardCopyOptionArray.length));
            Unit unit = Unit.INSTANCE;
            EelFsResultImpl.Ok<Unit> result$iv$iv = new EelFsResultImpl.Ok<Unit>(unit);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            try {
                bl = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = bl;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.CopyError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.CopyError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.CopyError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object move(@NotNull EelPath source, @NotNull EelPath target, @NotNull EelFileSystemApi.ReplaceExistingDuringMove replaceExisting, boolean followLinks, @NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.MoveError>> $completion) {
        return NioBasedEelFileSystemApi.move$suspendImpl(this, source, target, replaceExisting, followLinks, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object move$suspendImpl(NioBasedEelFileSystemApi $this, EelPath source, EelPath target, EelFileSystemApi.ReplaceExistingDuringMove replaceExisting, boolean followLinks, Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.MoveError>> $completion) {
        if (!($completion instanceof move.1)) ** GOTO lbl-1000
        var19_6 = $completion;
        if ((var19_6.label & -2147483648) != 0) {
            var19_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ NioBasedEelFileSystemApi this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NioBasedEelFileSystemApi.move$suspendImpl(this.this$0, null, null, null, false, (Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.MoveError>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this_$iv = $this;
                $i$f$wrapIntoEelResult = 0;
                var8_13 = this_$iv;
                isClosed$iv$iv = null;
                $i$f$wrapIntoEelResult = 0;
                $i$a$-wrapIntoEelResult-NioBasedEelFileSystemApi$move$2 = 0;
                sourceNioPath = $this.toNioPath(source);
                targetNioPath = $this.toNioPath(target);
                v0 = new LinkOption[]{};
                if (Files.exists(targetNioPath, Arrays.copyOf(v0, v0.length)) && replaceExisting == EelFileSystemApi.ReplaceExistingDuringMove.DO_NOT_REPLACE) {
                    return new EelFsResultImpl.Error<EelFsError>((EelFsError)new EelFsResultImpl.TargetAlreadyExists(target, "Target already exists"));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)source);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)target);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)replaceExisting);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$5 = this_$iv$iv;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)sourceNioPath);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)targetNioPath);
                $continuation.Z$0 = followLinks;
                $continuation.I$0 = $i$f$wrapIntoEelResult;
                $continuation.I$1 = $i$f$wrapIntoEelResult;
                $continuation.I$2 = $i$a$-wrapIntoEelResult-NioBasedEelFileSystemApi$move$2;
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sourceNioPath, targetNioPath, null){
                    int label;
                    final /* synthetic */ Path $sourceNioPath;
                    final /* synthetic */ Path $targetNioPath;
                    {
                        this.$sourceNioPath = $sourceNioPath;
                        this.$targetNioPath = $targetNioPath;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                EelPathUtils.INSTANCE.walkingTransfer(this.$sourceNioPath, this.$targetNioPath, true, true);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var21_8) goto lbl41
lbl40:
                // 1 sources

                return var21_8;
lbl41:
                // 1 sources

                ** GOTO lbl60
            }
            case 1: {
                $i$a$-wrapIntoEelResult-NioBasedEelFileSystemApi$move$2 = $continuation.I$2;
                $i$f$wrapIntoEelResult = $continuation.I$1;
                $i$f$wrapIntoEelResult = $continuation.I$0;
                followLinks = $continuation.Z$0;
                targetNioPath = (Path)$continuation.L$7;
                sourceNioPath = (Path)$continuation.L$6;
                isClosed$iv$iv = null;
                this_$iv$iv = (NioBasedEelFileSystemApi)$continuation.L$5;
                this_$iv = (NioBasedEelFileSystemApi)$continuation.L$4;
                replaceExisting = (EelFileSystemApi.ReplaceExistingDuringMove)$continuation.L$3;
                target = (EelPath)$continuation.L$2;
                source = (EelPath)$continuation.L$1;
                $this = (NioBasedEelFileSystemApi)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl60:
                    // 2 sources

                    var20_25 = Unit.INSTANCE;
                    result$iv$iv = new EelFsResultImpl.Ok<Unit>(var20_25);
                    var14_26 = (EelResult)result$iv$iv;
                }
                catch (FileSystemException err$iv$iv) {
                    try {
                        var16_28 = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
                    }
                    catch (EelPathException <unused var>$iv$iv) {
                        v2 = this_$iv$iv.getFs().getRootDirectories();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"getRootDirectories(...)");
                        var16_28 = EelPath.Companion.parse(CollectionsKt.first(v2).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
                    }
                    path$iv$iv = var16_28;
                    var17_30 = err$iv$iv;
                    if (var17_30 instanceof AccessDeniedException) {
                        v3 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v3);
                        v4 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, v3);
                    } else if (var17_30 instanceof NoSuchFileException) {
                        v5 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v5);
                        v4 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, v5);
                    } else if (var17_30 instanceof FileAlreadyExistsException) {
                        v6 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v6);
                        v4 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, v6);
                    } else if (var17_30 instanceof NotDirectoryException) {
                        v7 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v7);
                        v4 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, v7);
                    } else if (var17_30 instanceof NotLinkException) {
                        v8 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v8);
                        v4 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, v8);
                    } else if (var17_30 instanceof FileSystemLoopException) {
                        v9 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v9);
                        v4 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, v9);
                    } else if (var17_30 instanceof DirectoryNotEmptyException) {
                        v10 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v10);
                        v4 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, v10);
                    } else if (var17_30 instanceof AtomicMoveNotSupportedException) {
                        v11 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v11);
                        v4 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, v11);
                    } else {
                        v12 = err$iv$iv.getMessage();
                        Intrinsics.checkNotNull((Object)v12);
                        v4 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, v12);
                    }
                    if (!((v13 = (err$iv$iv = v4)) instanceof EelFileSystemApi.MoveError)) {
                        v13 = null;
                    }
                    if ((v14 = (EelFsError)((EelFileSystemApi.MoveError)v13)) == null) {
                        v14 = (EelFsError)((EelFileSystemApi.MoveError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv.getMessage()));
                    }
                    var14_26 = (EelResult)new EelFsResultImpl.Error<EelFsError>(v14);
                }
                return var14_26;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EelFileSystemApi.FileWriterCreationMode.values().length];
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

