import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState, useMemo } from 'react';
import { useTheme2, HorizontalGroup, IconButton, Tooltip, Icon } from '@grafana/ui';
import { QueryValidator } from './QueryValidator.js';

function QueryToolbox({ showTools, onFormatCode, onExpand, isExpanded, ...validatorProps }) {
  const theme = useTheme2();
  const [validationResult, setValidationResult] = useState();
  const styles = useMemo(() => {
    return {
      container: css`
        border: 1px solid ${theme.colors.border.medium};
        border-top: none;
        padding: ${theme.spacing(0.5, 0.5, 0.5, 0.5)};
        display: flex;
        flex-grow: 1;
        justify-content: space-between;
        font-size: ${theme.typography.bodySmall.fontSize};
      `,
      error: css`
        color: ${theme.colors.error.text};
        font-size: ${theme.typography.bodySmall.fontSize};
        font-family: ${theme.typography.fontFamilyMonospace};
      `,
      valid: css`
        color: ${theme.colors.success.text};
      `,
      info: css`
        color: ${theme.colors.text.secondary};
      `,
      hint: css`
        color: ${theme.colors.text.disabled};
        white-space: nowrap;
        cursor: help;
      `
    };
  }, [theme]);
  let style = {};
  if (!showTools && validationResult === undefined) {
    style = { height: 0, padding: 0, visibility: "hidden" };
  }
  return /* @__PURE__ */ jsxs("div", { className: styles.container, style, children: [
    /* @__PURE__ */ jsx("div", { children: validatorProps.onValidate && /* @__PURE__ */ jsx(
      QueryValidator,
      {
        ...validatorProps,
        onValidate: (result) => {
          setValidationResult(result);
          validatorProps.onValidate(result);
        }
      }
    ) }),
    showTools && /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsxs(HorizontalGroup, { spacing: "sm", children: [
      onFormatCode && /* @__PURE__ */ jsx(IconButton, { onClick: onFormatCode, name: "brackets-curly", size: "xs", tooltip: "Format query" }),
      onExpand && /* @__PURE__ */ jsx(
        IconButton,
        {
          onClick: () => onExpand(!isExpanded),
          name: isExpanded ? "angle-up" : "angle-down",
          size: "xs",
          tooltip: isExpanded ? "Collapse editor" : "Expand editor"
        }
      ),
      /* @__PURE__ */ jsx(Tooltip, { content: "Hit CTRL/CMD+Return to run query", children: /* @__PURE__ */ jsx(Icon, { className: styles.hint, name: "keyboard" }) })
    ] }) })
  ] });
}

export { QueryToolbox };
//# sourceMappingURL=QueryToolbox.js.map
