/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.TransformRegistrationFactory;
import org.gradle.api.internal.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.ServiceLookup;
import org.jspecify.annotations.Nullable;

public class DefaultVariantTransformRegistry
implements VariantTransformRegistry {
    private final Set<TransformRegistration> registeredTransforms = new LinkedHashSet<TransformRegistration>();
    private final AttributesFactory attributesFactory;
    private final ServiceLookup services;
    private final InstantiatorFactory instantiatorFactory;
    private final InstantiationScheme parametersInstantiationScheme;
    private final TransformRegistrationFactory registrationFactory;
    private final IsolationScheme<TransformAction<?>, TransformParameters> isolationScheme = new IsolationScheme(TransformAction.class, TransformParameters.class, TransformParameters.None.class);
    private final DocumentationRegistry documentationRegistry;

    public DefaultVariantTransformRegistry(InstantiatorFactory instantiatorFactory, AttributesFactory attributesFactory, ServiceLookup services, TransformRegistrationFactory registrationFactory, InstantiationScheme parametersInstantiationScheme, DocumentationRegistry documentationRegistry) {
        this.instantiatorFactory = instantiatorFactory;
        this.attributesFactory = attributesFactory;
        this.services = services;
        this.registrationFactory = registrationFactory;
        this.parametersInstantiationScheme = parametersInstantiationScheme;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public <T extends TransformParameters> void registerTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        this.doRegisterTransform(actionType, registrationAction);
    }

    @Override
    public Set<TransformRegistration> getRegistrations() {
        return ImmutableSet.copyOf(this.registeredTransforms);
    }

    private <T extends TransformParameters> void doRegisterTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        this.validateActionType(actionType);
        TypedRegistration registration = null;
        try {
            Class parameterType = this.isolationScheme.parameterTypeFor(actionType);
            TransformParameters parameterObject = parameterType == null ? null : (TransformParameters)this.parametersInstantiationScheme.withServices(this.services).instantiator().newInstance(parameterType, new Object[0]);
            registration = (TypedRegistration)Cast.uncheckedNonnullCast((Object)this.instantiatorFactory.decorateLenient(this.services).newInstance(TypedRegistration.class, new Object[]{parameterObject, this.attributesFactory}));
            registrationAction.execute((Object)registration);
            registration.validateAttributes();
            TransformRegistration finalizedRegistration = this.registrationFactory.create(registration.from.asImmutable(), registration.to.asImmutable(), actionType, parameterObject);
            this.registeredTransforms.add(finalizedRegistration);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(this.buildFailureToRegisterMsg(registration, actionType), (Throwable)e, this.documentationRegistry);
        }
    }

    private String buildFailureToRegisterMsg(@Nullable TypedRegistration<?> registration, Class<? extends TransformAction<?>> actionType) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Could not register artifact transform ");
        formatter.appendType(actionType);
        if (!(registration == null || ((TypedRegistration)registration).from.isEmpty() && ((TypedRegistration)registration).to.isEmpty())) {
            formatter.append((CharSequence)" (");
            if (!((TypedRegistration)registration).from.isEmpty()) {
                formatter.append((CharSequence)"from ");
                formatter.appendValue((Object)((TypedRegistration)registration).from);
            }
            if (!((TypedRegistration)registration).to.isEmpty()) {
                if (!((TypedRegistration)registration).from.isEmpty()) {
                    formatter.append((CharSequence)" ");
                }
                formatter.append((CharSequence)"to ");
                formatter.appendValue((Object)((TypedRegistration)registration).to);
            }
            formatter.append((CharSequence)")");
        }
        formatter.append((CharSequence)".");
        return formatter.toString();
    }

    private <T> void validateActionType(@Nullable Class<T> actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("An artifact transform action type must be provided.");
        }
    }

    @NonExtensible
    public static abstract class TypedRegistration<T extends TransformParameters>
    implements TransformSpec<T> {
        private final AttributeContainerInternal from;
        private final AttributeContainerInternal to;
        private final T parameterObject;

        @Inject
        protected abstract DocumentationRegistry getDocumentationRegistry();

        public TypedRegistration(@Nullable T parameterObject, AttributesFactory attributesFactory) {
            this.parameterObject = parameterObject;
            this.from = attributesFactory.mutable();
            this.to = attributesFactory.mutable();
        }

        public AttributeContainer getFrom() {
            return this.from;
        }

        public AttributeContainer getTo() {
            return this.to;
        }

        public T getParameters() {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot query parameters for artifact transform without parameters.");
            }
            return this.parameterObject;
        }

        public void parameters(Action<? super T> action) {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot configure parameters for artifact transform without parameters.");
            }
            action.execute(this.parameterObject);
        }

        public void validateAttributes() {
            if (this.to.isEmpty()) {
                throw new VariantTransformConfigurationException("At least one 'to' attribute must be provided.", this.getDocumentationRegistry());
            }
            if (this.from.isEmpty()) {
                throw new VariantTransformConfigurationException("At least one 'from' attribute must be provided.", this.getDocumentationRegistry());
            }
            if (!this.from.keySet().containsAll(this.to.keySet())) {
                throw new VariantTransformConfigurationException("Each 'to' attribute must be included as a 'from' attribute.", this.getDocumentationRegistry());
            }
        }
    }
}

