---
stage: Secure
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'アプリケーションセキュリティテストの展開'
---

アプリケーションセキュリティテストの実装を段階的に計画し、より安全な開発プラクティスへのスムーズな移行を確保します。

このガイドでは、GitLabのアプリケーションセキュリティテストを組織全体に段階的に実装する方法について説明します。パイロットグループから開始し、カバレッジを徐々にスケールすることで、セキュリティ上のメリットを最大限に高めながら、中断を最小限に抑えることができます。段階的なアプローチにより、チームはすべてのプロジェクトにスケールする前に、アプリケーションセキュリティテストツールとワークフローに慣れることができます。

前提要件: 

- GitLab Ultimate
- GitLab CI/CDパイプラインに関する知識次のGitLabのセルフペースコースは、良い入門編となります:
  - [継続的インテグレーション/継続的デリバリー入門](https://university.gitlab.com/courses/introduction-to-cicd-s2)
  - [実践ラボ: CIの基礎](https://university.gitlab.com/courses/hands-on-labs-ci-fundamentals)
- 組織のセキュリティ要件とリスク許容度の理解。

## スコープ {#scope}

このガイドでは、設定、脆弱性管理、および防止戦略など、GitLabのアプリケーションセキュリティテスト機能の段階的な実装を計画および実行する方法について説明します。既存のワークフローへの混乱を最小限に抑えながら、コードベースを保護するために、アプリケーションセキュリティテストを徐々に導入することを前提としています。

## フェーズ {#phases}

実装は、主に次の2つのフェーズで構成されます:

1. **Pilot phase**（パイロットフェーズ）: 設定を検証し、チームをトレーニングするために、限られたプロジェクトセットに対してアプリケーションセキュリティテストを実装します。
1. **Rollout phase**（ロールアウトフェーズ）: パイロット中に得られた知識を使用して、アプリケーションセキュリティテストをすべてのターゲットプロジェクトに展開します。

## パイロットフェーズ {#pilot-phase}

パイロットフェーズでは、より広範なロールアウトの前に、リスクを最小限に抑えてアプリケーションセキュリティテストを適用できます。

パイロットフェーズを開始する前に、次のガイドラインを検討してください:

- セキュリティチームメンバー、デベロッパー、プロジェクトマネージャーなどの主要な関係者を特定します。
- コードベースを代表するが、日々の運用に不可欠ではないパイロットプロジェクトを選択します。
- デベロッパーとセキュリティチームメンバーのトレーニングセッションをスケジュールします。
- 改善を測定するために、現在のセキュリティプラクティスを文書化します。

### パイロットの目標 {#pilot-goals}

パイロットフェーズは、いくつかの主要な目標を達成するのに役立ちます:

- 開発を遅らせることなく、アプリケーションセキュリティテストを実装する

  パイロット中、アプリケーションセキュリティテストの結果は、マージリクエストをブロックすることなく、UIでデベロッパーが利用できます。このアプローチは、現在のセキュリティ対策状況に関する貴重なデータを収集しながら、パイロットのスコープ外のプロジェクトへのリスクを最小限に抑えます。ロールアウトフェーズでは、マージリクエストで脆弱性が検出された場合に追加の承認ゲートを追加するには、[マージリクエスト承認ポリシー](#merge-request-approval-policy)を使用する必要があります。

- スケーラブルな検出方法を確立する

  より広範なロールアウトのスコープ内のすべてのプロジェクトを含めるように拡張できる方法で、パイロットプロジェクトにアプリケーションセキュリティテストを実装します。プロジェクト全体でうまくスケールし、標準化できる設定に焦点を当てます。

- スキャン時間をテストする

  代表的なコードベースとアプリケーションでスキャン時間をテストします。

- 脆弱性修正ワークフローをシミュレートする

  デベロッパーのワークフローで、脆弱性の検出、トリアージ、分析、修正をシミュレートします。エンジニアが調査結果に基づいて行動できることを確認します。

- メンテナンスコストを比較する

  単一のソリューションのメンテナンスと、複数のエンドポイントソリューションの統合を比較します。これは、IDE、マージリクエスト、およびパイプラインにどれだけうまく統合されていますか？

#### デベロッパー向けのメリット {#benefits-for-developers}

パイロットグループのデベロッパーは、以下を取得します:

- アプリケーションセキュリティテストの方法と結果の解釈方法に関する知識。
- 脆弱性がデフォルトブランチにマージされるのを防ぐ経験。
- デフォルトブランチで脆弱性が検出されたときに開始される脆弱性管理ワークフローの理解。

#### セキュリティ管理のメリット {#benefits-for-security-management}

パイロットに参加しているセキュリティチームのメンバーは、以下を取得します:

- GitLabでの脆弱性の追跡と管理の経験。
- セキュリティベースラインを確立し、現実的な修正目標を設定するためのデータ。
- より広範なロールアウトの前にセキュリティポリシーを改良するためのインサイト。

### パイロット計画 {#pilot-plan}

適切な計画により、効果的なパイロットフェーズが保証されます。

#### 役割と責任 {#roles-and-responsibilities}

以下について誰が責任を負うかを定義します:

- アプリケーションセキュリティテストの設定
- スキャン結果の確認
- 脆弱性のトリアージ
- 修正の管理
- チームメンバーのトレーニング
- パイロットの成功の測定

### パイロットスコープ {#pilot-scope}

パイロットフェーズに含めるプロジェクトを慎重に選択します。

パイロットプロジェクトを選択する際は、次の要素を考慮してください:

- アプリケーションセキュリティテストの有効性をテストするために、異なるテクノロジスタックを持つプロジェクトを含めます。
- リアルタイムの結果を確認するために、アクティブな開発が行われているプロジェクトを選択します。
- 新しいセキュリティプラクティスを学ぶことにオープンなチームを持つプロジェクトを選択します。
- ミッションクリティカルなアプリケーションから開始することは避けてください。

### セキュリティアプリケーションセキュリティテストの順序 {#security-application-security-testing-order}

次の順序でセキュリティアプリケーションセキュリティテストを導入します。これにより、価値とデプロイの容易さのバランスが取れます。

- 依存関係スキャン
- SAST
- 高度なSAST
- パイプラインシークレット検出
- シークレットプッシュ保護
- コンテナスキャン
- DAST
- APIセキュリティテスト
- IaCスキャン
- 運用コンテナスキャン（OCS）

## テストパイロットプロジェクト {#test-pilot-projects}

計画が完了したら、パイロットプロジェクトのアプリケーションセキュリティテストの実装を開始します。

### パイロットプロジェクトのテストをセットアップする {#set-up-testing-of-pilot-projects}

前提要件: 

- アプリケーションセキュリティテストを有効にするプロジェクトのメンテナーロールを持っている必要があります。

スコープ内の各プロジェクトの場合:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **セキュリティ設定**を展開する。
1. プロジェクトのスタックに基づいて、適切なアプリケーションセキュリティテストを有効にします。

詳細については、[セキュリティ設定](security_configuration.md)を参照してください。

### デベロッパー向け {#for-developers}

セキュリティ調査結果の可視性を提供するツールをデベロッパーに紹介します。

#### パイプライン結果 {#pipeline-results}

デベロッパーは、パイプライン結果でセキュリティ調査結果を直接表示できます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **ビルド** > **パイプライン**を選択します。
1. 確認するパイプラインを選択します。
1. パイプラインの詳細で、**セキュリティ**タブを選択して、検出された脆弱性を表示します。

詳細については、[パイプラインでのセキュリティスキャン結果の表示](security_scanning_results.md)を参照してください。

#### マージリクエストセキュリティウィジェット {#merge-request-security-widget}

セキュリティウィジェットは、マージリクエストのパイプラインで検出された脆弱性の可視性を提供します:

1. マージリクエストを開きます。
1. セキュリティウィジェットを確認して、検出された脆弱性を確認します。
1. **全て展開**を選択して、詳細な調査結果を表示します。

詳細については、[マージリクエストでのセキュリティスキャン結果の表示](security_scanning_results.md)を参照してください。

#### VS CodeとGitLab Workflow拡張機能との統合 {#vs-code-integration-with-gitlab-workflow-extension}

デベロッパーは、IDEでセキュリティ調査結果を直接表示できます:

1. VS Code用GitLab Workflow拡張機能をインストールします。
1. 拡張機能をGitLabインスタンスに接続します。
1. 拡張機能を使用して、開発環境を離れることなくセキュリティ調査結果を表示します。

詳細については、[VS Code用GitLab Workflow拡張機能](../../../editor_extensions/visual_studio_code/_index.md)を参照してください。

## 脆弱性管理ワークフロー {#vulnerability-management-workflow}

検出された脆弱性を処理するための構造化されたワークフローを確立します。

脆弱性管理ワークフローは、4つの主要なステージングで構成されています:

1. **Detect**（検出）: パイプラインで自動化されたアプリケーションセキュリティテストを通じて、脆弱性を見つけます。
1. **トリアージ**: 検出された脆弱性の重大度と影響を評価します。
1. **分析**: 根本原因を調査し、修正に最適なアプローチを決定します。
1. **Remediate**（修正）: 脆弱性を解決するために修正を実装します。

### 効率的なトリアージ {#efficient-triage}

GitLabには、脆弱性のトリアージを効率化するためのいくつかの機能が用意されています:

- 影響の大きい問題に最初に焦点を当てる脆弱性フィルター。
- 取り組みの優先順位を付ける重大度と信頼度の評価。
- 未解決の問題の可視性を維持するための脆弱性の追跡。
- リスク評価データ

詳細については、[トリアージ](../triage/_index.md)を参照してください。

トリアージには、セキュリティ関係者との脆弱性レポートの定期的なレビューを含める必要があります。

### 効率的な修正 {#efficient-remediation}

これらのGitLab機能を使用して、修正プロセスを効率化します:

- 特定の脆弱性タイプに対する自動修正の提案。
- 脆弱性の詳細から直接マージリクエストを作成。
- 進捗状況を監視するための脆弱性の履歴の追跡。
- 検出されなくなった脆弱性を自動的に解決します。

詳細については、[修正](../remediate/_index.md)を参照してください。

#### チケットシステムとの統合 {#integrate-with-ticketing-systems}

GitLabイシューを使用して、脆弱性に必要な修正作業を追跡できます。または、Jiraが主要なチケットシステムである場合は、Jiraイシューを使用できます。

詳細については、[GitLabとJiraイシューへの脆弱性のリンク](../vulnerabilities/_index.md#linking-a-vulnerability-to-gitlab-and-jira-issues)を参照してください。

## 脆弱性の防止 {#vulnerability-prevention}

そもそも脆弱性が導入されないようにするための機能を実装します。

### マージリクエスト承認ポリシー {#merge-request-approval-policy}

マージリクエストに脆弱性の数と重大度が特定のしきい値を超えた場合、マージリクエスト承認ポリシーを使用して、追加の承認要件を追加します。これにより、アプリケーションセキュリティチームのメンバーからの追加のレビューが可能になり、一段上の精査が提供されます。

セキュリティレビューを要求するように承認ポリシーを設定します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ** > **ポリシー**を選択します。
1. **新規ポリシー**を選択します
1. **マージリクエスト承認ポリシー**ペインで、**ポリシーの選択**を選択します。
1. セキュリティチームメンバーからの承認を要求するマージリクエスト承認ポリシーを追加します。

詳細については、[マージリクエストでのセキュリティ承認](../policies/merge_request_approval_policies.md)を参照してください。

## ロールアウトフェーズ {#rollout-phase}

パイロットが成功したら、アプリケーションセキュリティテストをすべてのターゲットプロジェクトに拡張します。

ロールアウトフェーズを開始する前に、以下を検討してください:

- パイロットフェーズの結果を評価します。
- 学んだ教訓とベストプラクティスを文書化します。
- パイロットの経験に基づいてトレーニング資料を準備します。
- パイロットのフィードバックに基づいて実装計画を更新します。

### チームメンバーへのアクセスを定義する {#define-access-to-team-members}

アプリケーションセキュリティテストタスクには、特定の役割または権限が必要です。ロールアウトフェーズに参加する各人について、実行するタスクに応じてアクセス権を定義します。

- デベロッパーロールを持つユーザーは、プロジェクトとマージリクエストで脆弱性を表示できます。
- メンテナーロールを持つユーザーは、プロジェクトのセキュリティ設定を設定できます。
- `admin_vulnerability`権限を持つカスタムロールを割り当てられたユーザーは、脆弱性を管理およびトリアージできます。
- `manage_security_policy_link`権限を持つカスタムロールを割り当てられたユーザーは、グループとプロジェクトにポリシーを適用できます。

詳細については、[役割と権限](../../permissions.md#application-security-group-permissions)を参照してください。

### ロールアウトの目標 {#rollout-goals}

ロールアウトフェーズは、パイロット中に得られた知識と経験を使用して、スコープ内のすべてのプロジェクトにアプリケーションセキュリティテストを実装することを目的としています。

### ロールアウト計画 {#rollout-plan}

パイロット中に確立された役割と責任をレビューして更新します。同じチーム構成がロールアウトに適しているはずですが、スコープが拡張するにつれて、より多くのチームメンバーを追加する必要がある場合があります。

## アプリケーションセキュリティテストを大規模に実装する {#implement-application-security-testing-at-scale}

ポリシー機能を使用して、セキュリティ実装を効率的にスケールします。

### ポリシーの継承を使用する {#use-policy-inheritance}

ポリシーの継承を使用して、有効性を最大化すると同時に、管理するポリシーの数を最小限に抑えます。

サブグループA、B、Cを含むFinanceという名前のトップレベルグループがあるシナリオを考えてみましょう。Financeグループのすべてのプロジェクトで依存関係スキャンとシークレット検出を実行するとします。サブグループごとに、異なるアプリケーションセキュリティテストツールセットを実行するとします。

この目標を達成するには、Financeグループに3つのポリシーを定義します:

- ポリシー1:
  - 依存関係スキャンとシークレット検出が含まれます。
  - Financeグループ、そのすべてのサブグループ、およびそれらのプロジェクトに適用されます。
- ポリシー2:
  - DASTとAPIセキュリティテストが含まれています。
  - サブグループAとBのみにスコープされます。
- ポリシー3:
  - SASTが含まれます。
  - サブグループCのみにスコープされます。

維持する必要があるのは単一のポリシーセットのみですが、それでもさまざまなプロジェクトのニーズに合わせて柔軟に対応できます。

詳細については、[執行](../policies/enforcement/_index.md#enforcement)を参照してください。

### スキャン実行ポリシーを設定する {#configure-scan-execution-policies}

スキャン実行ポリシーを使用して、複数のプロジェクトで一貫したアプリケーションセキュリティテストを実装します。

前提要件: 

- アプリケーションセキュリティテストを有効にするグループのオーナーロール、または`manage_security_policy_link`権限を持つカスタムロールを持っている必要があります。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **セキュリティ** > **ポリシー**を選択します。
1. パイロットフェーズ中に使用されたアプリケーションセキュリティテストの設定に基づいて、スキャン実行ポリシーを作成します。

詳細については、[セキュリティポリシー](../policies/_index.md)を参照してください。

### 徐々にスケールする {#scale-gradually}

ロールアウトを徐々にスケールし、最初にパイロットプロジェクトにスケールし、次にすべてのターゲットプロジェクトに段階的にスケールします。ポリシーをすべてのグループとプロジェクトに適用する場合は、パイプラインとマージリクエストのワークフローの変更に影響を与える可能性があるため、すべてのプロジェクト関係者に認識を促します。たとえば、関係者に通知します

セキュリティポリシーを段階的に実装します:

1. まず、パイロットフェーズのプロジェクトにポリシーを適用します。
1. 問題や中断がないか監視します。
1. 徐々にポリシーのスコープを展開して、より多くのプロジェクトを含めます。
1. 対象のすべてのプロジェクトが対象範囲に含まれるまで続行します。

詳しくは、[ポリシー設計ガイドライン](../policies/enforcement/_index.md#policy-design-guidelines)をご覧ください。
