---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンセグメントの公開APIトークンの公開'
---

## 説明 {#description}

応答本文には、セグメントの公開APIトークンのパターンに一致するコンテンツが含まれていることが確認されました。セグメントの公開APIは、セグメントのワークスペースとそのリソースを管理するために使用されます。2種類のトークンがこのパターンに一致します。ワークスペースオーナートークンと、制限付きロールトークンです。一般に、これらのトークンを使用すると、APIの呼び出し元は、読み取り、書き込み、および削除操作を実行できます。ワークスペースオーナートークンへのアクセス権を持つ悪意のある攻撃者は、すべてのワークスペースデータにアクセスできます。制限付きロールトークンは、作成時にアクセス権が付与されたデータにアクセスできます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

公開APIトークンをローテーションするには:

- セグメントアカウントにサインインし、<https://app.segment.com/>からワークスペースにアクセスします
- 左側のメニューから「Settings」を選択し、「ワークスペース設定」に移動します
- 「ワークスペース設定」ページの「アクセス管理」タブを選択します
- 「アクセス管理」の「トークン」タブを選択します
- 識別されたキーを見つけて選択します
- 右側で、「トークンのアクセス許可」セクションの「トークンの編集」を選択します
- 右上隅にある「トークンの削除」を選択します
- プロンプトが表示されたら、ダイアログで「トークンの削除」を選択します

詳細については、[公開APIに関するセグメントのドキュメント](https://segment.com/docs/api/public-api/)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.169 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
