/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.frida;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.Set;

public class FridaDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    protected static final LanguageID LANG_ID_AARCH64 = new LanguageID("AARCH64:LE:64:v8A");
    protected static final LanguageID LANG_ID_X86 = new LanguageID("x86:LE:32:default");
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");
    protected static final CompilerSpecID COMP_ID_GCC = new CompilerSpecID("gcc");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");

    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        boolean isX86_64;
        if (debugger == null || arch == null || os == null | !debugger.toLowerCase().contains("frida")) {
            return Set.of();
        }
        String lcOS = os.toLowerCase();
        boolean isLinux = lcOS.contains("linux");
        boolean isMacOS = lcOS.contains("darwin") || lcOS.contains("macos") || lcOS.contains("ios");
        boolean isWindows = lcOS.contains("windows");
        String lcArch = arch.toLowerCase();
        boolean isARM = lcArch.contains("aarch64") || lcArch.contains("arm");
        boolean isI386 = lcArch.contains("ia32") || lcArch.contains("x86-32") || lcArch.contains("x86_32") || lcArch.contains("i386");
        boolean bl = isX86_64 = lcArch.contains("x64") || lcArch.contains("x86-64") || lcArch.contains("x86_64") || lcArch.contains("x64-32") || lcArch.contains("x64_32");
        if (isLinux) {
            if (isI386) {
                return Set.of(Offers.I386_LINUX);
            }
            if (isX86_64) {
                return Set.of(Offers.X86_64_LINUX);
            }
        }
        if (isMacOS) {
            if (isARM) {
                return Set.of(Offers.AARCH64_MACOS);
            }
            if (isI386) {
                return Set.of(Offers.I386_MACOS);
            }
            if (isX86_64) {
                return Set.of(Offers.X86_64_MACOS);
            }
        }
        if (isWindows) {
            if (isI386) {
                return Set.of(Offers.I386_WINDOWS);
            }
            if (isX86_64) {
                return Set.of(Offers.X86_64_WINDOWS);
            }
        }
        return Set.of();
    }

    static enum Offers implements DebuggerPlatformOffer
    {
        AARCH64_MACOS("Frida on macOS Apple Silicon", LANG_ID_AARCH64, COMP_ID_DEFAULT),
        I386_LINUX("Frida on Linux i386", LANG_ID_X86, COMP_ID_GCC),
        I386_MACOS("Frida on macOS i386", LANG_ID_X86, COMP_ID_GCC),
        I386_WINDOWS("Frida on Windows x86", LANG_ID_X86, COMP_ID_VS),
        X86_64_LINUX("Frida on Linux x86_64", LANG_ID_X86_64, COMP_ID_GCC),
        X86_64_MACOS("Frida on macOS x86_64", LANG_ID_X86_64, COMP_ID_GCC),
        X86_64_WINDOWS("Frida on Windows x64", LANG_ID_X86_64, COMP_ID_VS);

        final String description;
        final LanguageID langID;
        final CompilerSpecID cSpecID;

        private Offers(String description, LanguageID langID, CompilerSpecID cSpecID) {
            this.description = description;
            this.langID = langID;
            this.cSpecID = cSpecID;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getConfidence() {
            return 100;
        }

        @Override
        public CompilerSpec getCompilerSpec() {
            return this.getCompilerSpec(this.langID, this.cSpecID);
        }

        @Override
        public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
            return new FridaDebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
        }

        @Override
        public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
            return mapper.getClass() == FridaDebuggerPlatformMapper.class;
        }
    }

    protected static class FridaDebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public FridaDebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }
}

