/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import docking.ActionContext;
import docking.ReusableDialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.register.AvailableRegisterRow;
import ghidra.app.plugin.core.debug.gui.register.DebuggerAvailableRegistersActionContext;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerAvailableRegistersDialog
extends ReusableDialogComponentProvider {
    private final DebuggerRegistersProvider provider;
    private Language language;
    final AvailableRegistersTableModel availableTableModel;
    private final Map<Register, AvailableRegisterRow> regMap = new HashMap<Register, AvailableRegisterRow>();
    private GTable availableTable;
    private GhidraTableFilterPanel<AvailableRegisterRow> availableFilterPanel;
    ActionContext myActionContext;
    DockingAction actionAdd;
    DockingAction actionRemove;

    protected DebuggerAvailableRegistersDialog(DebuggerRegistersProvider provider) {
        super("Select Registers", true, true, true, false);
        this.provider = provider;
        this.availableTableModel = new AvailableRegistersTableModel(provider.getTool());
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.availableTable = new GTable((TableModel)((Object)this.availableTableModel));
        this.availableTable.setSelectionMode(2);
        this.availableTable.getAccessibleContext().setAccessibleName("Selection Choices");
        panel.add(new JScrollPane((Component)this.availableTable));
        this.availableTable.setAutoLookupColumn(AvailableRegisterTableColumns.NAME.ordinal());
        this.availableFilterPanel = new GhidraTableFilterPanel((JTable)this.availableTable, (RowObjectTableModel)this.availableTableModel);
        this.availableFilterPanel.getAccessibleContext().setAccessibleName("Available Filters");
        panel.add((Component)this.availableFilterPanel, "South");
        panel.getAccessibleContext().setAccessibleName("Available Debugger Registers");
        this.addWorkPanel(panel);
        TableColumnModel columnModel = this.availableTable.getColumnModel();
        TableColumn numCol = columnModel.getColumn(AvailableRegisterTableColumns.NUMBER.ordinal());
        numCol.setPreferredWidth(1);
        TableColumn selCol = columnModel.getColumn(AvailableRegisterTableColumns.SELECTED.ordinal());
        selCol.setPreferredWidth(20);
        TableColumn nameCol = columnModel.getColumn(AvailableRegisterTableColumns.NAME.ordinal());
        nameCol.setPreferredWidth(40);
        TableColumn bitsCol = columnModel.getColumn(AvailableRegisterTableColumns.BITS.ordinal());
        bitsCol.setPreferredWidth(30);
        TableColumn knownCol = columnModel.getColumn(AvailableRegisterTableColumns.KNOWN.ordinal());
        knownCol.setPreferredWidth(20);
        TableColumn groupCol = columnModel.getColumn(AvailableRegisterTableColumns.GROUP.ordinal());
        groupCol.setPreferredWidth(40);
        TableColumn containsCol = columnModel.getColumn(AvailableRegisterTableColumns.CONTAINS.ordinal());
        containsCol.setPreferredWidth(20);
        TableColumn parentCol = columnModel.getColumn(AvailableRegisterTableColumns.PARENT.ordinal());
        parentCol.setPreferredWidth(30);
        this.addOKButton();
        this.addCancelButton();
        this.createActions();
        this.availableTable.getSelectionModel().addListSelectionListener(evt -> this.updateActionContext());
    }

    protected void updateActionContext() {
        List sel = this.availableFilterPanel.getSelectedItems();
        this.myActionContext = sel == null || sel.isEmpty() ? null : new DebuggerAvailableRegistersActionContext(sel);
        this.notifyContextChanged();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void createActions() {
        this.actionAdd = this.createActionAdd();
        this.addAction((DockingActionIf)this.actionAdd);
        this.actionRemove = this.createActionRemove();
        this.addAction((DockingActionIf)this.actionRemove);
        this.notifyContextChanged();
    }

    private DockingAction createActionAdd() {
        return (DockingAction)DebuggerResources.AddAction.builder(this.provider.plugin).withContext(DebuggerAvailableRegistersActionContext.class).enabledWhen(ctx -> !ctx.getSelection().isEmpty()).onAction(ctx -> this.addSelection(ctx.getSelection())).build();
    }

    private DockingAction createActionRemove() {
        return (DockingAction)DebuggerResources.RemoveAction.builder(this.provider.plugin).withContext(DebuggerAvailableRegistersActionContext.class).enabledWhen(ctx -> !ctx.getSelection().isEmpty()).onAction(ctx -> this.removeSelection(ctx.getSelection())).build();
    }

    protected void setAvailable(List<Register> regs) {
        this.regMap.clear();
        this.availableTableModel.clear();
        for (int i = 0; i < regs.size(); ++i) {
            Register reg = regs.get(i);
            AvailableRegisterRow ar = new AvailableRegisterRow(i, reg);
            this.regMap.put(reg, ar);
            this.availableTableModel.add(ar);
        }
    }

    public void setLanguage(Language language) {
        if (this.language == language) {
            return;
        }
        this.language = language;
        if (language == null) {
            this.setAvailable(List.of());
        } else {
            this.setAvailable(language.getRegisters());
        }
    }

    protected void clearKnown() {
        for (AvailableRegisterRow ar : this.regMap.values()) {
            ar.setKnown(false);
        }
    }

    public void setKnown(Collection<Register> known) {
        this.clearKnown();
        if (known == null) {
            this.availableTableModel.fireTableDataChanged();
            return;
        }
        for (Register reg : known) {
            AvailableRegisterRow ar = this.regMap.get(reg);
            if (ar == null) {
                throw new IllegalArgumentException("Register " + String.valueOf(reg) + " is not in current language");
            }
            ar.setKnown(true);
        }
        this.availableTableModel.fireTableDataChanged();
    }

    protected void clearSelection() {
        for (AvailableRegisterRow ar : this.regMap.values()) {
            ar.setSelected(false);
        }
    }

    public void setSelection(Collection<Register> selection) {
        this.clearSelection();
        if (selection == null) {
            this.availableTableModel.fireTableDataChanged();
            return;
        }
        for (Register reg : selection) {
            AvailableRegisterRow ar = this.regMap.get(reg);
            if (ar == null) {
                throw new IllegalArgumentException("Register " + String.valueOf(reg) + " is not in current language");
            }
            ar.setSelected(true);
        }
        this.availableTableModel.fireTableDataChanged();
    }

    protected void addSelection(Collection<AvailableRegisterRow> selection) {
        if (selection == null) {
            return;
        }
        for (AvailableRegisterRow ar : selection) {
            ar.setSelected(true);
        }
        this.availableTableModel.fireTableDataChanged();
    }

    protected void removeSelection(Collection<AvailableRegisterRow> selection) {
        if (selection == null) {
            return;
        }
        for (AvailableRegisterRow ar : selection) {
            ar.setSelected(false);
        }
        this.availableTableModel.fireTableDataChanged();
    }

    protected void okCallback() {
        LinkedHashSet<Register> selected = new LinkedHashSet<Register>();
        for (AvailableRegisterRow row : this.availableTableModel.getModelData()) {
            if (!row.isSelected()) continue;
            selected.add(row.getRegister());
        }
        this.provider.setSelectedRegistersAndLoad(selected);
        this.close();
    }

    protected static class AvailableRegistersTableModel
    extends DefaultEnumeratedColumnTableModel<AvailableRegisterTableColumns, AvailableRegisterRow> {
        public AvailableRegistersTableModel(PluginTool tool) {
            super(tool, "Available Registers", AvailableRegisterTableColumns.class);
        }

        public List<AvailableRegisterTableColumns> defaultSortOrder() {
            return List.of(AvailableRegisterTableColumns.NUMBER);
        }
    }

    protected static enum AvailableRegisterTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<AvailableRegisterTableColumns, AvailableRegisterRow>
    {
        SELECTED("", Boolean.class, AvailableRegisterRow::isSelected, AvailableRegisterRow::setSelected, true),
        NUMBER("#", Integer.class, AvailableRegisterRow::getNumber, true),
        NAME("Name", String.class, AvailableRegisterRow::getName, true),
        BITS("Bits", Integer.class, AvailableRegisterRow::getBits, true),
        KNOWN("Known", Boolean.class, AvailableRegisterRow::isKnown, true),
        GROUP("Group", String.class, AvailableRegisterRow::getGroup, true),
        CONTAINS("Contains", String.class, AvailableRegisterRow::getContains, true),
        PARENT("Parent", String.class, AvailableRegisterRow::getParentName, true);

        private final String header;
        private final Function<AvailableRegisterRow, ?> getter;
        private final BiConsumer<AvailableRegisterRow, Object> setter;
        private final boolean sortable;
        private final Class<?> cls;

        private <T> AvailableRegisterTableColumns(String header, Class<T> cls, Function<AvailableRegisterRow, T> getter, boolean sortable) {
            this(header, cls, getter, null, sortable);
        }

        private <T> AvailableRegisterTableColumns(String header, Class<T> cls, Function<AvailableRegisterRow, T> getter, BiConsumer<AvailableRegisterRow, T> setter, boolean sortable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.sortable = sortable;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(AvailableRegisterRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(AvailableRegisterRow row) {
            return this.setter != null;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public void setValueOf(AvailableRegisterRow row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

