/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectSelectionManager;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectionManager;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterManager;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GIcon;
import ghidra.app.services.FunctionComparisonService;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.impl.VersionTrackingChangeRecord;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AcceptMatchAction;
import ghidra.feature.vt.gui.actions.ApplyBlockedMatchAction;
import ghidra.feature.vt.gui.actions.ApplyMatchAction;
import ghidra.feature.vt.gui.actions.ChooseMatchTagAction;
import ghidra.feature.vt.gui.actions.ClearMatchAction;
import ghidra.feature.vt.gui.actions.CreateSelectionAction;
import ghidra.feature.vt.gui.actions.EditAllTagsAction;
import ghidra.feature.vt.gui.actions.MatchTableSelectionAction;
import ghidra.feature.vt.gui.actions.RejectMatchAction;
import ghidra.feature.vt.gui.actions.RemoveMatchAction;
import ghidra.feature.vt.gui.actions.RemoveMatchTagAction;
import ghidra.feature.vt.gui.actions.TableSelectionTrackingState;
import ghidra.feature.vt.gui.editors.MatchTagCellEditor;
import ghidra.feature.vt.gui.filters.AncillaryFilterDialogComponentProvider;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterDialogModel;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VersionTrackingPluginPackage;
import ghidra.feature.vt.gui.provider.matchtable.ApplyMarkupPropertyEditor;
import ghidra.feature.vt.gui.provider.matchtable.ConfidenceFilter;
import ghidra.feature.vt.gui.provider.matchtable.LengthFilter;
import ghidra.feature.vt.gui.provider.matchtable.MatchTableRenderer;
import ghidra.feature.vt.gui.provider.matchtable.MatchesFilterDialogComponentProvider;
import ghidra.feature.vt.gui.provider.matchtable.ScoreFilter;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchApplySettingsAction;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchTableModel;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.feature.vt.gui.util.AllTextFilter;
import ghidra.feature.vt.gui.util.FilterIconFlashTimer;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.MatchStatusRenderer;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.feature.vt.gui.util.VTSymbolRenderer;
import ghidra.features.base.codecompare.model.FunctionComparisonModel;
import ghidra.features.base.codecompare.model.MatchedFunctionComparisonModel;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.task.SwingUpdateManager;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VTMatchTableProvider
extends ComponentProviderAdapter
implements FilterDialogModel<VTMatch>,
VTControllerListener {
    private static final Icon COMPARISON_ICON = new GIcon("icon.plugin.functioncompare.new");
    private static final String TITLE = "Version Tracking Matches";
    private static final String TABLE_SELECTION_STATE = "TABLE_SELECTION_STATE";
    public static final String TEXT_FILTER_NAME = "matches.text.filter";
    private JComponent component;
    private MatchThreadedTablePanel tablePanel;
    private GhidraTable matchesTable;
    private ListSelectionListener matchSelectionListener;
    private VTMatchTableModel matchesTableModel;
    private AncillaryFilterDialogComponentProvider<VTMatch> ancillaryFilterDialog;
    private JButton ancillaryFilterButton;
    private ColumnFilterManager<VTMatch> columnFilterManager;
    private VTColumnFilter vtColumnFilter;
    private FilterIconFlashTimer<VTMatch> iconTimer;
    private Set<Filter<VTMatch>> filters = new HashSet<Filter<VTMatch>>();
    private FilterStatusListener refilterListener = new RefilterListener();
    private final VTController controller;
    private VTMatch latestMatch;
    private SelectionOverrideMemento selectionMemento;
    private boolean filteringFrozen;
    private VTMatch pendingMatchSelection;
    private SwingUpdateManager selectMatchUpdateManager;
    private MatchTableSelectionAction tableSelectionStateAction;
    private TableSelectionTrackingState tableSelectionState;

    public VTMatchTableProvider(VTController controller) {
        super(controller.getTool(), TITLE, VTPlugin.OWNER);
        this.controller = controller;
        controller.addListener(this);
        this.setWindowGroup("VTResults.MatchesTable");
        this.setIcon(VersionTrackingPluginPackage.ICON);
        this.setDefaultWindowPosition(WindowPosition.TOP);
        this.createActions();
        this.component = this.createComponent();
        this.setVisible(true);
        this.selectMatchUpdateManager = new SwingUpdateManager(350, () -> {
            this.controller.setSelectedMatch(this.latestMatch);
            this.notifyContextChanged();
        });
        this.initializeOptions();
        this.ancillaryFilterDialog = new MatchesFilterDialogComponentProvider(controller, this);
        this.iconTimer = new FilterIconFlashTimer<VTMatch>(VTPlugin.UNFILTERED_ICON, VTPlugin.FILTERED_ICON, this.ancillaryFilterDialog, this.ancillaryFilterButton);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Matches_Table"));
    }

    private void createActions() {
        this.addLocalAction((DockingActionIf)new AcceptMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new ApplyMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new ApplyBlockedMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new VTMatchApplySettingsAction(this.controller));
        this.addLocalAction((DockingActionIf)new RejectMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new ClearMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new ChooseMatchTagAction(this.controller));
        this.addLocalAction((DockingActionIf)new RemoveMatchTagAction());
        this.addLocalAction((DockingActionIf)new EditAllTagsAction(this.controller));
        this.addLocalAction((DockingActionIf)new RemoveMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new CreateSelectionAction(this.controller));
        this.tableSelectionStateAction = new MatchTableSelectionAction(this);
        this.addLocalAction((DockingActionIf)this.tableSelectionStateAction);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Compare Functions", this.getOwner()).popupMenuPath(new String[]{"Compare Functions"})).popupMenuGroup("Selection")).popupMenuIcon(COMPARISON_ICON)).keyBinding("shift c")).sharedKeyBinding()).description("Compares the Function(s) with its remote match")).helpLocation(new HelpLocation("VersionTrackingPlugin", "Match_Table_Compare_Functions"))).withContext(VTMatchContext.class).enabledWhen(this::isValidFunctionComparison).onAction(this::compareFunctions).buildAndInstallLocal((ComponentProvider)this);
    }

    private boolean isValidFunctionComparison(VTMatchContext context) {
        List<VTMatch> functionMatches = context.getFunctionMatches();
        return !functionMatches.isEmpty();
    }

    private void compareFunctions(VTMatchContext c) {
        MatchedFunctionComparisonModel model = new MatchedFunctionComparisonModel();
        List<VTMatch> matches = c.getFunctionMatches();
        for (VTMatch match : matches) {
            MatchInfo matchInfo = this.controller.getMatchInfo(match);
            Function sourceFunction = matchInfo.getSourceFunction();
            Function destinationFunction = matchInfo.getDestinationFunction();
            model.addMatch(sourceFunction, destinationFunction);
        }
        FunctionComparisonService service = (FunctionComparisonService)this.tool.getService(FunctionComparisonService.class);
        service.createCustomComparison((FunctionComparisonModel)model, null);
    }

    public void setTableSelectionMode(TableSelectionTrackingState state) {
        this.tableSelectionState = state;
        if (state == TableSelectionTrackingState.NO_SELECTION_TRACKING) {
            this.matchesTable.getSelectionManager().clearSavedSelection();
        }
    }

    public void readConfigState(SaveState saveState) {
        for (Filter<VTMatch> filter : this.filters) {
            filter.readConfigState(saveState);
        }
        this.updateFilterDisplay();
        this.setTableSelecionState(saveState);
        this.refilter();
    }

    private void setTableSelecionState(SaveState saveState) {
        String selectionStateName = saveState.getString(TABLE_SELECTION_STATE, null);
        if (selectionStateName == null) {
            return;
        }
        TableSelectionTrackingState state = TableSelectionTrackingState.valueOf(selectionStateName);
        if (state != null) {
            this.tableSelectionStateAction.setCurrentActionStateByUserData((Object)state);
        }
    }

    private void updateFilterDisplay() {
        if (this.ancillaryFilterDialog == null) {
            return;
        }
        boolean filtered = this.ancillaryFilterDialog.isFiltered();
        if (filtered) {
            this.ancillaryFilterButton.setIcon(VTPlugin.FILTERED_ICON);
        } else {
            this.ancillaryFilterButton.setIcon(VTPlugin.UNFILTERED_ICON);
        }
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        if (filtered) {
            int filteredCount = this.matchesTableModel.getRowCount();
            int unfilteredCount = this.matchesTableModel.getUnfilteredRowCount();
            int filteredOutCount = unfilteredCount - filteredCount;
            this.ancillaryFilterButton.setToolTipText("More Filters - " + filteredOutCount + " item(s) hidden");
        } else {
            this.ancillaryFilterButton.setToolTipText("More Filters - no active filters");
        }
    }

    public void writeConfigState(SaveState saveState) {
        for (Filter<VTMatch> filter : this.filters) {
            filter.writeConfigState(saveState);
        }
        saveState.putString(TABLE_SELECTION_STATE, this.tableSelectionState.name());
    }

    public void componentShown() {
        if (this.latestMatch != null) {
            this.setSelectedMatch(this.latestMatch);
        }
        this.matchesTableModel.sessionChanged();
        this.notifyContextChanged();
    }

    GTable getTable() {
        return this.matchesTable;
    }

    private JComponent createComponent() {
        this.matchesTable = this.createMatchesTable();
        JPanel matchesTablePanel = new JPanel(new BorderLayout());
        JPanel filterAreaPanel = this.createFilterArea();
        matchesTablePanel.add((Component)((Object)this.tablePanel), "Center");
        matchesTablePanel.add((Component)filterAreaPanel, "South");
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add(matchesTablePanel);
        this.matchesTable.setAccessibleNamePrefix("Matches");
        return parentPanel;
    }

    private VTMatchTableModel createTableModel() {
        this.matchesTableModel = new VTMatchTableModel(this.controller);
        this.matchesTableModel.addTableModelListener(e -> {
            if (this.matchesTable == null) {
                return;
            }
            int filteredCount = this.matchesTableModel.getRowCount();
            int unfilteredCount = this.matchesTableModel.getUnfilteredRowCount();
            String sessionName = this.controller.getVersionTrackingSessionName();
            StringBuilder buffy = new StringBuilder();
            buffy.append("[Session: ").append(sessionName).append("] - ");
            buffy.append(filteredCount).append(" matches");
            if (filteredCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(')');
            }
            this.setSubTitle(buffy.toString());
            this.updateFilterDisplay();
            if (this.pendingMatchSelection != null) {
                this.setSelectedMatch(this.pendingMatchSelection);
            } else if (this.selectionMemento != null) {
                this.selectionMemento.restoreSelection();
            }
        });
        return this.matchesTableModel;
    }

    private GhidraTable createMatchesTable() {
        this.tablePanel = new MatchThreadedTablePanel((ThreadedTableModel<VTMatch, ?>)this.createTableModel());
        final GhidraTable table = this.tablePanel.getTable();
        table.setActionsEnabled(true);
        table.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VTMatchTableProvider.this.iconTimer.restart();
            }
        });
        this.matchSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VTMatch match;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RowObjectTableModel model = (RowObjectTableModel)table.getModel();
                boolean hasSingleSelection = table.getSelectedRowCount() == 1;
                int selectedRow = table.getSelectedRow();
                VTMatch vTMatch = match = hasSingleSelection ? (VTMatch)model.getRowObject(selectedRow) : null;
                if (!SystemUtilities.isEqual((Object)VTMatchTableProvider.this.latestMatch, (Object)match)) {
                    VTMatchTableProvider.this.latestMatch = match;
                    VTMatchTableProvider.this.selectMatchUpdateManager.updateLater();
                } else {
                    VTMatchTableProvider.this.notifyContextChanged();
                }
            }
        };
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(this.matchSelectionListener);
        TableColumnModel columnModel = table.getColumnModel();
        int tagColumnIndex = this.matchesTableModel.getColumnIndex(AbstractVTMatchTableModel.TagTableColumn.class);
        TableColumn tagColumn = columnModel.getColumn(tagColumnIndex);
        tagColumn.setCellEditor(new MatchTagCellEditor(this.controller));
        int sourceLabelColumnIndex = this.matchesTableModel.getColumnIndex(AbstractVTMatchTableModel.SourceLabelTableColumn.class);
        TableColumn sourceLabelColumn = columnModel.getColumn(sourceLabelColumnIndex);
        sourceLabelColumn.setCellRenderer((TableCellRenderer)((Object)new VTSymbolRenderer(this.controller.getServiceProvider(), (JComponent)table)));
        int destinationLabelColumnIndex = this.matchesTableModel.getColumnIndex(AbstractVTMatchTableModel.DestinationLabelTableColumn.class);
        TableColumn destinationLabelColumn = columnModel.getColumn(destinationLabelColumnIndex);
        destinationLabelColumn.setCellRenderer((TableCellRenderer)((Object)new VTSymbolRenderer(this.controller.getServiceProvider(), (JComponent)table)));
        int statusColumnIndex = this.matchesTableModel.getColumnIndex(AbstractVTMatchTableModel.StatusTableColumn.class);
        TableColumn statusColumn = columnModel.getColumn(statusColumnIndex);
        statusColumn.setCellRenderer((TableCellRenderer)((Object)new MatchStatusRenderer()));
        Dimension size = table.getPreferredScrollableViewportSize();
        Dimension preferredSize = table.getPreferredSize();
        JScrollBar scrollBar = new JScrollBar(1);
        Dimension scrollBarSize = scrollBar.getMinimumSize();
        size.width = preferredSize.width + scrollBarSize.width;
        table.setPreferredScrollableViewportSize(size);
        return table;
    }

    private JPanel createFilterArea() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel((LayoutManager)new HorizontalLayout(4));
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        JComponent textFilterPanel = this.createTextFilterPanel();
        parentPanel.add((Component)textFilterPanel, "Center");
        parentPanel.add((Component)innerPanel, "East");
        JComponent scoreFilterPanel = this.createScoreFilterPanel();
        innerPanel.add(scoreFilterPanel);
        JComponent confidenceFilterPanel = this.createConfidenceFilterPanel();
        innerPanel.add(confidenceFilterPanel);
        JComponent lengthFilterPanel = this.createLengthFilterPanel();
        innerPanel.add(lengthFilterPanel);
        this.ancillaryFilterButton = new JButton(VTPlugin.UNFILTERED_ICON);
        this.ancillaryFilterButton.addActionListener(e -> this.tool.showDialog(this.ancillaryFilterDialog, (Component)this.component));
        this.ancillaryFilterButton.setToolTipText("Filters Dialog");
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation filterHelpLocation = new HelpLocation("VersionTrackingPlugin", "Match_Filters");
        helpService.registerHelp((Object)parentPanel, filterHelpLocation);
        helpService.registerHelp((Object)this.ancillaryFilterButton, filterHelpLocation);
        JButton columnFilterButton = this.createColumnFilterButton();
        innerPanel.add(columnFilterButton);
        innerPanel.add(this.ancillaryFilterButton);
        return parentPanel;
    }

    private JButton createColumnFilterButton() {
        String preferenceKey = this.matchesTable.getPreferenceKey() + ".FilterExtension";
        this.columnFilterManager = new ColumnFilterManager((JTable)this.matchesTable, (RowObjectFilterModel)this.matchesTableModel, preferenceKey, this::updateColumnFilter);
        this.vtColumnFilter = new VTColumnFilter(this, (ColumnBasedTableFilter<VTMatch>)this.columnFilterManager.getCurrentFilter());
        this.addFilter(this.vtColumnFilter);
        return this.columnFilterManager.getConfigureButton();
    }

    private void updateColumnFilter() {
        this.vtColumnFilter.setFilter((ColumnBasedTableFilter<VTMatch>)this.columnFilterManager.getCurrentFilter());
        this.refilter();
    }

    private JComponent createTextFilterPanel() {
        AllTextFilter<VTMatch> allTextFilter = new AllTextFilter<VTMatch>(this.controller, (GTable)this.matchesTable, (ThreadedTableModel<VTMatch, ?>)this.matchesTableModel);
        allTextFilter.setName(TEXT_FILTER_NAME);
        this.addFilter((Filter<VTMatch>)allTextFilter);
        return allTextFilter.getComponent();
    }

    private JComponent createLengthFilterPanel() {
        LengthFilter lengthFilter = new LengthFilter();
        this.addFilter(lengthFilter);
        return lengthFilter.getComponent();
    }

    private JComponent createScoreFilterPanel() {
        ScoreFilter scoreFilter = new ScoreFilter();
        this.addFilter(scoreFilter);
        return scoreFilter.getComponent();
    }

    private JComponent createConfidenceFilterPanel() {
        ConfidenceFilter confidenceFilter = new ConfidenceFilter();
        this.addFilter(confidenceFilter);
        return confidenceFilter.getComponent();
    }

    private void refilter() {
        if (this.filteringFrozen) {
            return;
        }
        this.forceRefilter();
    }

    private void setSelectedMatch(VTMatch match) {
        int row = this.matchesTableModel.getRowIndex(match);
        if (row < 0) {
            this.pendingMatchSelection = match;
            return;
        }
        this.pendingMatchSelection = null;
        this.matchesTable.getSelectionModel().setSelectionInterval(row, row);
        Rectangle rect = this.matchesTable.getCellRect(row, 0, false);
        this.matchesTable.scrollRectToVisible(rect);
    }

    public void repaint() {
        if (this.matchesTable == null) {
            return;
        }
        this.matchesTable.repaint();
    }

    private void reload() {
        this.controller.setSelectedMatch(null);
        this.matchesTableModel.clearData();
        this.matchesTableModel.reload();
        this.notifyContextChanged();
    }

    private void updateWithoutFullReload() {
        this.matchesTableModel.reSort();
        this.matchesTableModel.updateFilter();
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void disposed() {
        if (this.matchesTable == null) {
            return;
        }
        ListSelectionModel selectionModel = this.matchesTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.matchSelectionListener);
        this.matchesTableModel.dispose();
        for (Filter<VTMatch> filter : this.filters) {
            filter.dispose();
        }
        this.ancillaryFilterDialog.dispose();
        this.columnFilterManager.dispose();
    }

    @Override
    public void sessionChanged(VTSession session) {
        if (!this.isVisible()) {
            return;
        }
        this.latestMatch = null;
        this.selectionMemento = null;
        this.matchesTableModel.sessionChanged();
        this.updateFilterDisplay();
        if (session != null && this.isVisible()) {
            this.tool.toFront((ComponentProvider)this);
        }
        this.notifyContextChanged();
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        if (ev.contains(new EventType[]{DomainObjectEvent.RESTORED, VTEvent.MATCH_SET_ADDED})) {
            this.saveComplexSelectionUpdate();
            this.reload();
            return;
        }
        boolean matchesContextChanged = false;
        for (int i = 0; i < ev.numRecords(); ++i) {
            VersionTrackingChangeRecord vtRecord;
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            EventType eventType = doRecord.getEventType();
            if (eventType == VTEvent.ASSOCIATION_STATUS_CHANGED || eventType == VTEvent.ASSOCIATION_MARKUP_STATUS_CHANGED) {
                this.updateWithoutFullReload();
                matchesContextChanged = true;
                this.saveComplexSelectionUpdate();
                continue;
            }
            if (eventType == VTEvent.MATCH_TAG_CHANGED) {
                this.updateWithoutFullReload();
                matchesContextChanged = true;
                continue;
            }
            if (eventType == VTEvent.MATCH_ADDED) {
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                this.matchesTableModel.addObject((VTMatch)vtRecord.getNewValue());
                matchesContextChanged = true;
                continue;
            }
            if (eventType != VTEvent.MATCH_DELETED) continue;
            vtRecord = (VersionTrackingChangeRecord)doRecord;
            this.matchesTableModel.removeObject((VTMatch)vtRecord.getObject());
            matchesContextChanged = true;
        }
        if (matchesContextChanged) {
            this.reload();
            this.tool.contextChanged((ComponentProvider)this);
        }
    }

    private SelectionOverrideMemento saveComplexSelectionUpdate() {
        SelectionOverrideMemento mostRecentMemento = this.getCurrentSelectionMemento();
        if (mostRecentMemento != null) {
            this.selectionMemento = mostRecentMemento;
            return this.selectionMemento;
        }
        return this.selectionMemento;
    }

    private SelectionOverrideMemento getCurrentSelectionMemento() {
        int[] selectedRows = this.matchesTable.getSelectedRows();
        int length = selectedRows.length;
        if (length == 0) {
            return null;
        }
        int row = selectedRows[0];
        VTMatch match = (VTMatch)this.matchesTableModel.getRowObject(row);
        return new SelectionOverrideMemento(row, match);
    }

    public ActionContext getActionContext(MouseEvent event) {
        List<VTMatch> selectedMatches = this.getSelectedMatches();
        return new VTMatchContext(this, selectedMatches, this.controller.getSession());
    }

    private List<VTMatch> getSelectedMatches() {
        int[] selectedRows;
        ArrayList<VTMatch> list = new ArrayList<VTMatch>();
        if (this.matchesTable == null) {
            return list;
        }
        for (int row : selectedRows = this.matchesTable.getSelectedRows()) {
            VTMatch match = (VTMatch)this.matchesTableModel.getRowObject(row);
            if (match == null) continue;
            list.add(match);
        }
        return list;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
        VTMatch match;
        VTMatch vTMatch = match = matchInfo == null ? null : matchInfo.getMatch();
        if (match == this.latestMatch) {
            return;
        }
        if (!this.isVisible()) {
            this.latestMatch = match;
            return;
        }
        this.setSelectedMatch(match);
    }

    @Override
    public void optionsChanged(Options options) {
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    private void initializeOptions() {
        ToolOptions vtOptions = this.controller.getOptions();
        vtOptions.registerOption("Accept Match Options.Auto Create Implied Matches", (Object)true, null, "Create implied (referenced) matches when accepting a match");
        vtOptions.registerOption("Accept Match Options.Automatically Apply Function Name on Accept", (Object)true, null, "Automatically apply function names when accepting a match");
        vtOptions.registerOption("Accept Match Options.Automatically Apply Data Label on Accept", (Object)true, null, "Automatically apply data labels when accepting a match");
        vtOptions.registerOption("Apply Markup Options.Data Match Data Type", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_DATA_MATCH_DATA_TYPE, null, "The default apply action <b>for the data type on a data match</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Labels", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_LABELS, null, "The default apply action <b>for labels</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Name", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME, null, "The default apply action <b>for function name</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Signature", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE, null, "The default apply action <b>for the function signature</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Plate Comment", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PLATE_COMMENTS, null, "The default apply action <b>for plate comments</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Pre Comment", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PRE_COMMENTS, null, "The default apply action <b>for pre comments</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.End of Line Comment", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_EOL_COMMENTS, null, "The default apply action <b>for end of line comments</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Repeatable Comment", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_REPEATABLE_COMMENTS, null, "The default apply action <b>for repeatable comments</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Post Comment", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_POST_COMMENTS, null, "The default apply action <b>for post comments</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Inline", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_INLINE, null, "The default apply action <b>for the function inline flag</b> to use when applying the function signature as part of a bulk apply operation");
        vtOptions.registerOption("Apply Markup Options.Function No Return", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_NO_RETURN, null, "The default apply action <b>for the function no return flag</b> to use when applying the function signature as part of a bulk apply operation");
        vtOptions.registerOption("Apply Markup Options.Function Calling Convention", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_CALLING_CONVENTION, null, "The default apply action <b>for the function calling convention</b> to use when applying the function signature as part of a bulk apply operation");
        vtOptions.registerOption("Apply Markup Options.Function Call Fixup", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_CALL_FIXUP, null, "The default apply action <b>for whether or not to apply call fixup</b> when applying the function signature as part of a bulk apply operation");
        vtOptions.registerOption("Apply Markup Options.Function Var Args", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_VAR_ARGS, null, "The default apply action <b>for the var args flag</b> to use when applying the function signature as part of a bulk apply operation");
        vtOptions.registerOption("Apply Markup Options.Function Return Type", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_RETURN_TYPE, null, "The default apply action <b>for function return type</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Parameter Data Types", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_DATA_TYPES, null, "The default apply action <b>for function parameter data types</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Parameter Names", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES, null, "The default apply action <b>for function parameter names</b> when performing bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Function Parameter Names Highest Name Priority", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_HIGHEST_NAME_PRIORITY, null, "The default apply action <b>for which source type is the highest priority</b> when applying parameter names using a priority replace");
        vtOptions.registerOption("Apply Markup Options.Function Parameter Names Replace If Same Priority", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES_REPLACE_IF_SAME_PRIORITY, null, "When function signature parameter names are being replaced based on source type priority, replace the destination name with the source name if their source types are the same.");
        vtOptions.registerOption("Apply Markup Options.Function Parameter Comments", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_COMMENTS, null, "The default apply action <b>for function parameter comments</b> when applying parameter names as part of a bulk apply operations");
        vtOptions.registerOption("Apply Markup Options.Set Excluded Markup Items To Ignored", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_EXCLUDED_MARKUP_ITEMS, null, "Types of markup items that have been excluded when applying should become ignored by applying a match.");
        vtOptions.registerOption("Apply Markup Options.Set Incomplete Markup Items To Ignored", (Object)VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_INCOMPLETE_MARKUP_ITEMS, null, "Markup items that are incomplete (for example, no destination address is specified) should become ignored by applying a match.");
        vtOptions.getOptions("Apply Markup Options").registerOptionsEditor(() -> new ApplyMarkupPropertyEditor(this.controller));
        vtOptions.getOptions("Apply Markup Options.Display Apply Markup Options").setOptionsHelpLocation(new HelpLocation("VersionTracking", "Apply Markup Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Create Implied Matches", (Object)true, null, "Create Implied Matches when AutoVT correlators apply function matches.");
        vtOptions.registerOption("Auto Version Tracking Options.Run Exact Data Correlator", (Object)true, null, "Run the Exact Data Correlator");
        vtOptions.registerOption("Auto Version Tracking Options.Run Exact Symbol Correlator", (Object)true, null, "Run the Exact Symbol Correlator");
        vtOptions.registerOption("Auto Version Tracking Options.Run Exact Function Bytes Correlator", (Object)true, null, "Run the Exact Function Bytes Correlator");
        vtOptions.registerOption("Auto Version Tracking Options.Run Exact Function Instructions Correlators", (Object)true, null, "Run the Exact Function Instruction Bytes and Mnemonics Correlators");
        vtOptions.registerOption("Auto Version Tracking Options.Run Duplicate Function Correlator", (Object)true, null, "Run the Duplicate Function Instruction Correlator");
        vtOptions.registerOption("Auto Version Tracking Options.Run the Reference Correlators", (Object)true, null, "Run the Reference Correlators");
        vtOptions.getOptions("Auto Version Tracking Options.Implied Match Correlator Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.getOptions("Auto Version Tracking Options.Symbol Correlator Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.getOptions("Auto Version Tracking Options.Data Correlator Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.getOptions("Auto Version Tracking Options.Exact Function Correlators Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.getOptions("Auto Version Tracking Options.Duplicate Function Correlator Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.getOptions("Auto Version Tracking Options.Reference Correlators Options").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Implied Match Correlator Options.Apply Implied Matches", (Object)true, null, "Apply implied matches if minimum vote count is met and maximum conflict count is not exceeded.");
        vtOptions.registerOption("Auto Version Tracking Options.Implied Match Correlator Options.Minimum Votes Needed", (Object)2, null, "The minimum number of votes needed to apply an implied match.");
        vtOptions.registerOption("Auto Version Tracking Options.Implied Match Correlator Options.Maximum Conflicts Allowed", (Object)0, null, "The maximum number of conflicts allowed to apply an implied match.");
        vtOptions.registerOption("Auto Version Tracking Options.Symbol Correlator Options.Symbol Correlator Minimum Symbol Length", (Object)3, null, "Minimum Symbol Name Length of Auto Version Tracking Symbol Correlator");
        vtOptions.getOptions("Auto Version Tracking Options.Symbol Correlator Options.Symbol Correlator Minimum Symbol Length").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Data Correlator Options.Data Correlator Minimum Data Length", (Object)5, null, "Minimum Data Length of Auto Version Tracking Data Correlator");
        vtOptions.getOptions("Auto Version Tracking Options.Data Correlator Options.Data Correlator Minimum Data Length").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Exact Function Correlators Options.Exact Function Correlators Minimum Function Length", (Object)10, null, "Minimum Function Length of Auto Version Tracking Duplicate Function Correlator");
        vtOptions.getOptions("Auto Version Tracking Options.Exact Function Correlators Options.Exact Function Correlators Minimum Function Length").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Duplicate Function Correlator Options.Duplicate Function Correlator Minimum Function Length", (Object)25, null, "Minimum Function Length of Auto Version Tracking Duplicate Function Correlator");
        vtOptions.getOptions("Auto Version Tracking Options.Duplicate Function Correlator Options.Duplicate Function Correlator Minimum Function Length").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Score", (Object)0.95, null, "Minimum Score of all Auto Version Tracking Reference Function Correlators (Data, Function, and Combined Function and Data)");
        vtOptions.getOptions("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Score").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        vtOptions.registerOption("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Confidence", (Object)10.0, null, "Minimum Confidence of all Auto Version Tracking Reference Function Correlator (Data, Function, and Combined Function and Data)");
        vtOptions.getOptions("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Confidence").setOptionsHelpLocation(new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options"));
        HelpLocation applyOptionsHelpLocation = new HelpLocation("VersionTrackingPlugin", "Version_Tracking_Apply_Options");
        HelpLocation applyMatchOptionsHelpLocation = new HelpLocation("VersionTrackingPlugin", "Match_Apply_Options");
        HelpLocation autoVTHelpLocation = new HelpLocation("VersionTrackingPlugin", "Auto_Version_Tracking_Options");
        vtOptions.setOptionsHelpLocation(applyOptionsHelpLocation);
        vtOptions.getOptions("Accept Match Options").setOptionsHelpLocation(applyMatchOptionsHelpLocation);
        vtOptions.getOptions("Apply Markup Options").setOptionsHelpLocation(applyMatchOptionsHelpLocation);
        vtOptions.setOptionsHelpLocation(autoVTHelpLocation);
        vtOptions.getOptions("Auto Version Tracking Options").setOptionsHelpLocation(autoVTHelpLocation);
    }

    @Override
    public void addFilter(Filter<VTMatch> filter) {
        filter.addFilterStatusListener(this.refilterListener);
        this.filters.add(filter);
        this.matchesTableModel.addFilter(filter);
    }

    @Override
    public void forceRefilter() {
        this.matchesTableModel.updateFilter();
        this.updateFilterDisplay();
    }

    @Override
    public void dialogVisibilityChanged(boolean isVisible) {
        this.filteringFrozen = isVisible;
        this.refilter();
    }

    private class RefilterListener
    implements FilterStatusListener {
        private RefilterListener() {
        }

        @Override
        public void filterStatusChanged(Filter.FilterEditingStatus status) {
            if (status != Filter.FilterEditingStatus.ERROR) {
                VTMatchTableProvider.this.refilter();
            }
        }
    }

    private class MatchThreadedTablePanel
    extends GhidraThreadedTablePanel<VTMatch> {
        private MatchTableRenderer matchRenderer;

        MatchThreadedTablePanel(ThreadedTableModel<VTMatch, ?> model) {
            super(model);
            this.matchRenderer = new MatchTableRenderer();
        }

        protected GTable createTable(ThreadedTableModel<VTMatch, ?> model) {
            return new MatchTable((RowObjectTableModel<VTMatch>)model);
        }

        private class MatchTable
        extends GhidraTable {
            MatchTable(RowObjectTableModel<VTMatch> model) {
                super(model);
            }

            public TableCellRenderer getCellRenderer(int row, int col) {
                return MatchThreadedTablePanel.this.matchRenderer;
            }

            protected SelectionManager createSelectionManager() {
                return new VTMatchTableSelectionManager((JTable)((Object)this), (AbstractSortedTableModel<VTMatch>)((AbstractSortedTableModel)this.getModel()));
            }
        }
    }

    private class VTColumnFilter
    extends Filter<VTMatch> {
        private ColumnBasedTableFilter<VTMatch> columnFilter;

        VTColumnFilter(VTMatchTableProvider vTMatchTableProvider, ColumnBasedTableFilter<VTMatch> columnFilter) {
            this.columnFilter = columnFilter;
        }

        void setFilter(ColumnBasedTableFilter<VTMatch> columnFilter) {
            this.columnFilter = columnFilter;
        }

        @Override
        public boolean passesFilter(VTMatch t) {
            if (this.columnFilter == null) {
                return true;
            }
            return this.columnFilter.acceptsRow((Object)t);
        }

        @Override
        public Filter.FilterEditingStatus getFilterStatus() {
            if (this.columnFilter == null || this.columnFilter.isEmpty()) {
                return Filter.FilterEditingStatus.NONE;
            }
            return Filter.FilterEditingStatus.APPLIED;
        }

        @Override
        public JComponent getComponent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Filter.FilterShortcutState getFilterShortcutState() {
            return Filter.FilterShortcutState.REQUIRES_CHECK;
        }

        @Override
        public Filter<VTMatch> createCopy() {
            return this;
        }

        @Override
        public void readConfigState(SaveState saveState) {
        }

        @Override
        public void writeConfigState(SaveState saveState) {
        }

        @Override
        public boolean isSubFilterOf(Filter<VTMatch> otherFilter) {
            Class<?> otherClazz;
            Class<?> clazz = this.getClass();
            if (!clazz.equals(otherClazz = otherFilter.getClass())) {
                return false;
            }
            VTColumnFilter otherColumnFilter = (VTColumnFilter)otherFilter;
            if (this.columnFilter == null && otherColumnFilter.columnFilter == null) {
                return true;
            }
            return this.columnFilter.isSubFilterOf(otherColumnFilter.columnFilter);
        }
    }

    private class SelectionOverrideMemento {
        private final int row;
        private final VTMatch match;

        SelectionOverrideMemento(int row, VTMatch match) {
            this.row = row;
            this.match = match;
            if (row < 0) {
                throw new AssertException("Saved selection row must be > 0!");
            }
            if (match == null) {
                throw new AssertException("Saved selected match cannot be null!");
            }
            SelectionManager selectionManager = VTMatchTableProvider.this.matchesTable.getSelectionManager();
            selectionManager.clearSavedSelection();
        }

        void restoreSelection() {
            if (VTMatchTableProvider.this.tableSelectionState == TableSelectionTrackingState.NO_SELECTION_TRACKING) {
                return;
            }
            int rowCount = VTMatchTableProvider.this.matchesTableModel.getRowCount();
            if (rowCount == 0) {
                return;
            }
            VTMatchTableProvider.this.selectionMemento = null;
            ListSelectionModel selectionModel = VTMatchTableProvider.this.matchesTable.getSelectionModel();
            int rowToSelect = this.row;
            if (this.row > VTMatchTableProvider.this.matchesTableModel.getRowCount()) {
                this.tryToSelectMatch(selectionModel);
                return;
            }
            selectionModel.clearSelection();
            if (VTMatchTableProvider.this.tableSelectionState == TableSelectionTrackingState.MAINTAIN_SELECTED_ROW_INDEX) {
                selectionModel.setSelectionInterval(rowToSelect, rowToSelect);
                VTMatchTableProvider.this.matchesTable.scrollToSelectedRow();
            } else if (VTMatchTableProvider.this.tableSelectionState == TableSelectionTrackingState.MAINTAIN_SELECTED_ROW_VALUE) {
                this.tryToSelectMatch(selectionModel);
            } else {
                throw new AssertException("Unhandled " + TableSelectionTrackingState.class.getSimpleName() + " value--a new state must have been added");
            }
        }

        private void tryToSelectMatch(ListSelectionModel selectionModel) {
            int matchRow = VTMatchTableProvider.this.matchesTableModel.getRowIndex(this.match);
            if (matchRow >= 0 && matchRow < VTMatchTableProvider.this.matchesTableModel.getRowCount()) {
                selectionModel.setSelectionInterval(matchRow, matchRow);
                VTMatchTableProvider.this.matchesTable.scrollToSelectedRow();
            }
        }

        public String toString() {
            return "row=" + this.row + "; match=" + String.valueOf(this.match);
        }
    }

    private class VTMatchTableSelectionManager
    extends RowObjectSelectionManager<VTMatch> {
        VTMatchTableSelectionManager(JTable table, AbstractSortedTableModel<VTMatch> tableModel) {
            super(table, tableModel);
        }

        protected List<VTMatch> translateRowsToValues(int[] rows) {
            switch (VTMatchTableProvider.this.tableSelectionState) {
                case MAINTAIN_SELECTED_ROW_INDEX: {
                    ArrayList<VTMatch> list = new ArrayList<VTMatch>(this.rowsToMatches(rows));
                    return list;
                }
                case MAINTAIN_SELECTED_ROW_VALUE: {
                    return super.translateRowsToValues(rows);
                }
                case NO_SELECTION_TRACKING: {
                    return Collections.emptyList();
                }
            }
            throw new AssertException("Unhandled " + TableSelectionTrackingState.class.getSimpleName() + " value--a new state must have been added");
        }

        private List<VTMatch> rowsToMatches(int[] rows) {
            ArrayList<VTMatch> list = new ArrayList<VTMatch>(rows.length);
            for (int row : rows) {
                VTMatch match = (VTMatch)VTMatchTableProvider.this.matchesTableModel.getRowObject(row);
                list.add(match);
            }
            return list;
        }
    }
}

