/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import ghidra.pty.windows.Handle;
import java.io.IOException;
import java.io.InputStream;

public class HandleInputStream
extends InputStream {
    private final Handle handle;
    private boolean closed = false;

    HandleInputStream(Handle handle) {
        this.handle = handle;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        byte[] buf = new byte[1];
        if (0 == this.read(buf)) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    protected void waitPipeConnected() {
        if (Kernel32.INSTANCE.ConnectNamedPipe(this.handle.getNative(), null)) {
            return;
        }
        int error = Kernel32.INSTANCE.GetLastError();
        if (error == 535) {
            return;
        }
        throw new LastErrorException(error);
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        IntByReference dwRead = new IntByReference();
        block4: while (!Kernel32.INSTANCE.ReadFile(this.handle.getNative(), b, b.length, dwRead, null)) {
            int error = Kernel32.INSTANCE.GetLastError();
            switch (error) {
                case 109: {
                    return -1;
                }
                case 536: {
                    this.waitPipeConnected();
                    continue block4;
                }
            }
            throw new IOException("Could not read", new LastErrorException(error));
        }
        return dwRead.getValue();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        byte[] temp = new byte[len];
        int read = this.read(temp);
        if (read > 0) {
            System.arraycopy(temp, 0, b, off, read);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.handle.close();
    }
}

