/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public abstract class FunctionDescriptionMapper {
    protected int recnum;

    public abstract void handleExecutable(ExecutableRecord var1) throws IOException, InterruptedException;

    public abstract void handleFunction(FunctionDescription var1, int var2) throws IOException, InterruptedException;

    public void processFile(XmlPullParser parser, LSHVectorFactory vectorFactory) throws IOException, InterruptedException, LSHException {
        this.recnum = 0;
        DescriptionManager dmanage = null;
        parser.start(new String[]{"description"});
        while (parser.peek().isStart()) {
            parser.start(new String[]{"execlist"});
            dmanage = new DescriptionManager();
            ExecutableRecord erec = ExecutableRecord.restoreXml(parser, dmanage);
            this.handleExecutable(erec);
            while (parser.peek().isStart()) {
                FunctionDescription fdesc = FunctionDescription.restoreXml(parser, vectorFactory, dmanage, erec);
                this.handleFunction(fdesc, this.recnum);
                dmanage.clearFunctions();
                ++this.recnum;
            }
            parser.end();
        }
        parser.end();
    }
}

