/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.http5.Http5FileObject;
import org.apache.commons.vfs2.provider.http5.Http5FileProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;

public class Http5FileSystem
extends AbstractFileSystem {
    private final URI internalBaseURI;
    private final HttpClient httpClient;
    private final HttpClientContext httpClientContext;

    protected Http5FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, HttpClient httpClient, HttpClientContext httpClientContext) {
        super(rootName, null, fileSystemOptions);
        String rootURI = this.getRootURI();
        int offset = rootURI.indexOf(58);
        char lastCharOfScheme = offset > 0 ? rootURI.charAt(offset - 1) : (char)'\u0000';
        this.internalBaseURI = lastCharOfScheme == 's' || lastCharOfScheme == 'S' ? URI.create("https" + rootURI.substring(offset)) : URI.create("http" + rootURI.substring(offset));
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(Http5FileProvider.CAPABILITIES);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new Http5FileObject<Http5FileSystem>(name, this);
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing HttpClient", e);
            }
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpClientContext getHttpClientContext() {
        return this.httpClientContext;
    }

    protected URI getInternalBaseURI() {
        return this.internalBaseURI;
    }
}

