/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.util.PointSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.RectangleSummaryStatistics;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expansion {
    private static Logger log = LoggerFactory.getLogger(Expansion.class);

    public static <V> Rectangle computeLayoutExtent(LayoutModel<V> layoutModel, Collection<Point> locations) {
        if (layoutModel.getLocations().size() == 0) {
            return Rectangle.from(Point.ORIGIN, Point.ORIGIN);
        }
        PointSummaryStatistics pss = new PointSummaryStatistics();
        layoutModel.getLocations().values().forEach(pss::accept);
        locations.forEach(pss::accept);
        return Rectangle.from(pss.getMin(), pss.getMax());
    }

    public static <V> Rectangle computeRectanglesExtent(Collection<Rectangle> rectangles) {
        if (rectangles.size() == 0) {
            return Rectangle.from(Point.ORIGIN, Point.ORIGIN);
        }
        RectangleSummaryStatistics pss = new RectangleSummaryStatistics();
        rectangles.forEach(pss::accept);
        return Rectangle.from(pss.getMin(), pss.getMax());
    }

    public static <V> Rectangle computePointsExtent(Collection<Point> points) {
        if (points.size() == 0) {
            return Rectangle.from(Point.ORIGIN, Point.ORIGIN);
        }
        PointSummaryStatistics pss = new PointSummaryStatistics();
        points.forEach(pss::accept);
        return Rectangle.from(pss.getMin(), pss.getMax());
    }

    public static <V> Rectangle computeLayoutExtent2(LayoutModel<V> layoutModel, Collection<List<Point>> locations) {
        return Expansion.computeLayoutExtent(layoutModel, locations.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public static <V> Rectangle computeLayoutExtent(LayoutModel<V> layoutModel) {
        return Expansion.computeLayoutExtent(layoutModel, Collections.emptySet());
    }

    public static <V> void expandToFill(LayoutModel<V> layoutModel) {
        Expansion.expandToFill(layoutModel, Collections.emptySet());
    }

    public static <V> void expandToFill(LayoutModel<V> layoutModel, Collection<Point> locations) {
        Rectangle vertexContainingRectangle = Expansion.computeLayoutExtent(layoutModel, locations);
        int maxDimension = Math.max((int)vertexContainingRectangle.width, (int)vertexContainingRectangle.height);
        layoutModel.setSize(maxDimension, maxDimension);
        Expansion.expandToFill(layoutModel, vertexContainingRectangle);
    }

    public static <V, E> void expandToFill(LayoutModel<V> layoutModel, Rectangle occupiedRegion) {
        int regionX = (int)occupiedRegion.x;
        int regionY = (int)occupiedRegion.y;
        int regionWidth = (int)occupiedRegion.width;
        int regionHeight = (int)occupiedRegion.height;
        if (regionWidth > regionHeight) {
            double expansion = (double)regionWidth / (double)regionHeight;
            Graph graph = layoutModel.getGraph();
            graph.vertexSet().stream().filter(v -> !layoutModel.isLocked(v)).forEach(v -> {
                Point p = layoutModel.get(v);
                p = Point.of(p.x, expansion * (p.y - (double)regionY));
                layoutModel.set(v, p);
            });
        } else if (regionWidth < regionHeight) {
            double expansion = (double)regionHeight / (double)regionWidth;
            Graph graph = layoutModel.getGraph();
            graph.vertexSet().stream().filter(v -> !layoutModel.isLocked(v)).forEach(v -> {
                Point p = layoutModel.get(v);
                p = Point.of(expansion * (p.x - (double)regionX), p.y);
                layoutModel.set(v, p);
            });
        }
    }

    public static <V> void expandToFillBothAxes(LayoutModel<V> layoutModel, Collection<Point> locations) {
        Rectangle vertexContainingRectangle = Expansion.computeLayoutExtent(layoutModel, locations);
        log.info("vertexContainingRectangle: {}", (Object)vertexContainingRectangle);
        Expansion.expandToFillBothAxes(layoutModel, vertexContainingRectangle);
        log.info("filled locations:\n{}", layoutModel.getLocations());
    }

    public static <V, E> void expandToFillBothAxes(LayoutModel<V> layoutModel, Rectangle occupiedRegion) {
        int regionX = (int)occupiedRegion.x;
        int regionY = (int)occupiedRegion.y;
        int regionWidth = (int)occupiedRegion.width;
        int regionHeight = (int)occupiedRegion.height;
        double horizontalExpansion = (double)layoutModel.getWidth() / (double)regionWidth;
        double verticalExpansion = (double)layoutModel.getHeight() / (double)regionHeight;
        log.info("horizontalExpansion: {}", (Object)horizontalExpansion);
        log.info("verticalExpansion: {}", (Object)verticalExpansion);
        Graph graph = layoutModel.getGraph();
        graph.vertexSet().stream().filter(v -> !layoutModel.isLocked(v)).forEach(v -> {
            Point p = layoutModel.get(v);
            p = Point.of(horizontalExpansion * (p.x - (double)regionX), verticalExpansion * (p.y - (double)regionY));
            layoutModel.set(v, p);
        });
    }
}

