/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.FunctionPair;
import java.util.ArrayList;
import java.util.Set;

public abstract class NeighborGenerator {
    public static final int RELATIVE_COMPARES = 25;
    private double impThreshold;
    private LSHVectorFactory vectorFactory;

    public NeighborGenerator(LSHVectorFactory vectorFactory, double impThreshold) {
        this.vectorFactory = vectorFactory;
        this.impThreshold = impThreshold;
    }

    public abstract NeighborhoodPair generate(FunctionNode var1, FunctionNode var2);

    private void searchForNewMatches(ArrayList<FunctionNode> unmatchedSource, ArrayList<FunctionNode> unmatchedDest) {
        VectorCompare veccompare = new VectorCompare();
        for (FunctionNode src : unmatchedSource) {
            LSHVector srcvec = src.getVector();
            for (FunctionNode dst : unmatchedDest) {
                if (src.findEdge(dst) != null) continue;
                double similarity = srcvec.compare(dst.getVector(), veccompare);
                double confidence = this.vectorFactory.calculateSignificance(veccompare);
                if (confidence < this.impThreshold) continue;
                FunctionPair newPair = new FunctionPair(src, dst, similarity, confidence);
                src.addAssociate(dst, newPair);
                dst.addAssociate(src, newPair);
            }
        }
    }

    protected boolean fillOutPairs(NeighborhoodPair pair, int maxCompares) {
        ArrayList<FunctionNode> unmatchedSource = new ArrayList<FunctionNode>();
        ArrayList<FunctionNode> unmatchedDest = null;
        for (FunctionNode src : pair.srcNeighbors) {
            if (src.isAcceptedMatch() || src.getVector() == null) continue;
            unmatchedSource.add(src);
        }
        if (unmatchedSource.isEmpty()) {
            return false;
        }
        if (unmatchedSource.size() > maxCompares) {
            return false;
        }
        unmatchedDest = new ArrayList<FunctionNode>();
        for (FunctionNode dst : pair.destNeighbors) {
            if (dst.isAcceptedMatch() || dst.getVector() == null) continue;
            unmatchedDest.add(dst);
        }
        if (unmatchedDest.isEmpty()) {
            return false;
        }
        if (unmatchedSource.size() * unmatchedDest.size() > maxCompares) {
            return false;
        }
        this.searchForNewMatches(unmatchedSource, unmatchedDest);
        return true;
    }

    public static class NeighborhoodPair {
        public Set<FunctionNode> srcNeighbors;
        public Set<FunctionNode> destNeighbors;
        public boolean isFilledOut = false;
    }

    public static class Spouses
    extends NeighborGenerator {
        public Spouses(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            Set<FunctionNode> tempRels = srcRoot.getChildren();
            pair.srcNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.srcNeighbors.addAll(rel.getParents());
            }
            pair.srcNeighbors.remove(srcRoot);
            tempRels = destRoot.getChildren();
            pair.destNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.destNeighbors.addAll(rel.getParents());
            }
            pair.destNeighbors.remove(destRoot);
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }

    public static class Siblings
    extends NeighborGenerator {
        public Siblings(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            Set<FunctionNode> tempRels = srcRoot.getParents();
            pair.srcNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.srcNeighbors.addAll(rel.getChildren());
            }
            pair.srcNeighbors.remove(srcRoot);
            tempRels = destRoot.getParents();
            pair.destNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.destNeighbors.addAll(rel.getChildren());
            }
            pair.destNeighbors.remove(destRoot);
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }

    public static class GrandChildren
    extends NeighborGenerator {
        public GrandChildren(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            Set<FunctionNode> tempRels = srcRoot.getChildren();
            pair.srcNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.srcNeighbors.addAll(rel.getChildren());
            }
            pair.srcNeighbors.remove(srcRoot);
            tempRels = destRoot.getChildren();
            pair.destNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.destNeighbors.addAll(rel.getChildren());
            }
            pair.destNeighbors.remove(destRoot);
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }

    public static class GrandParents
    extends NeighborGenerator {
        public GrandParents(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            Set<FunctionNode> tempRels = srcRoot.getParents();
            pair.srcNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.srcNeighbors.addAll(rel.getParents());
            }
            pair.srcNeighbors.remove(srcRoot);
            tempRels = destRoot.getParents();
            pair.destNeighbors = FunctionNode.neigborhoodAllocate();
            for (FunctionNode rel : tempRels) {
                pair.destNeighbors.addAll(rel.getParents());
            }
            pair.destNeighbors.remove(destRoot);
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }

    public static class Children
    extends NeighborGenerator {
        public Children(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            pair.srcNeighbors = srcRoot.getChildren();
            pair.destNeighbors = destRoot.getChildren();
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }

    public static class Parents
    extends NeighborGenerator {
        public Parents(LSHVectorFactory vectorFactory, double impThreshold) {
            super(vectorFactory, impThreshold);
        }

        @Override
        public NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
            NeighborhoodPair pair = new NeighborhoodPair();
            pair.srcNeighbors = srcRoot.getParents();
            pair.destNeighbors = destRoot.getParents();
            this.fillOutPairs(pair, 25);
            return pair;
        }
    }
}

