/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class CursorBlinker {
    private Timer timer;
    private FieldPanel fieldPanel;
    private Rectangle paintBounds;
    private boolean showCursor;
    private FieldLocation cursor = new FieldLocation();
    private AnchoredLayout layout;
    int layoutYpos = 0;

    public CursorBlinker(FieldPanel panel) {
        this.fieldPanel = panel;
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CursorBlinker.this.paintBounds != null) {
                    CursorBlinker.this.showCursor = !CursorBlinker.this.showCursor;
                    CursorBlinker.this.fieldPanel.paintImmediately(CursorBlinker.this.paintBounds);
                } else {
                    CursorBlinker.this.timer.stop();
                }
            }
        });
        this.timer.setInitialDelay(100);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void restart() {
        this.timer.restart();
    }

    public void dispose() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.timer = null;
        this.fieldPanel = null;
    }

    public void updatePaintArea(AnchoredLayout cursorLayout, FieldLocation cursorPosition) {
        if (cursorLayout != this.layout || this.layout.getYPos() != this.layoutYpos || !this.cursor.equals(cursorPosition)) {
            this.layout = cursorLayout;
            this.cursor.set(cursorPosition);
            this.showCursor = true;
            if (this.layout != null) {
                this.layoutYpos = this.layout.getYPos();
                this.timer.restart();
                this.paintBounds = this.layout.getFieldBounds(cursorPosition.fieldNum);
            } else {
                this.timer.stop();
                this.paintBounds = null;
            }
        }
    }

    public boolean showCursor() {
        return this.showCursor;
    }
}

