/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ReferencedSymbolMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDimensionedArrayVarBoundsUpperMsType
extends AbstractMsType {
    protected long rank;
    protected RecordNumber typeRecordNumber;
    protected List<RecordNumber> upperBound = new ArrayList<RecordNumber>();

    public AbstractDimensionedArrayVarBoundsUpperMsType(AbstractPdb pdb, PdbByteReader reader, int intSize) throws PdbException {
        super(pdb, reader);
        this.rank = reader.parseVarSizedUInt(intSize);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
        int i = 0;
        while ((long)i < this.rank) {
            RecordNumber upperTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
            if (!(pdb.getTypeRecord(upperTypeRecordNumber) instanceof ReferencedSymbolMsType) && upperTypeRecordNumber.getNumber() != 3) {
                throw new PdbException("We are not expecting this--needs investigation");
            }
            this.upperBound.add(upperTypeRecordNumber);
            ++i;
        }
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.pdb.getTypeRecord(this.typeRecordNumber).emit(builder, AbstractMsType.Bind.NONE);
        int i = 0;
        while ((long)i < this.rank) {
            builder.append("[0:");
            builder.append(this.pdb.getTypeRecord(this.upperBound.get(i)));
            builder.append("]");
            ++i;
        }
    }
}

