/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class ModuleTypeReferenceMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4447;
    private boolean doesNotReferenceAnyType;
    private boolean referencesZ7PchTypes;
    private boolean containsZ7PchTypes;
    private boolean containsZ7TypeInformation;
    private boolean containsZiOrZITypeInformation;
    private boolean containsOtherModuleTypeReferences;
    private int typeReferenceStreamNumber = -1;
    private int typeIdStreamNumber = -1;
    private int moduleContainingReferencedPchTypes = -1;
    private int moduleSharingReferencedTypes = -1;

    public ModuleTypeReferenceMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        long flags = reader.parseUnsignedIntVal();
        this.processFlags(flags);
        int val0 = reader.parseUnsignedShortVal();
        int val1 = reader.parseUnsignedShortVal();
        if (this.containsZ7TypeInformation) {
            this.typeReferenceStreamNumber = val0;
            if (this.referencesZ7PchTypes) {
                this.moduleContainingReferencedPchTypes = val1 + 1;
            }
        } else if (!this.doesNotReferenceAnyType) {
            if (this.containsZiOrZITypeInformation) {
                this.typeReferenceStreamNumber = val0;
                this.typeIdStreamNumber = val1;
            }
            if (this.containsOtherModuleTypeReferences) {
                this.moduleSharingReferencedTypes = val0 + 1;
            }
        }
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4447;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: ", this.getSymbolTypeName()));
        if (this.doesNotReferenceAnyType) {
            builder.append("No TypeRef");
        } else if (this.containsZ7TypeInformation) {
            builder.append(String.format("/Z7 TypeRef, StreamNumber=%04X", this.typeReferenceStreamNumber));
            if (this.containsZ7PchTypes) {
                builder.append(", own PCH types");
            }
            if (this.referencesZ7PchTypes) {
                builder.append(String.format(", reference PCH types in Module %04X", this.moduleContainingReferencedPchTypes));
            }
        } else {
            builder.append("/Zi TypeRef");
            if (this.containsZiOrZITypeInformation) {
                builder.append(String.format(", StreamNumber=%04X (type), StreamNumber=%04X (ID)", this.typeReferenceStreamNumber, this.typeIdStreamNumber));
            }
            if (this.containsOtherModuleTypeReferences) {
                builder.append(String.format(", shared with Module %04X", this.moduleSharingReferencedTypes));
            }
        }
        builder.append("\n");
    }

    @Override
    protected String getSymbolTypeName() {
        return "MODTYPEREF";
    }

    private void processFlags(long flags) {
        this.doesNotReferenceAnyType = (flags & 1L) == 1L;
        this.referencesZ7PchTypes = ((flags >>= 1) & 1L) == 1L;
        this.containsZ7PchTypes = ((flags >>= 1) & 1L) == 1L;
        this.containsZ7TypeInformation = ((flags >>= 1) & 1L) == 1L;
        this.containsZiOrZITypeInformation = ((flags >>= 1) & 1L) == 1L;
        this.containsOtherModuleTypeReferences = ((flags >>= 1) & 1L) == 1L;
    }
}

