/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalVariableFlags;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public class FileStaticMsSymbol
extends AbstractMsSymbol
implements NameMsSymbol {
    public static final int PDB_ID = 4435;
    private RecordNumber typeRecordNumber;
    private int moduleFilenameStringTableIndex;
    private LocalVariableFlags localVariableFlags;
    private String name;

    public FileStaticMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.moduleFilenameStringTableIndex = reader.parseInt();
        this.localVariableFlags = new LocalVariableFlags(reader);
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
    }

    @Override
    public int getPdbId() {
        return 4435;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public int getModuleFilenameStringTableIndex() {
        return this.moduleFilenameStringTableIndex;
    }

    public String getModuleFilename() {
        return this.pdb.getNameStringFromOffset(this.moduleFilenameStringTableIndex);
    }

    public LocalVariableFlags getLocalVariableFlags() {
        return this.localVariableFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(String.format("%08X ", this.typeRecordNumber.getNumber()));
        this.localVariableFlags.emit(myBuilder);
        builder.append(String.format("%s: %s, %s", this.getSymbolTypeName(), myBuilder.toString(), this.name));
        builder.append("\n   Mod: ");
        builder.append(this.pdb.getNameStringFromOffset(this.moduleFilenameStringTableIndex));
    }

    @Override
    protected String getSymbolTypeName() {
        return "FILESTATIC";
    }
}

