/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.ProgramContext;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractProgramContext
implements ProgramContext,
DefaultProgramContext {
    protected Language language;
    protected Register baseContextRegister;
    private boolean hasNonFlowingContext = false;
    private byte[] nonFlowingContextRegisterMask;
    private byte[] flowingContextRegisterMask;
    protected RegisterValue defaultDisassemblyContext;

    protected AbstractProgramContext(Language language) {
        this.init(language);
    }

    public Language getLanguage() {
        return this.language;
    }

    private void initContextBitMasks(Register contextReg) {
        block4: {
            byte[] subMask;
            block3: {
                subMask = contextReg.getBaseMask();
                if (contextReg.followsFlow()) break block3;
                this.hasNonFlowingContext = true;
                for (int i = 0; i < this.nonFlowingContextRegisterMask.length; ++i) {
                    int n = i;
                    this.nonFlowingContextRegisterMask[n] = (byte)(this.nonFlowingContextRegisterMask[n] | subMask[i]);
                    int n2 = i;
                    this.flowingContextRegisterMask[n2] = (byte)(this.flowingContextRegisterMask[n2] & ~subMask[i]);
                }
                break block4;
            }
            for (int i = 0; i < this.flowingContextRegisterMask.length; ++i) {
                int n = i;
                this.flowingContextRegisterMask[n] = (byte)(this.flowingContextRegisterMask[n] | subMask[i]);
            }
            if (!contextReg.hasChildren()) break block4;
            for (Register childReg : contextReg.getChildRegisters()) {
                this.initContextBitMasks(childReg);
            }
        }
    }

    @Override
    public final boolean hasNonFlowingContext() {
        return this.hasNonFlowingContext;
    }

    @Override
    public final RegisterValue getFlowValue(RegisterValue value) {
        if (value == null || !this.hasNonFlowingContext || !value.getRegister().isProcessorContext()) {
            return value;
        }
        return value.clearBitValues(this.nonFlowingContextRegisterMask);
    }

    @Override
    public final RegisterValue getNonFlowValue(RegisterValue value) {
        if (value == null || !this.hasNonFlowingContext || !value.getRegister().isProcessorContext()) {
            return null;
        }
        return value.clearBitValues(this.flowingContextRegisterMask);
    }

    protected void init(Language lang) {
        this.language = lang;
        this.baseContextRegister = lang.getContextBaseRegister();
        this.defaultDisassemblyContext = new RegisterValue(this.baseContextRegister);
        this.nonFlowingContextRegisterMask = (byte[])this.baseContextRegister.getBaseMask().clone();
        Arrays.fill(this.nonFlowingContextRegisterMask, (byte)0);
        this.flowingContextRegisterMask = (byte[])this.nonFlowingContextRegisterMask.clone();
        this.initContextBitMasks(this.baseContextRegister);
    }

    @Override
    public final List<Register> getContextRegisters() {
        return this.language.getContextRegisters();
    }

    @Override
    public final Register getRegister(String name) {
        return this.language.getRegister(name);
    }

    @Override
    public final List<String> getRegisterNames() {
        return this.language.getRegisterNames();
    }

    @Override
    public final List<Register> getRegisters() {
        return this.language.getRegisters();
    }

    @Override
    public final Register getBaseContextRegister() {
        return this.baseContextRegister;
    }

    @Override
    public final RegisterValue getDefaultDisassemblyContext() {
        return this.defaultDisassemblyContext;
    }

    @Override
    public final void setDefaultDisassemblyContext(RegisterValue value) {
        this.defaultDisassemblyContext = value;
    }
}

