/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.lang.protorules.PrimitiveExtractor;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class MultiMemberAssign
extends AssignAction {
    private StorageClass resourceType;
    private boolean consumeFromStack;
    private boolean consumeMostSig;

    public MultiMemberAssign(StorageClass store, boolean stack, boolean mostSig, ParamListStandard res) {
        super(res);
        this.resourceType = store;
        this.consumeFromStack = stack;
        this.consumeMostSig = mostSig;
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new MultiMemberAssign(this.resourceType, this.consumeFromStack, this.consumeMostSig, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        MultiMemberAssign otherOp = (MultiMemberAssign)op;
        if (this.resourceType != otherOp.resourceType) {
            return false;
        }
        if (this.consumeFromStack != otherOp.consumeFromStack) {
            return false;
        }
        return this.consumeMostSig == otherOp.consumeMostSig;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int[] tmpStatus = (int[])status.clone();
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        ParameterPieces param = new ParameterPieces();
        PrimitiveExtractor primitives = new PrimitiveExtractor(dt, false, 0, 16);
        if (!primitives.isValid() || primitives.size() == 0 || primitives.containsUnknown() || !primitives.isAligned() || primitives.containsHoles()) {
            return 1;
        }
        for (int i = 0; i < primitives.size(); ++i) {
            DataType curType = primitives.get((int)i).dt;
            if (this.resource.assignAddressFallback(this.resourceType, curType, !this.consumeFromStack, tmpStatus, param) == 1) {
                return 1;
            }
            Varnode vn = new Varnode(param.address, curType.getLength());
            pieces.add(vn);
        }
        System.arraycopy(tmpStatus, 0, status, 0, tmpStatus.length);
        res.type = dt;
        res.assignAddressFromPieces(pieces, this.consumeMostSig, false, this.resource.getLanguage());
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_JOIN_PER_PRIMITIVE);
        if (this.resourceType != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        }
        encoder.closeElement(ElementId.ELEM_JOIN_PER_PRIMITIVE);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_JOIN_PER_PRIMITIVE.name()});
        String attribString = elem.getAttribute(AttributeId.ATTRIB_STORAGE.name());
        if (attribString != null) {
            this.resourceType = StorageClass.getClass(attribString);
        }
        parser.end(elem);
    }
}

