/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.GifDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.MemBufferImageInputStream;
import ghidra.program.model.mem.MemBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GIFResource {
    private MemBufferImageInputStream inputStream;

    public GIFResource(MemBuffer buf) throws InvalidDataTypeException {
        this.inputStream = new MemBufferImageInputStream(buf, ByteOrder.LITTLE_ENDIAN);
        try {
            this.readHeader();
            this.skipContents();
        }
        catch (IOException e) {
            throw new InvalidDataTypeException("Invalid GIF Data");
        }
    }

    private void readHeader() throws IOException, InvalidDataTypeException {
        byte[] bytes = new byte[6];
        this.inputStream.read(bytes);
        if (!Arrays.equals(bytes, GifDataType.MAGIC_87) && !Arrays.equals(bytes, GifDataType.MAGIC_89)) {
            throw new InvalidDataTypeException("Invalid GIF Data");
        }
        this.inputStream.readShort();
        this.inputStream.readShort();
        int flags = this.inputStream.read();
        boolean globalColorTableFlag = (flags & 0x80) != 0;
        int globalColorTableSize = 2 << (flags & 7);
        this.inputStream.read();
        this.inputStream.read();
        if (globalColorTableFlag) {
            this.inputStream.skipBytes(3 * globalColorTableSize);
        }
    }

    private void skipContents() throws IOException, InvalidDataTypeException {
        int controlByte = this.inputStream.read();
        while (controlByte != 59) {
            if (controlByte == 44) {
                this.skipImage();
            } else if (controlByte == 33) {
                this.skipExtension();
            } else {
                throw new InvalidDataTypeException("Invalid GIF Data");
            }
            controlByte = this.inputStream.read();
        }
    }

    private void skipExtension() throws IOException {
        this.inputStream.read();
        this.skipDataBlocks();
    }

    private void skipDataBlocks() throws IOException {
        int blockSize = this.inputStream.read();
        while (blockSize > 0) {
            this.inputStream.skipBytes(blockSize);
            blockSize = this.inputStream.read();
        }
    }

    private void skipImage() throws IOException {
        this.inputStream.skipBytes(8);
        int flags = this.inputStream.read();
        boolean localColorTableFlag = (flags & 0x80) != 0;
        int localColorTableSize = 2 << (flags & 7);
        if (localColorTableFlag) {
            this.inputStream.skipBytes(3 * localColorTableSize);
        }
        this.inputStream.read();
        this.skipDataBlocks();
    }

    public int getLength() {
        return this.inputStream.getConsumedLength();
    }
}

