/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.SequenceNumber;

public class SequenceRange {
    private final SequenceNumber start;
    private final SequenceNumber end;

    public SequenceRange(SequenceNumber start, SequenceNumber end) {
        this.start = start;
        this.end = end;
    }

    public SequenceNumber getStart() {
        return this.start;
    }

    public SequenceNumber getEnd() {
        return this.end;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceRange)) {
            return false;
        }
        SequenceRange range = (SequenceRange)obj;
        return this.start.equals((Object)range.start) && this.end.equals((Object)range.end);
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public String toString() {
        return String.valueOf(this.start) + "-" + String.valueOf(this.end);
    }

    public boolean contains(SequenceNumber seq) {
        Address addr = seq.getTarget();
        int index = seq.getTime();
        Address startAddr = this.start.getTarget();
        int startIndex = this.start.getTime();
        Address endAddr = this.end.getTarget();
        int endIndex = this.end.getTime();
        int c = addr.compareTo((Object)startAddr);
        if (c == 0) {
            c = index - startIndex;
        }
        if (c < 0) {
            return false;
        }
        c = addr.compareTo((Object)endAddr);
        if (c == 0) {
            c = index - endIndex;
        }
        return c <= 0;
    }
}

