/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.util.Arrays;

public class GUID {
    public static final int SIZEOF = 16;
    private int data1;
    private short data2;
    private short data3;
    private byte[] data4 = new byte[8];

    public GUID(String guidString) throws IllegalArgumentException {
        String[] parts = this.getGUIDParts(guidString);
        this.data1 = (int)NumericUtilities.parseHexLong((String)parts[0]);
        this.data2 = (short)Integer.parseInt(parts[1], 16);
        this.data3 = (short)Integer.parseInt(parts[2], 16);
        int value = Integer.parseInt(parts[3], 16);
        this.data4[0] = (byte)(value >> 8);
        this.data4[1] = (byte)(value & 0xFF);
        this.data4[2] = (byte)Integer.parseInt(parts[4].substring(0, 2), 16);
        this.data4[3] = (byte)Integer.parseInt(parts[4].substring(2, 4), 16);
        this.data4[4] = (byte)Integer.parseInt(parts[4].substring(4, 6), 16);
        this.data4[5] = (byte)Integer.parseInt(parts[4].substring(6, 8), 16);
        this.data4[6] = (byte)Integer.parseInt(parts[4].substring(8, 10), 16);
        this.data4[7] = (byte)Integer.parseInt(parts[4].substring(10, 12), 16);
    }

    private String[] getGUIDParts(String guidString) throws IllegalArgumentException {
        String[] results = new String[5];
        String string = guidString = guidString.startsWith("{") && guidString.endsWith("}") ? guidString.substring(1, guidString.length() - 1) : guidString;
        if (guidString.length() == 36 && guidString.charAt(8) == '-' && guidString.charAt(13) == '-' && guidString.charAt(18) == '-' && guidString.charAt(23) == '-') {
            results[0] = guidString.substring(0, 8);
            results[1] = guidString.substring(9, 13);
            results[2] = guidString.substring(14, 18);
            results[3] = guidString.substring(19, 23);
            results[4] = guidString.substring(24);
        } else if (guidString.length() == 32) {
            results[0] = guidString.substring(0, 8);
            results[1] = guidString.substring(8, 12);
            results[2] = guidString.substring(12, 16);
            results[3] = guidString.substring(16, 20);
            results[4] = guidString.substring(20);
        } else {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        return results;
    }

    public GUID(int data1, short data2, short data3, byte[] data4) {
        this.data1 = data1;
        this.data2 = data2;
        this.data3 = data3;
        this.data4 = data4;
    }

    public GUID(BinaryReader reader) throws IOException {
        this.data1 = reader.readNextInt();
        this.data2 = reader.readNextShort();
        this.data3 = reader.readNextShort();
        this.data4 = reader.readNextByteArray(8);
    }

    public GUID(MemBuffer buf) throws MemoryAccessException {
        int i;
        byte[] data1bytes = new byte[4];
        byte[] data2bytes = new byte[2];
        byte[] data3bytes = new byte[2];
        byte[] data4bytes = new byte[8];
        int offset = 0;
        for (i = 0; i < data1bytes.length; ++i) {
            data1bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data2bytes.length; ++i) {
            data2bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data3bytes.length; ++i) {
            data3bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data4bytes.length; ++i) {
            data4bytes[i] = buf.getByte(offset++);
        }
        DataConverter dc = this.getDataConverter(buf);
        this.data1 = dc.getInt(data1bytes);
        this.data2 = dc.getShort(data2bytes);
        this.data3 = dc.getShort(data3bytes);
        this.data4 = data4bytes;
    }

    private DataConverter getDataConverter(MemBuffer buf) {
        return DataConverter.getInstance((boolean)buf.isBigEndian());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Conv.toHexString((int)this.data1));
        sb.append("-");
        sb.append(Conv.toHexString((short)this.data2));
        sb.append("-");
        sb.append(Conv.toHexString((short)this.data3));
        sb.append("-");
        sb.append(Conv.toHexString((byte)this.data4[0]));
        sb.append(Conv.toHexString((byte)this.data4[1]));
        sb.append("-");
        sb.append(Conv.toHexString((byte)this.data4[2]));
        sb.append(Conv.toHexString((byte)this.data4[3]));
        sb.append(Conv.toHexString((byte)this.data4[4]));
        sb.append(Conv.toHexString((byte)this.data4[5]));
        sb.append(Conv.toHexString((byte)this.data4[6]));
        sb.append(Conv.toHexString((byte)this.data4[7]));
        return sb.toString();
    }

    public int getData1() {
        return this.data1;
    }

    public short getData2() {
        return this.data2;
    }

    public short getData3() {
        return this.data3;
    }

    public byte[] getData4() {
        return this.data4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data1;
        result = 31 * result + this.data2;
        result = 31 * result + this.data3;
        result = 31 * result + Arrays.hashCode(this.data4);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GUID other = (GUID)obj;
        if (this.data1 != other.data1) {
            return false;
        }
        if (this.data2 != other.data2) {
            return false;
        }
        if (this.data3 != other.data3) {
            return false;
        }
        return Arrays.equals(this.data4, other.data4);
    }
}

