/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

public class UnixAoutSymbol {
    public long nameStringOffset;
    public String name;
    public SymbolType type;
    public SymbolKind kind;
    public byte otherByte;
    public short desc;
    public long value;
    public boolean isExt;

    public UnixAoutSymbol(long nameStringOffset, byte typeByte, byte otherByte, short desc, long value) {
        this.nameStringOffset = nameStringOffset;
        this.otherByte = otherByte;
        this.desc = desc;
        this.value = value;
        this.isExt = (typeByte & 1) == 1;
        this.type = switch (typeByte & 0xFE) {
            case 0 -> SymbolType.N_UNDF;
            case 2 -> SymbolType.N_ABS;
            case 4 -> SymbolType.N_TEXT;
            case 6 -> SymbolType.N_DATA;
            case 8 -> SymbolType.N_BSS;
            case 10 -> SymbolType.N_INDR;
            default -> (typeByte & 0xFE) >= 32 ? SymbolType.N_STAB : SymbolType.UNKNOWN;
        };
        this.kind = switch (otherByte & 0xF) {
            case 1 -> SymbolKind.AUX_OBJECT;
            case 2 -> SymbolKind.AUX_FUNC;
            case 3 -> SymbolKind.AUX_LABEL;
            default -> SymbolKind.UNKNOWN;
        };
    }

    public static enum SymbolType {
        N_UNDF,
        N_ABS,
        N_TEXT,
        N_DATA,
        N_BSS,
        N_INDR,
        N_FN,
        N_STAB,
        UNKNOWN;

    }

    public static enum SymbolKind {
        AUX_FUNC,
        AUX_OBJECT,
        AUX_LABEL,
        UNKNOWN;

    }
}

