/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SecurityCertificate
implements StructConverter {
    public static final String NAME = "WIN_CERTIFICATE";
    public static final int WIN_CERT_REVISION_1_0 = 256;
    public static final int WIN_CERT_REVISION_2_0 = 512;
    public static final int WIN_CERT_TYPE_X509 = 1;
    public static final int WIN_CERT_TYPE_PKCS_SIGNED_DATA = 2;
    public static final int WIN_CERT_TYPE_RESERVED_1 = 3;
    public static final int WIN_CERT_TYPE_PKCS1_SIGN = 9;
    private int dwLength;
    private short wRevision;
    private short wCertificateType;
    private byte[] bCertificate;

    static SecurityCertificate read(BinaryReader reader, long index, int sizeLimit) throws IOException {
        if (sizeLimit < 8) {
            return null;
        }
        reader = reader.clone(index);
        SecurityCertificate result = new SecurityCertificate();
        result.dwLength = reader.readNextInt();
        result.wRevision = reader.readNextShort();
        result.wCertificateType = reader.readNextShort();
        if (result.dwLength < 8 || sizeLimit < result.dwLength) {
            return null;
        }
        int certByteCount = result.dwLength - 4 - 2 - 2;
        result.bCertificate = reader.readNextByteArray(certByteCount);
        return result;
    }

    int getNumberOfBytesConsumed() {
        return (int)NumericUtilities.getUnsignedAlignedValue((long)this.dwLength, (long)8L);
    }

    public int getLength() {
        return this.dwLength;
    }

    public int getRevision() {
        return this.wRevision;
    }

    public int getType() {
        return this.wCertificateType;
    }

    public String getTypeAsString() {
        switch (this.wCertificateType) {
            case 1: {
                return "X.509";
            }
            case 2: {
                return "PKCS Signed";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Unknown Certificate Type";
    }

    public byte[] getData() {
        return this.bCertificate;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType("WIN_CERTIFICATE_" + this.dwLength, 0);
        struct.add(DWORD, "dwLength", null);
        struct.add(WORD, "wRevision", null);
        struct.add(WORD, "wCertificateType", this.getTypeAsString());
        if (this.bCertificate != null && this.bCertificate.length > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, this.bCertificate.length, 1);
            struct.add((DataType)array, "bCertificate", null);
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

