/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldExportsTrieCommand
extends LinkEditDataCommand {
    private ExportTrie exportTrie;

    DyldExportsTrieCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        this.exportTrie = this.dataoff > 0L && this.datasize > 0L ? new ExportTrie(dataReader) : new ExportTrie();
    }

    public ExportTrie getExportTrie() {
        return this.exportTrie;
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        try {
            for (long offset : this.exportTrie.getUlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : this.exportTrie.getStringOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldExportsTrieCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }
}

