/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ElfStringTable
implements ElfFileSection {
    private final ElfHeader header;
    private final ElfSectionHeader stringTableSection;
    private final long fileOffset;
    private final long addrOffset;
    private final long length;

    public ElfStringTable(ElfHeader header, ElfSectionHeader stringTableSection, long fileOffset, long addrOffset, long length) {
        this.header = header;
        this.stringTableSection = stringTableSection;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        this.length = length;
    }

    public String readString(BinaryReader reader, long stringOffset) {
        if (this.fileOffset < 0L) {
            return null;
        }
        try {
            if (stringOffset >= this.length) {
                throw new IOException("String read beyond table bounds");
            }
            return reader.readUtf8String(this.fileOffset + stringOffset).trim();
        }
        catch (IOException e) {
            this.header.logError("Failed to read Elf String at offset 0x" + Long.toHexString(stringOffset) + " within String Table at offset 0x" + Long.toHexString(this.fileOffset));
            return null;
        }
    }

    @Override
    public long getAddressOffset() {
        return this.header.adjustAddressForPrelink(this.addrOffset);
    }

    public ElfSectionHeader getTableSectionHeader() {
        return this.stringTableSection;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public int getEntrySize() {
        return -1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return null;
    }
}

