/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.File;
import java.io.IOException;

public class MemBufferByteProvider
implements ByteProvider {
    private MemBuffer buffer;

    public MemBufferByteProvider(MemBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }

    @Override
    public long length() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isValidIndex(long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            return false;
        }
        try {
            this.buffer.getByte((int)index);
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte readByte(long index) throws IOException {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new IOException("index out of range");
        }
        try {
            return this.buffer.getByte((int)index);
        }
        catch (MemoryAccessException e) {
            throw new IOException("index out of range");
        }
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        if (index < 0L || index + length - 1L > Integer.MAX_VALUE) {
            throw new IOException("index/length of range");
        }
        int len = (int)length;
        byte[] bytes = new byte[len];
        if (this.buffer.getBytes(bytes, (int)index) != len) {
            throw new IOException("index/length of range");
        }
        return bytes;
    }
}

