/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.analysis.FindReferencesTableModel;
import ghidra.app.util.query.AddressAlignmentListener;
import ghidra.framework.plugintool.Plugin;

public class UpdateAlignmentAction
extends ToggleDockingAction
implements AddressAlignmentListener {
    Plugin plugin;
    int alignment;
    FindReferencesTableModel model;

    public UpdateAlignmentAction(Plugin plugin, FindReferencesTableModel model, int alignment) {
        super("UpdateAlignmentAction" + Integer.toString(alignment), plugin.getName());
        this.plugin = plugin;
        this.alignment = alignment;
        this.model = model;
        String[] menuPath = new String[]{"Alignment", Integer.toString(alignment)};
        this.setPopupMenuData(new MenuData(menuPath));
        this.setMenuBarData(new MenuData(menuPath));
        this.setEnabled(true);
        this.setSelected(model.getAlignment() == alignment);
        model.addAlignmentListener(this);
    }

    public void dispose() {
        this.model.removeAlignmentListener(this);
        super.dispose();
    }

    public void actionPerformed(ActionContext context) {
        int currentAlignment = this.model.getAlignment();
        if (currentAlignment != this.alignment) {
            this.model.setAlignment(this.alignment);
        }
    }

    @Override
    public void alignmentChanged() {
        this.setSelected(this.model.getAlignment() == this.alignment);
    }

    @Override
    public void alignmentPermissionChanged() {
        this.setSelected(this.model.getAlignment() == this.alignment);
    }
}

