/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.freeplane.n3.nanoxml.XMLElement;

public class XMLWriter {
    private PrintWriter writer;
    private boolean inContent = false;

    public XMLWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xml) throws IOException {
        this.write(xml, false, 0, true);
    }

    public void write(XMLElement xml, boolean prettyPrint) throws IOException {
        this.write(xml, prettyPrint, 0, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int indent) throws IOException {
        this.write(xml, prettyPrint, indent, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int indent, boolean collapseEmptyElements) throws IOException {
        if (prettyPrint) {
            for (int i = 0; i < indent; ++i) {
                this.writer.print(' ');
            }
        }
        if (xml.getName() == null) {
            if (xml.getContent() != null) {
                if (prettyPrint) {
                    this.writeEncodedContent(xml.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncodedContent(xml.getContent());
                }
            }
        } else {
            String key;
            this.writer.print('<');
            this.writer.print(xml.getFullName());
            Vector<String> nsprefixes = new Vector<String>();
            if (xml.getNamespace() != null) {
                if (xml.getName().equals(xml.getFullName())) {
                    this.writer.print(" xmlns=\"" + xml.getNamespace() + '\"');
                } else {
                    String prefix = xml.getFullName();
                    prefix = prefix.substring(0, prefix.indexOf(58));
                    nsprefixes.addElement(prefix);
                    this.writer.print(" xmlns:" + prefix);
                    this.writer.print("=\"" + xml.getNamespace() + "\"");
                }
            }
            Enumeration<String> enumAttributeNames = xml.enumerateAttributeNames();
            while (enumAttributeNames.hasMoreElements()) {
                String prefix;
                String namespace;
                key = enumAttributeNames.nextElement();
                int index = key.indexOf(58);
                if (index < 0 || (namespace = xml.getAttributeNamespace(key)) == null || nsprefixes.contains(prefix = key.substring(0, index))) continue;
                this.writer.print(" xmlns:" + prefix);
                this.writer.print("=\"" + namespace + '\"');
                nsprefixes.addElement(prefix);
            }
            enumAttributeNames = xml.enumerateAttributeNames();
            while (enumAttributeNames.hasMoreElements()) {
                key = enumAttributeNames.nextElement();
                String value = xml.getAttribute(key, null);
                this.writer.print(" " + key + "=\"");
                this.writeEncoded(value);
                this.writer.print('\"');
            }
            if (xml.getContent() != null && xml.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncodedContent(xml.getContent());
                this.writer.print("</" + xml.getFullName() + '>');
                if (prettyPrint) {
                    this.writer.println();
                }
            } else if (xml.hasChildren() || !collapseEmptyElements) {
                this.writer.print('>');
                if (prettyPrint) {
                    this.writer.println();
                }
                Enumeration<XMLElement> children = xml.enumerateChildren();
                while (children.hasMoreElements()) {
                    XMLElement child = children.nextElement();
                    this.write(child, prettyPrint, indent + 4, collapseEmptyElements);
                }
                if (prettyPrint) {
                    for (int i = 0; i < indent; ++i) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + xml.getFullName() + ">");
                if (prettyPrint) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (prettyPrint) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    public void addRawContent(String comment) {
        this.writer.write(comment);
    }

    protected void writeEncoded(String str) {
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (this.inContent) {
                        this.writer.print(c);
                        continue block8;
                    }
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }

    protected void writeEncodedContent(String str) {
        this.inContent = true;
        this.writeEncoded(str);
        this.inContent = false;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }
}

