/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.IconSelectionPopupDialog;
import org.freeplane.features.icon.MindIcon;

public class IconProperty
extends PropertyBean
implements ActionListener {
    private MindIcon mActualIcon;
    private final JButton mButton;
    private final List<MindIcon> mIcons;

    public IconProperty(String name, List<MindIcon> icons) {
        super(name);
        this.mIcons = icons;
        this.mButton = new JButton();
        this.mButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<MindIcon> icons = new ArrayList<MindIcon>();
        ArrayList<String> descriptions = new ArrayList<String>();
        for (MindIcon icon : this.mIcons) {
            icons.add(icon);
            descriptions.add(icon.getTranslatedDescription());
        }
        IconSelectionPopupDialog dialog = new IconSelectionPopupDialog(JOptionPane.getFrameForComponent((Component)e.getSource()), icons);
        dialog.setLocationRelativeTo(JOptionPane.getFrameForComponent((Component)e.getSource()));
        dialog.setModal(true);
        dialog.setVisible(true);
        int result = dialog.getIconIndex();
        if (result >= 0) {
            MindIcon icon = this.mIcons.get(result);
            this.setValue(icon.getName());
            this.firePropertyChangeEvent();
        }
    }

    @Override
    public String getValue() {
        return this.mActualIcon.getName();
    }

    @Override
    public JComponent getValueComponent() {
        return this.mButton;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.mButton);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    private void setIcon(MindIcon actualIcon) {
        this.mButton.setIcon(actualIcon.getIcon());
        this.mButton.setToolTipText(actualIcon.getTranslatedDescription());
    }

    @Override
    public void setValue(String value) {
        for (MindIcon icon : this.mIcons) {
            if (!icon.getName().equals(value)) continue;
            this.mActualIcon = icon;
            this.setIcon(this.mActualIcon);
            return;
        }
        throw new NoSuchElementException();
    }

    public MindIcon getIcon() {
        return this.mActualIcon;
    }
}

