/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode;

import javax.swing.SwingUtilities;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class NodeNavigator {
    private final NodeModel node;

    public NodeNavigator(NodeModel node) {
        this.node = node;
    }

    public NodeModel getNode() {
        return this.node;
    }

    public void open(boolean openAsRoot) {
        NodeModel nodeToSelect;
        Controller controller = Controller.getCurrentController();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        IMapSelection mapSelection = controller.getSelection();
        if (openAsRoot) {
            MapBookmarks mapBookmarks = (MapBookmarks)mapSelection.getMap().getExtension(MapBookmarks.class);
            NodeModel previouslySelectedNode = mapBookmarks.getSelectedNodeForRoot(this.node);
            if (mapSelection.getSelectionRoot() != this.node) {
                mapViewManager.setViewRoot(this.node);
                nodeToSelect = previouslySelectedNode;
            } else {
                nodeToSelect = this.node;
            }
        } else {
            nodeToSelect = this.node;
        }
        if (openAsRoot || !NodeVisibility.isHidden((NodeModel)nodeToSelect)) {
            Filter filter;
            if (mapSelection.getSelectionRoot() != nodeToSelect && !nodeToSelect.isDescendantOf(mapSelection.getSelectionRoot())) {
                mapViewManager.setViewRoot(this.node.getMap().getRootNode());
            }
            if (!nodeToSelect.isVisible(filter = mapSelection.getFilter())) {
                FilterController.getController((Controller)controller).applyNoFiltering(this.node.getMap());
            }
            controller.getModeController().getMapController().displayNode(nodeToSelect);
            if (nodeToSelect.isRoot()) {
                mapSelection.selectRoot();
            } else {
                mapSelection.selectAsTheOnlyOneSelected(nodeToSelect);
                mapSelection.scrollNodeTreeToVisible(nodeToSelect, false);
            }
        }
    }

    public void openAsNewView() {
        Controller controller = Controller.getCurrentController();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        mapViewManager.newMapView(this.node.getMap(), controller.getModeController());
        SwingUtilities.invokeLater(() -> this.open(true));
    }
}

