/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.project;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.SimpleNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseBrowserView;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;

public class FileSystemExplorerView
extends DatabaseBrowserView {
    private static final Log log = Log.getLog(FileSystemExplorerView.class);
    public static final SimpleDateFormat FILE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final NumberFormat FILE_SIZE_FORMAT = new DecimalFormat();
    private ViewerColumnController<?, ?> columnController;

    public static DBNFileSystems getFileSystemsNode() {
        DBNProject projectNode = FileSystemExplorerView.getGlobalNavigatorModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        if (projectNode != null) {
            return (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class);
        }
        return null;
    }

    @Override
    protected INavigatorFilter getNavigatorFilter() {
        return new SimpleNavigatorTreeFilter();
    }

    @Override
    public DBNNode getRootNode() {
        return super.getRootNode();
    }

    @Override
    protected DBNNode getDefaultRootNode() {
        DBNFileSystems fsRootNode = FileSystemExplorerView.getFileSystemsNode();
        return fsRootNode == null ? new DBNEmptyNode() : fsRootNode;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.addFilter(new ViewerFilter(this){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProjectDatabases);
            }
        });
        viewer.getTree().setHeaderVisible(true);
        UIExecutionQueue.queueExec(() -> this.createColumns(viewer));
    }

    @Override
    @NotNull
    protected DatabaseNavigatorTreeFilterObjectType getDefaultFilterType() {
        return DatabaseNavigatorTreeFilterObjectType.file;
    }

    @Override
    protected void installDragAndDropSupport(DatabaseNavigatorTree navigatorTree) {
        super.installDragAndDropSupport(navigatorTree);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected void createColumns(TreeViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("cloudFileExplorer", (ColumnViewer)viewer);
        this.columnController.setForceAutoSize(true);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_name_text, UINavigatorMessages.navigator_project_explorer_columns_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(this){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    IToolTipProvider toolTipProvider = (IToolTipProvider)mainLabelProvider;
                    return toolTipProvider.getToolTipText(element);
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_size_text, UINavigatorMessages.navigator_project_explorer_columns_size_description, 131072, false, false, true, null, (CellLabelProvider)new ColumnLabelProvider(this){

            public String getText(Object element) {
                DBNPath dbnPath;
                if (element instanceof DBNPath && !(dbnPath = (DBNPath)element).isDirectory()) {
                    Path path = dbnPath.getPath();
                    try {
                        return FILE_SIZE_FORMAT.format(Files.size(path));
                    }
                    catch (IOException e) {
                        log.debug((Object)e);
                    }
                }
                return "";
            }
        }, null);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_modified_text, UINavigatorMessages.navigator_project_explorer_columns_modified_description, 131072, false, false, (CellLabelProvider)new ColumnLabelProvider(this){

            public String getText(Object element) {
                DBNPath pathNode;
                Path path;
                if (element instanceof DBNPath && (path = (pathNode = (DBNPath)element).getPath()) != null && !pathNode.isDirectory()) {
                    try {
                        FileTime lastModified = Files.getLastModifiedTime(path, new LinkOption[0]);
                        return FILE_TIMESTAMP_FORMAT.format(lastModified.toMillis());
                    }
                    catch (IOException e) {
                        log.debug((Object)e);
                    }
                }
                return "";
            }
        });
        this.createExtraColumns(this.columnController, viewer);
        var closure = new Object(this){
            public Runnable createColumnsWhenNotBusy;
        };
        closure.createColumnsWhenNotBusy = () -> {
            if (viewer.isBusy()) {
                UIUtils.asyncExec((Runnable)closure.createColumnsWhenNotBusy);
            } else {
                this.columnController.createColumns(true);
            }
        };
        UIUtils.asyncExec((Runnable)closure.createColumnsWhenNotBusy);
    }

    protected void createExtraColumns(ViewerColumnController<?, ?> columnController, TreeViewer viewer) {
    }
}

