/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth.code;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import java.awt.Desktop;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.oauth.IOAuthHandler;
import org.jkiss.utils.oauth.code.IOAuthCodeResponseHandler;
import org.jkiss.utils.oauth.code.OAuthCodeResponseHandler;
import org.jkiss.utils.oauth.code.OAuthRequestURLBuilder;

public class OAuthCodeHandler
implements IOAuthHandler {
    protected static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();
    public static final int TOKEN_VERIFIER_BYTE_LENGTH = 64;
    private static final String GRANT_TYPE = "grant_type";
    @NotNull
    protected final String clientId;
    @Nullable
    protected final String secretId;
    @NotNull
    protected final String authUrl;
    @NotNull
    protected final String tokenURL;
    @NotNull
    protected final String redirectUri;
    protected final int callbackPort;
    @NotNull
    protected final String callbackEndpoint;
    protected int timeout;
    @Nullable
    protected String state;
    @Nullable
    protected String codeChallenge;

    public OAuthCodeHandler(@NotNull String clientId, @Nullable String secretId, @NotNull String authUrl, @NotNull String tokenURL, @NotNull String callbackEndpoint, @NotNull String redirectUri, int callbackPort) {
        this.clientId = clientId;
        this.secretId = secretId;
        this.authUrl = authUrl;
        this.tokenURL = tokenURL;
        this.callbackEndpoint = callbackEndpoint;
        this.callbackPort = callbackPort;
        this.redirectUri = redirectUri;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Override
    public Map<String, String> authorize() throws IOException {
        Map<String, String> map;
        block9: {
            IOAuthCodeResponseHandler handler = this.createCodeResponseHandler();
            try {
                String verifier = this.generateCodeChallengeAndVerifier();
                this.startSSO(handler);
                String code = handler.requestCode().get(this.timeout, TimeUnit.SECONDS);
                HttpRequest.Builder postBuilder = HttpRequest.newBuilder().uri(URI.create(this.tokenURL));
                postBuilder.headers(this.getHeaderParameters());
                postBuilder.POST(HttpRequest.BodyPublishers.ofString(this.createTokenRequestParameters(code, verifier)));
                postBuilder.timeout(Duration.ofSeconds(this.timeout));
                HttpRequest postRequest = postBuilder.build();
                handler.addStabContext();
                HttpClient client = HttpClient.newBuilder().cookieHandler(new CookieManager()).version(HttpClient.Version.HTTP_2).build();
                HttpResponse<String> response = client.send(postRequest, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new IOException("Error getting token info " + response.body());
                }
                map = this.extractResponse(response);
                if (handler == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new IOException(e);
                }
            }
            handler.close();
        }
        return map;
    }

    @NotNull
    protected String[] getHeaderParameters() {
        return new String[]{"Content-Type", "application/x-www-form-urlencoded"};
    }

    @NotNull
    protected IOAuthCodeResponseHandler createCodeResponseHandler() {
        return new OAuthCodeResponseHandler(this.callbackPort, this.callbackEndpoint);
    }

    @NotNull
    protected Map<String, String> extractResponse(HttpResponse<String> response) throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String idToken = jsonObject.get("id_token").getAsString();
        if (idToken != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("token", idToken);
            return result;
        }
        throw new IOException("Error extracting token");
    }

    protected void startSSO(@NotNull IOAuthCodeResponseHandler handler) throws IOException {
        handler.initServer();
        this.createBrowser(this.buildAuthUrl());
    }

    protected void createBrowser(@NotNull String url) throws IOException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new IOException("Desktop BROWSER interface is not supported");
        }
        Desktop.getDesktop().browse(URI.create(url));
    }

    @NotNull
    private String generateCodeChallengeAndVerifier() throws IOException {
        String codeVerifier = OAuthCodeHandler.generateVerifier();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] shaEncode = digest.digest(codeVerifier.getBytes());
            this.codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(shaEncode);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Missing SHA-256 algorithm");
        }
        return codeVerifier;
    }

    @NotNull
    private static String generateVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] secureValue = new byte[64];
        secureRandom.nextBytes(secureValue);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(secureValue);
    }

    @NotNull
    private String createTokenRequestParameters(@NotNull String code, @NotNull String verifier) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(GRANT_TYPE, "authorization_code");
        parameters.put("code", code);
        parameters.put("client_id", this.clientId);
        if (CommonUtils.isNotEmpty(this.secretId)) {
            parameters.put("client_secret", this.secretId);
        }
        parameters.put("code_verifier", verifier);
        parameters.put("redirect_uri", this.getRedirectUri());
        return OAuthRequestURLBuilder.buildURLParameters(parameters);
    }

    protected String buildAuthUrl() throws IOException {
        OAuthRequestURLBuilder builder = new OAuthRequestURLBuilder(this.authUrl).withClientId(this.clientId).withRedirectURI(this.redirectUri);
        if (this.codeChallenge != null) {
            builder.withCodeChallenge(this.codeChallenge);
        }
        return builder.build();
    }

    @NotNull
    protected String getRedirectUri() {
        return this.redirectUri;
    }

    @NotNull
    public static OAuthCodeHandlerBuilder<?> builder() {
        return new OAuthCodeHandlerBuilder();
    }

    public static class OAuthCodeHandlerBuilder<T extends OAuthCodeHandler> {
        protected String clientId;
        protected String secretId;
        protected String authUrl;
        protected String tokenURL;
        protected String redirectUri;
        protected int callbackPort = 0;
        protected int timeout = 120;
        protected String callbackEndpoint = "/callback";
        protected String state;

        public OAuthCodeHandlerBuilder<T> withClientId(@NotNull String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withSecretId(@Nullable String secretId) {
            this.secretId = secretId;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withAuthUrl(@NotNull String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withTokenUrl(@NotNull String tokenURL) {
            this.tokenURL = tokenURL;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withCallbackPort(int port) {
            this.callbackPort = port;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withTimeout(int seconds) {
            this.timeout = seconds;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withCallbackEndpoint(@NotNull String endpoint) {
            this.callbackEndpoint = endpoint;
            return this;
        }

        public OAuthCodeHandlerBuilder<T> withRedirectUri(@NotNull String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @NotNull
        public T build() {
            if (CommonUtils.isEmpty(this.clientId)) {
                throw new IllegalStateException("clientId is required");
            }
            if (CommonUtils.isEmpty(this.authUrl)) {
                throw new IllegalStateException("authUrl is required");
            }
            if (CommonUtils.isEmpty(this.tokenURL)) {
                throw new IllegalStateException("tokenURL is required");
            }
            if (CommonUtils.isEmpty(this.redirectUri)) {
                this.redirectUri = String.format("http://localhost:%s%s", this.callbackPort, this.callbackEndpoint);
            }
            T handler = this.createOAuthCodeHandler();
            if (this.timeout > 0) {
                ((OAuthCodeHandler)handler).setTimeout(this.timeout);
            }
            return handler;
        }

        @NotNull
        protected T createOAuthCodeHandler() {
            return (T)new OAuthCodeHandler(this.clientId, this.secretId, this.authUrl, this.tokenURL, this.callbackEndpoint, this.redirectUri, this.callbackPort);
        }
    }
}

