/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.transformers.SQLQueryTransformerCount;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IQueryExecuteController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainerExt;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetValueReflector;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.sql.QueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

abstract class QueryResultsContainer
implements DBSDataContainer,
IResultSetContainer,
IResultSetValueReflector,
IResultSetListener,
IResultSetContainerExt,
SQLQueryContainer,
ISmartTransactionManager,
IQueryExecuteController,
SQLEditor.QueryProcessingComponent {
    protected final QueryProcessor queryProcessor;
    protected final ResultSetViewer viewer;
    protected int resultSetNumber;
    protected final int resultSetIndex;
    protected final boolean singleQuery;
    private SQLScriptElement query = null;
    private SQLScriptElement lastGoodQuery = null;
    private DBSDataContainer dataContainer;
    private String tabName;
    protected boolean detached;

    protected QueryResultsContainer(@NotNull Composite resultSetViewerContainer, @NotNull QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean singleQuery, boolean makeDefault) {
        this.queryProcessor = queryProcessor;
        this.resultSetNumber = resultSetNumber;
        this.resultSetIndex = resultSetIndex;
        this.singleQuery = singleQuery;
        SQLEditor owner = queryProcessor.getOwner();
        this.viewer = new ResultSetViewer(resultSetViewerContainer, owner.getSite(), (IResultSetContainer)this);
        this.viewer.addListener((IResultSetListener)this);
        this.viewer.getControl().addDisposeListener(e -> this.queryProcessor.removeResults(this));
    }

    protected abstract void dispose();

    QueryResultsContainer(@NotNull Composite resultSetViewerContainer, @NotNull QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer, boolean singleQuery) {
        this(resultSetViewerContainer, queryProcessor, resultSetNumber, resultSetIndex, singleQuery, false);
        this.dataContainer = dataContainer;
        this.updateResultsName(queryProcessor.getOwner().getResultsTabName(resultSetNumber, 0, dataContainer.getName()), null);
    }

    SQLEditor getOwner() {
        return this.queryProcessor.getOwner();
    }

    QueryProcessor getQueryProcessor() {
        return this.queryProcessor;
    }

    void setLastGoodQuery(SQLScriptElement lastGoodQuery) {
        this.lastGoodQuery = lastGoodQuery;
    }

    public void detach() {
        try {
            this.detached = true;
            this.getOwner().getSite().getPage().openEditor((IEditorInput)new SQLResultsEditorInput(this), SQLResultsEditor.class.getName(), true, 0);
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Detached results", "Can't open results view", e);
            this.detached = false;
        }
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getResultSetIndex() {
        return this.resultSetIndex;
    }

    public int getQueryIndex() {
        return this.getOwner().queryProcessors.indexOf(this.queryProcessor);
    }

    abstract void updateResultsName(String var1, String var2);

    @Nullable
    public DBPProject getProject() {
        return this.getOwner().getProject();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.getOwner().getExecutionContext();
    }

    @Nullable
    public ResultSetViewer getResultSetController() {
        return this.viewer;
    }

    boolean hasData() {
        return this.viewer != null && this.viewer.hasData();
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this;
    }

    public boolean isReadyToRun() {
        return this.queryProcessor.getCurJob() == null || this.queryProcessor.getRunningJobs() <= 0;
    }

    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        UIUtils.syncExec(() -> {
            QueryResultsContainer resultsProvider = this.queryProcessor.createResultsProvider(dataContainer);
            CTabItem tabItem = resultsProvider.getResultsTab();
            if (tabItem != null) {
                tabItem.getParent().setSelection(tabItem);
            }
            this.getOwner().setActiveResultsContainer(resultsProvider);
            resultsProvider.viewer.refreshWithFilter(newFilter);
        });
    }

    public IResultSetDecorator createResultSetDecorator() {
        return this.getOwner().createQueryResultsDecorator(this.singleQuery);
    }

    @NotNull
    public String[] getSupportedFeatures() {
        SQLQuery sqlQuery;
        if (this.dataContainer != null) {
            return this.dataContainer.getSupportedFeatures();
        }
        ArrayList<String> features = new ArrayList<String>(3);
        features.add("data.select");
        SQLScriptElement sQLScriptElement = this.query;
        if (sQLScriptElement instanceof SQLQuery && (sqlQuery = (SQLQuery)sQLScriptElement).isModifying()) {
            features.add("data.modifying");
        }
        features.add("data.count");
        if (this.getQueryResultCounts() <= 1 && this.lastGoodQuery instanceof SQLQuery) {
            features.add("data.filter");
        }
        return features.toArray(new String[0]);
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        SQLQuery sqlQuery;
        if (this.dataContainer != null) {
            return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags, fetchSize);
        }
        SQLQueryJob job = this.queryProcessor.getCurJob();
        if (job == null) {
            throw new DBCException("No active query - can't read data");
        }
        SQLScriptElement sQLScriptElement = this.query;
        if (sQLScriptElement instanceof SQLQuery && (sqlQuery = (SQLQuery)sQLScriptElement).getResultsMaxRows() >= 0) {
            firstRow = sqlQuery.getResultsOffset();
            maxRows = sqlQuery.getResultsMaxRows();
        }
        try {
            if (dataReceiver != this.viewer.getDataReceiver()) {
                this.queryProcessor.setCurDataReceiver(dataReceiver);
            } else {
                this.queryProcessor.setCurDataReceiver(null);
            }
            int resultCounts = this.getQueryResultCounts();
            if (resultCounts <= 1 && this.resultSetNumber > 0) {
                job.setFetchResultSetNumber(this.resultSetNumber);
            } else {
                job.setFetchResultSetNumber(-1);
            }
            job.setResultSetLimit(firstRow, maxRows);
            job.setDataFilter(dataFilter);
            job.setFetchSize(fetchSize);
            job.setFetchFlags(flags);
            try {
                job.extractData(session, this.query, resultCounts > 1 ? 0 : this.resultSetNumber, !this.detached, !this.detached);
            }
            finally {
                this.lastGoodQuery = job.getLastGoodQuery();
            }
            DBCStatistics dBCStatistics = job.getStatistics();
            return dBCStatistics;
        }
        finally {
            this.queryProcessor.setCurDataReceiver(null);
        }
    }

    private int getQueryResultCounts() {
        int resultCounts = 0;
        for (QueryResultsContainer qrc : this.queryProcessor.resultContainers) {
            if (qrc.query != this.query) continue;
            ++resultCounts;
        }
        return resultCounts;
    }

    /*
     * WARNING - void declaration
     */
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBException {
        if (this.dataContainer != null) {
            return this.dataContainer.countData(source, session, dataFilter, 0L);
        }
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new DBCException("Query transform is not supported by datasource");
        }
        SQLScriptElement sQLScriptElement = this.query;
        if (!(sQLScriptElement instanceof SQLQuery)) {
            throw new DBCException("Can't count rows for control command");
        }
        SQLQuery sQLQuery = (SQLQuery)sQLScriptElement;
        try {
            void sqlQuery;
            SQLQuery countQuery = new SQLQueryTransformerCount().transformQuery(dataSource, this.getOwner().getSyntaxManager(), (SQLQuery)sqlQuery);
            if (!CommonUtils.isEmpty((Collection)countQuery.getParameters())) {
                countQuery.setParameters(this.getOwner().parseQueryParameters(countQuery));
            }
            return DBUtils.countDataFromQuery((DBCExecutionSource)source, (DBCSession)session, (SQLQuery)countQuery);
        }
        catch (DBException e) {
            throw new DBCException("Error executing row count", (Throwable)e);
        }
    }

    @Nullable
    public String getDescription() {
        if (this.dataContainer != null) {
            return this.dataContainer.getDescription();
        }
        return SQLEditorMessages.editors_sql_description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.getOwner().getDataSource();
    }

    public boolean isPersisted() {
        return this.dataContainer == null || this.dataContainer.isPersisted();
    }

    @NotNull
    public String getName() {
        String name;
        if (this.dataContainer != null) {
            return this.dataContainer.getName();
        }
        String string = this.lastGoodQuery != null ? this.lastGoodQuery.getOriginalText() : (name = this.query == null ? null : this.query.getOriginalText());
        if (name == null) {
            name = "SQL";
        }
        return name;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.getOwner().getDataSourceContainer();
    }

    public String toString() {
        if (this.dataContainer != null) {
            return this.dataContainer.toString();
        }
        return this.query == null ? "SQL Query / " + this.getOwner().getEditorInput().getName() : this.query.getOriginalText();
    }

    public void handleResultSetLoad() {
    }

    public void handleResultSetChange() {
        this.getOwner().updateDirtyFlag();
    }

    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
    }

    public void onModelPrepared() {
        this.getOwner().notifyOnDataListeners(this);
    }

    public SQLScriptContext getScriptContext() {
        return this.getOwner().getGlobalScriptContext();
    }

    public SQLScriptElement getQuery() {
        return this.query;
    }

    void setQuery(SQLScriptElement query) {
        this.query = query;
    }

    public Map<String, Object> getQueryParameters() {
        return this.getOwner().getGlobalScriptContext().getAllParameters();
    }

    public boolean isSmartAutoCommit() {
        return this.getOwner().isSmartAutoCommit();
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.getOwner().setSmartAutoCommit(smartAutoCommit);
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public void insertCurrentCellValue(DBDAttributeBinding attributeBinding, Object cellValue, String stringValue) {
        StyledText textWidget;
        StyledText styledText = textWidget = this.getOwner().getTextViewer() == null ? null : this.getOwner().getTextViewer().getTextWidget();
        if (textWidget != null) {
            String sqlValue = this.getDataSource() != null ? SQLUtils.convertValueToSQL((DBPDataSource)this.getDataSource(), (DBSTypedObject)attributeBinding, (Object)cellValue) : stringValue;
            textWidget.insert(sqlValue);
            textWidget.setCaretOffset(textWidget.getCaretOffset() + sqlValue.length());
            textWidget.setFocus();
        }
    }

    public void forceDataReadCancel(Throwable error) {
        for (QueryProcessor processor : this.getOwner().queryProcessors) {
            SQLQueryJob job = processor.getCurJob();
            if (job == null) continue;
            SQLQueryResult currentQueryResult = job.getCurrentQueryResult();
            if (currentQueryResult == null) {
                currentQueryResult = new SQLQueryResult(new SQLQuery(null, ""));
            }
            currentQueryResult.setError(error);
            job.notifyQueryExecutionEnd(null, currentQueryResult);
        }
    }

    public void handleExecuteResult(DBCExecutionResult result) {
        if (this.resultSetNumber == 0) {
            this.getOwner().dumpQueryServerOutput(result);
        }
    }

    public void showCurrentError() {
        SQLEditor owner = this.getOwner();
        if (owner.getLastQueryErrorPosition() > -1) {
            owner.getSelectionProvider().setSelection((ISelection)new TextSelection(owner.getLastQueryErrorPosition(), 0));
            owner.setFocus();
        }
    }

    public abstract CTabItem getResultsTab();

    public abstract boolean isPinned();

    public abstract void setPinned(boolean var1);

    protected boolean isTabPinned(CTabItem tabItem) {
        return tabItem != null && !tabItem.isDisposed() && !tabItem.getShowClose();
    }

    protected void setTabPinned(@Nullable CTabItem tabItem, boolean pinned) {
        if (tabItem != null) {
            tabItem.setShowClose(!pinned);
            tabItem.setImage(pinned ? SQLEditor.IMG_DATA_GRID_LOCKED : SQLEditor.IMG_DATA_GRID);
        }
    }

    boolean isStatistics() {
        return this.query != null && this.query.getData() == SQLQueryJob.STATS_RESULTS;
    }
}

