/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgrePlanNodeBase<NODE extends PostgrePlanNodeBase<?>>
extends AbstractExecutionPlanNode
implements DBCPlanCostNode,
DBPPropertySource {
    private static final String ATTR_JOIN_TYPE = "Join-Type";
    private static final String ATTR_HASH_COND = "Hash-Cond";
    private static final String ATTR_INDEX_COND = "Index-Cond";
    static final String ATTR_NODE_TYPE = "Node-Type";
    static final String ATTR_RELATION_NAME = "Relation-Name";
    static final String ATTR_FUNCTION_NAME = "Function-Name";
    public static final String ATTR_ALIAS = "Alias";
    static final String ATTR_TOTAL_COST = "Total-Cost";
    static final String ATTR_STARTUP_COST = "Startup-Cost";
    static final String ATTR_INDEX_NAME = "Index-Name";
    private static final String ATTR_CTE_NAME = "CTE-Name";
    private static final String ATTR_ACTUAL_TOTAL_TIME = "Actual-Total-Time";
    static final String ATTR_ACTUAL_ROWS = "Actual-Rows";
    static final String ATTR_PLAN_ROWS = "Plan-Rows";
    private static final String ATTR_FILTER = "Filter";
    private static final String ATTR_PARALLEL_AWARE = "Parallel-Aware";
    static final String ATTR_OBJECT_NAME = "Object name";
    private static final List<String> allowedKind = new ArrayList<String>(Arrays.asList("result", "project", "index", "hash", "foregin", "aggregate", "modify", "inset", "update", "delete", "loop", "join", "merge", "sort", "merge", "group", "materialize", "function"));
    private final DBPDataSource dataSource;
    protected NODE parent;
    protected final List<NODE> nested = new ArrayList<NODE>();
    protected String nodeType;
    private String entity;
    private String cost;
    protected Map<String, String> attributes = Collections.emptyMap();

    protected PostgrePlanNodeBase(DBPDataSource dataSource, NODE parent) {
        this.parent = parent;
        this.dataSource = dataSource;
    }

    protected void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        this.nodeType = attributes.remove(ATTR_NODE_TYPE);
        this.entity = attributes.get(ATTR_RELATION_NAME);
        if (this.entity == null) {
            this.entity = attributes.get(ATTR_FUNCTION_NAME);
        }
        if (this.entity == null) {
            this.entity = attributes.get(ATTR_INDEX_NAME);
        }
        if (this.entity == null) {
            this.entity = attributes.get(ATTR_CTE_NAME);
        }
        String startCost = attributes.get(ATTR_STARTUP_COST);
        String totalCost = attributes.get(ATTR_TOTAL_COST);
        this.cost = CommonUtils.isEmpty((String)startCost) && CommonUtils.isEmpty((String)totalCost) ? "" : startCost + " - " + totalCost;
        String parallelAware = attributes.get(ATTR_PARALLEL_AWARE);
        if ("true".equals(parallelAware)) {
            this.nodeType = "Parallel " + this.nodeType;
        }
    }

    public String getNodeName() {
        return this.entity;
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeDescription() {
        return this.attributes.get(ATTR_FILTER);
    }

    @Property(order=2, viewable=true)
    public String getEntity() {
        return this.entity;
    }

    @Property(order=3, viewable=true)
    public String getCost() {
        return this.cost;
    }

    @Property(order=21, viewable=true)
    public String getActualRows() {
        String rows = this.attributes.get(ATTR_ACTUAL_ROWS);
        if (rows == null) {
            rows = this.attributes.get(ATTR_PLAN_ROWS);
        }
        return rows;
    }

    @Property(order=22, viewable=true)
    public String getTotalTime() {
        return this.attributes.get(ATTR_ACTUAL_TOTAL_TIME);
    }

    @Property(order=23, viewable=true)
    public String getNodeCondition() {
        String cond = this.attributes.get(ATTR_INDEX_COND);
        if (cond == null) {
            cond = this.attributes.get(ATTR_HASH_COND);
        }
        if (cond == null) {
            cond = this.attributes.get(ATTR_FILTER);
        }
        if (!CommonUtils.isEmpty((String)cond)) {
            cond = SQLFormatUtils.formatSQL((DBPDataSource)this.dataSource, (String)cond);
        }
        return cond;
    }

    public NODE getParent() {
        return this.parent;
    }

    public List<NODE> getNested() {
        return this.nested;
    }

    public Number getNodeCost() {
        String totalCost = this.attributes.get(ATTR_TOTAL_COST);
        return totalCost == null ? null : Double.valueOf(CommonUtils.toDouble((Object)totalCost));
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        String time = this.attributes.get(ATTR_ACTUAL_TOTAL_TIME);
        return time == null ? null : Double.valueOf(CommonUtils.toDouble((Object)time));
    }

    public Number getNodeRowCount() {
        String rows = this.attributes.get(ATTR_ACTUAL_ROWS);
        if (rows == null) {
            rows = this.attributes.get(ATTR_PLAN_ROWS);
        }
        return rows == null ? null : Long.valueOf(CommonUtils.toLong((Object)rows));
    }

    public String toString() {
        StringBuilder title = new StringBuilder();
        title.append("Type: ").append(this.nodeType);
        String joinType = this.attributes.get(ATTR_JOIN_TYPE);
        if (!CommonUtils.isEmpty((String)joinType)) {
            title.append(" (").append(joinType).append(")");
        }
        title.append("; ");
        if (!CommonUtils.isEmpty((String)this.entity)) {
            title.append("Rel: ").append(this.entity).append(" ");
        }
        title.append("; Cost: ").append(this.cost);
        return title.toString();
    }

    public DBCPlanNodeKind getNodeKind() {
        String op = this.nodeType.toLowerCase();
        for (String kind : allowedKind) {
            if (!op.contains(kind)) continue;
            switch (kind) {
                case "result": {
                    return DBCPlanNodeKind.RESULT;
                }
                case "project": {
                    return DBCPlanNodeKind.SET;
                }
                case "filter": {
                    return DBCPlanNodeKind.FILTER;
                }
                case "collector": {
                    return DBCPlanNodeKind.AGGREGATE;
                }
                case "index": {
                    return DBCPlanNodeKind.INDEX_SCAN;
                }
                case "hash": {
                    return DBCPlanNodeKind.HASH;
                }
                case "foregin": {
                    return DBCPlanNodeKind.TABLE_SCAN;
                }
                case "aggregate": {
                    return DBCPlanNodeKind.AGGREGATE;
                }
                case "modify": {
                    return DBCPlanNodeKind.MODIFY;
                }
                case "insert": {
                    return DBCPlanNodeKind.MODIFY;
                }
                case "update": {
                    return DBCPlanNodeKind.MODIFY;
                }
                case "delete": {
                    return DBCPlanNodeKind.MODIFY;
                }
                case "loop": {
                    return DBCPlanNodeKind.JOIN;
                }
                case "join": {
                    return DBCPlanNodeKind.JOIN;
                }
                case "merge": {
                    return DBCPlanNodeKind.MERGE;
                }
                case "sort": {
                    return DBCPlanNodeKind.SORT;
                }
                case "group": {
                    return DBCPlanNodeKind.GROUP;
                }
                case "materialize": {
                    return DBCPlanNodeKind.MATERIALIZE;
                }
                case "function": {
                    return DBCPlanNodeKind.FUNCTION;
                }
            }
            return DBCPlanNodeKind.DEFAULT;
        }
        return DBCPlanNodeKind.DEFAULT;
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.attributes.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.attributes.get(id.toString());
    }

    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

