/* zeitgeist-daemon.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from zeitgeist-daemon.vala, do not modify */

/* zeitgeist-daemon.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _GNU_SOURCE

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist.h"
#include "zeitgeist-engine.h"
#include "zeitgeist-datamodel.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include <stdio.h>
#include <signal.h>
#include <locale.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_DBUS (zeitgeist_remote_dbus_get_type ())
#define ZEITGEIST_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBus))
#define ZEITGEIST_IS_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS))
#define ZEITGEIST_REMOTE_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBusIface))

typedef struct _ZeitgeistRemoteDBus ZeitgeistRemoteDBus;
typedef struct _ZeitgeistRemoteDBusIface ZeitgeistRemoteDBusIface;

#define ZEITGEIST_TYPE_REMOTE_DBUS_PROXY (zeitgeist_remote_dbus_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteDBusProxy;
typedef GDBusProxyClass ZeitgeistRemoteDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZEITGEIST_TYPE_DAEMON (zeitgeist_daemon_get_type ())
#define ZEITGEIST_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon))
#define ZEITGEIST_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))
#define ZEITGEIST_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))

typedef struct _ZeitgeistDaemon ZeitgeistDaemon;
typedef struct _ZeitgeistDaemonClass ZeitgeistDaemonClass;
typedef struct _ZeitgeistDaemonPrivate ZeitgeistDaemonPrivate;
enum  {
	ZEITGEIST_DAEMON_0_PROPERTY,
	ZEITGEIST_DAEMON_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_daemon_properties[ZEITGEIST_DAEMON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistDaemonGetEventsData ZeitgeistDaemonGetEventsData;
typedef struct _ZeitgeistDaemonFindRelatedUrisData ZeitgeistDaemonFindRelatedUrisData;
typedef struct _ZeitgeistDaemonFindEventIdsData ZeitgeistDaemonFindEventIdsData;
typedef struct _ZeitgeistDaemonFindEventsData ZeitgeistDaemonFindEventsData;
typedef struct _ZeitgeistDaemonInsertEventsData ZeitgeistDaemonInsertEventsData;
typedef struct _ZeitgeistDaemonDeleteEventsData ZeitgeistDaemonDeleteEventsData;
typedef struct _ZeitgeistDaemonQuitData ZeitgeistDaemonQuitData;
typedef struct _ZeitgeistDaemonInstallMonitorData ZeitgeistDaemonInstallMonitorData;
typedef struct _ZeitgeistDaemonRemoveMonitorData ZeitgeistDaemonRemoveMonitorData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistRemoteDBusIface {
	GTypeInterface parent_iface;
	gboolean (*name_has_owner) (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
};

struct _ZeitgeistDaemon {
	GObject parent_instance;
	ZeitgeistDaemonPrivate * priv;
};

struct _ZeitgeistDaemonClass {
	GObjectClass parent_class;
};

struct _ZeitgeistDaemonPrivate {
	ZeitgeistRegisterExtensionFunc* builtins;
	gint builtins_length1;
	gint _builtins_size_;
	ZeitgeistEngine* engine;
	ZeitgeistMonitorManager* notifications;
	guint log_register_id;
	GDBusConnection* connection;
};

struct _ZeitgeistDaemonGetEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	guint32* event_ids;
	gint event_ids_length1;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	GTimer* timer;
	GTimer* _tmp0_;
	GPtrArray* events;
	ZeitgeistEngine* _tmp1_;
	GPtrArray* _tmp2_;
	GTimer* _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GVariant* _tmp7_;
	GPtrArray* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonFindRelatedUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	GVariant* result_event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	gchar** result;
	gint result_length1;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	gchar** _tmp6_;
	ZeitgeistEngine* _tmp7_;
	gint _tmp8_;
	gchar** _tmp9_;
	gint _tmp6__length1;
	gint __tmp6__size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonFindEventIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	guint32* result;
	gint result_length1;
	GTimer* timer;
	GTimer* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	guint32* ids;
	ZeitgeistEngine* _tmp5_;
	gint _tmp6_;
	guint32* _tmp7_;
	gint ids_length1;
	gint _ids_size_;
	GTimer* _tmp8_;
	guint32* _tmp9_;
	gint _tmp9__length1;
	guint32* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	GTimer* timer;
	GTimer* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* events;
	ZeitgeistEngine* _tmp5_;
	GPtrArray* _tmp6_;
	GTimer* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GVariant* _tmp11_;
	GPtrArray* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	GVariant* vevents;
	GCancellable* cancellable;
	char* sender;
	guint32* result;
	gint result_length1;
	GPtrArray* events;
	GPtrArray* _tmp0_;
	guint32* event_ids;
	ZeitgeistEngine* _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	guint32* _tmp4_;
	gint event_ids_length1;
	gint _event_ids_size_;
	gint64 min_timestamp;
	gint64 max_timestamp;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	GPtrArray* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GPtrArray* _tmp10_;
	gconstpointer _tmp11_;
	GPtrArray* _tmp12_;
	gconstpointer _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	GPtrArray* _tmp16_;
	gconstpointer _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	ZeitgeistMonitorManager* _tmp20_;
	ZeitgeistTimeRange* _tmp21_;
	ZeitgeistTimeRange* _tmp22_;
	GPtrArray* _tmp23_;
	guint32* _tmp24_;
	gint _tmp24__length1;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonDeleteEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	guint32* event_ids;
	gint event_ids_length1;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	ZeitgeistTimeRange* time_range;
	ZeitgeistEngine* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistMonitorManager* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistTimeRange* _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	GVariant* _tmp7_;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	GCancellable* cancellable;
};

struct _ZeitgeistDaemonInstallMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	char* monitor_path;
	GVariant* time_range;
	GVariant* event_templates;
	char* owner;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	ZeitgeistMonitorManager* _tmp4_;
	GError* _inner_error0_;
};

struct _ZeitgeistDaemonRemoveMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistDaemon* self;
	char* monitor_path;
	char* owner;
	ZeitgeistMonitorManager* _tmp0_;
};

static gint ZeitgeistDaemon_private_offset;
static gpointer zeitgeist_daemon_parent_class = NULL;
static gboolean zeitgeist_daemon_show_version_info;
static gboolean zeitgeist_daemon_no_datahub;
static gboolean zeitgeist_daemon_perform_vacuum;
static gboolean zeitgeist_daemon_replace_mode;
static gboolean zeitgeist_daemon_quit_daemon;
static gchar* zeitgeist_daemon_log_level;
static gchar* zeitgeist_daemon_log_file;
static gboolean zeitgeist_daemon_show_options;
static gboolean zeitgeist_daemon_show_version_info = FALSE;
static gboolean zeitgeist_daemon_show_options = FALSE;
static gboolean zeitgeist_daemon_no_datahub = FALSE;
static gboolean zeitgeist_daemon_perform_vacuum = FALSE;
static gboolean zeitgeist_daemon_replace_mode = FALSE;
static gboolean zeitgeist_daemon_quit_daemon = FALSE;
static gchar* zeitgeist_daemon_log_level = NULL;
static gchar* zeitgeist_daemon_log_file = NULL;
static ZeitgeistDaemon* zeitgeist_daemon_instance;
static ZeitgeistDaemon* zeitgeist_daemon_instance = NULL;
static GMainLoop* zeitgeist_daemon_mainloop;
static GMainLoop* zeitgeist_daemon_mainloop = NULL;
static gboolean zeitgeist_daemon_name_acquired;
static gboolean zeitgeist_daemon_name_acquired = FALSE;
static ZeitgeistRemoteLogIface * zeitgeist_daemon_zeitgeist_remote_log_parent_iface = NULL;

VALA_EXTERN GType zeitgeist_remote_dbus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint zeitgeist_remote_dbus_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType zeitgeist_remote_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteDBus, g_object_unref)
VALA_EXTERN gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                               const gchar* name,
                                               GError** error);
static GType zeitgeist_remote_dbus_get_type_once (void);
static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self,
                                                     const gchar* name,
                                                     GError** error);
static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface);
static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data);
VALA_EXTERN GType zeitgeist_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistDaemon, g_object_unref)
VALA_EXTERN ZeitgeistDaemon* zeitgeist_daemon_new (GError** error);
VALA_EXTERN ZeitgeistDaemon* zeitgeist_daemon_construct (GType object_type,
                                             GError** error);
GType zeitgeist_data_source_registry_extension_init (GTypeModule* mod);
static GType _zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_blacklist_init (GTypeModule* mod);
static GType _zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_histogram_init (GTypeModule* mod);
static GType _zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_storage_monitor_init (GTypeModule* mod);
static GType _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_fts_init (GTypeModule* mod);
static GType _zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_benchmark_init (GTypeModule* mod);
static GType _zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module);
static void zeitgeist_daemon_real_get_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base,
                                       guint32* event_ids,
                                       gint event_ids_length1,
                                       GCancellable* cancellable,
                                       const char* sender,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean zeitgeist_daemon_real_get_events_co (ZeitgeistDaemonGetEventsData* _data_);
static void zeitgeist_daemon_real_find_related_uris_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base,
                                              GVariant* time_range,
                                              GVariant* event_templates,
                                              GVariant* result_event_templates,
                                              guint storage_state,
                                              guint num_events,
                                              guint result_type,
                                              GCancellable* cancellable,
                                              const char* sender,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_related_uris_co (ZeitgeistDaemonFindRelatedUrisData* _data_);
static void zeitgeist_daemon_real_find_event_ids_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base,
                                           GVariant* time_range,
                                           GVariant* event_templates,
                                           guint storage_state,
                                           guint num_events,
                                           guint result_type,
                                           GCancellable* cancellable,
                                           const char* sender,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_event_ids_co (ZeitgeistDaemonFindEventIdsData* _data_);
static void zeitgeist_daemon_real_find_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base,
                                        GVariant* time_range,
                                        GVariant* event_templates,
                                        guint storage_state,
                                        guint num_events,
                                        guint result_type,
                                        GCancellable* cancellable,
                                        const char* sender,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_events_co (ZeitgeistDaemonFindEventsData* _data_);
static void zeitgeist_daemon_real_insert_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base,
                                          GVariant* vevents,
                                          GCancellable* cancellable,
                                          const char* sender,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean zeitgeist_daemon_real_insert_events_co (ZeitgeistDaemonInsertEventsData* _data_);
static void zeitgeist_daemon_real_delete_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base,
                                          guint32* event_ids,
                                          gint event_ids_length1,
                                          GCancellable* cancellable,
                                          const char* sender,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean zeitgeist_daemon_real_delete_events_co (ZeitgeistDaemonDeleteEventsData* _data_);
static void zeitgeist_daemon_real_quit_data_free (gpointer _data);
static void zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean zeitgeist_daemon_real_quit_co (ZeitgeistDaemonQuitData* _data_);
static void zeitgeist_daemon_do_quit (ZeitgeistDaemon* self);
static void zeitgeist_daemon_real_install_monitor_data_free (gpointer _data);
static void zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base,
                                            const char* monitor_path,
                                            GVariant* time_range,
                                            GVariant* event_templates,
                                            const char* owner,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean zeitgeist_daemon_real_install_monitor_co (ZeitgeistDaemonInstallMonitorData* _data_);
static void zeitgeist_daemon_real_remove_monitor_data_free (gpointer _data);
static void zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base,
                                           const char* monitor_path,
                                           const char* owner,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean zeitgeist_daemon_real_remove_monitor_co (ZeitgeistDaemonRemoveMonitorData* _data_);
VALA_EXTERN void zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self,
                                            GDBusConnection* conn,
                                            GError** error);
VALA_EXTERN void zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self);
static gboolean zeitgeist_daemon_quit_running_instance (GDBusConnection* conn);
static void zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn);
static void zeitgeist_daemon_name_lost_callback (GDBusConnection* conn);
static gboolean ____lambda4_ (void);
static gboolean _____lambda4__gsource_func (gpointer self);
static void zeitgeist_daemon_run (GError** error);
static void _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
static void _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
static void zeitgeist_daemon_safe_exit (void);
static gint zeitgeist_daemon_vacuum (void);
static gint zeitgeist_daemon_main (gchar** args,
                            gint args_length1);
static void _zeitgeist_daemon_safe_exit_sighandler_t (gint signal);
static void zeitgeist_daemon_finalize (GObject * obj);
static GType zeitgeist_daemon_get_type_once (void);
static void _vala_zeitgeist_daemon_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_dbus_dbus_method_info[] = {&_zeitgeist_remote_dbus_dbus_method_info_name_has_owner, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_zeitgeist_remote_dbus_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_dbus_dbus_interface_vtable = {zeitgeist_remote_dbus_dbus_interface_method_call, zeitgeist_remote_dbus_dbus_interface_get_property, zeitgeist_remote_dbus_dbus_interface_set_property};
static const GOptionEntry ZEITGEIST_DAEMON_options[10] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_version_info, "Print program's version number and exit", NULL}, {"no-datahub", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, "Do not start zeitgeist-datahub automatically", NULL}, {"vacuum", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_perform_vacuum, "Perform VACUUM on database and exit", NULL}, {"no-passive-loggers", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, NULL, NULL}, {"replace", 'r', (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_replace_mode, "If another Zeitgeist instance is already running, replace it", NULL}, {"quit", 'q', (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_quit_daemon, "Quit running Zeitgeist daemon instance", NULL}, {"log-level", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_level, "How much information should be printed; possible values: " "DEBUG, INFO, WARNING, ERROR, CRITICAL", "LEVEL"}, {"log-file", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_file, "File to which the log output will be appended", NULL}, {"shell-completion", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_options, NULL, NULL}, {NULL}};

gboolean
zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                      const gchar* name,
                                      GError** error)
{
	ZeitgeistRemoteDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ZEITGEIST_REMOTE_DBUS_GET_INTERFACE (self);
	if (_iface_->name_has_owner) {
		return _iface_->name_has_owner (self, name, error);
	}
	return FALSE;
}

static void
zeitgeist_remote_dbus_default_init (ZeitgeistRemoteDBusIface * iface,
                                    gpointer iface_data)
{
}

static GType
zeitgeist_remote_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType zeitgeist_remote_dbus_type_id;
	zeitgeist_remote_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistRemoteDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_dbus_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_dbus_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_dbus_register_object);
	return zeitgeist_remote_dbus_type_id;
}

GType
zeitgeist_remote_dbus_get_type (void)
{
	static volatile gsize zeitgeist_remote_dbus_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_remote_dbus_type_id__once)) {
		GType zeitgeist_remote_dbus_type_id;
		zeitgeist_remote_dbus_type_id = zeitgeist_remote_dbus_get_type_once ();
		g_once_init_leave (&zeitgeist_remote_dbus_type_id__once, zeitgeist_remote_dbus_type_id);
	}
	return zeitgeist_remote_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteDBusProxy, zeitgeist_remote_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_DBUS, zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init) )
static void
zeitgeist_remote_dbus_proxy_class_init (ZeitgeistRemoteDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_dbus_proxy_g_signal;
}

static void
zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
zeitgeist_remote_dbus_proxy_init (ZeitgeistRemoteDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info));
}

static gboolean
zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self,
                                            const gchar* name,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp2_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp1_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface)
{
	iface->name_has_owner = zeitgeist_remote_dbus_proxy_name_has_owner;
}

static void
_dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	result = zeitgeist_remote_dbus_name_has_owner (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_zeitgeist_remote_dbus_name_has_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
zeitgeist_remote_dbus_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info), &_zeitgeist_remote_dbus_dbus_interface_vtable, data, _zeitgeist_remote_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_zeitgeist_remote_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
zeitgeist_daemon_get_instance_private (ZeitgeistDaemon* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistDaemon_private_offset);
}

static GType
_zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_data_source_registry_extension_init (module);
	return result;
}

static GType
_zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_blacklist_init (module);
	return result;
}

static GType
_zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_histogram_init (module);
	return result;
}

static GType
_zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_storage_monitor_init (module);
	return result;
}

static GType
_zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_fts_init (module);
	return result;
}

static GType
_zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module)
{
	GType result;
	result = zeitgeist_benchmark_init (module);
	return result;
}

ZeitgeistDaemon*
zeitgeist_daemon_construct (GType object_type,
                            GError** error)
{
	ZeitgeistDaemon * self = NULL;
	ZeitgeistRegisterExtensionFunc* _tmp0_;
	ZeitgeistEngine* _tmp1_ = NULL;
	ZeitgeistRegisterExtensionFunc* _tmp2_;
	gint _tmp2__length1;
	ZeitgeistEngine* _tmp3_;
	ZeitgeistEngine* _tmp4_;
	ZeitgeistMonitorManager* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (ZeitgeistRegisterExtensionFunc, 6);
	_tmp0_[0] = _zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func;
	_tmp0_[1] = _zeitgeist_blacklist_init_zeitgeist_register_extension_func;
	_tmp0_[2] = _zeitgeist_histogram_init_zeitgeist_register_extension_func;
	_tmp0_[3] = _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func;
	_tmp0_[4] = _zeitgeist_fts_init_zeitgeist_register_extension_func;
	_tmp0_[5] = _zeitgeist_benchmark_init_zeitgeist_register_extension_func;
	self->priv->builtins = (g_free (self->priv->builtins), NULL);
	self->priv->builtins = _tmp0_;
	self->priv->builtins_length1 = 6;
	self->priv->_builtins_size_ = self->priv->builtins_length1;
	_tmp2_ = self->priv->builtins;
	_tmp2__length1 = self->priv->builtins_length1;
	_tmp3_ = zeitgeist_engine_new_with_builtins (_tmp2_, _tmp2__length1, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp4_;
	_tmp5_ = zeitgeist_monitor_manager_get_default ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp5_;
	_g_object_unref0 (_tmp1_);
	return self;
}

ZeitgeistDaemon*
zeitgeist_daemon_new (GError** error)
{
	return zeitgeist_daemon_construct (ZEITGEIST_TYPE_DAEMON, error);
}

static void
zeitgeist_daemon_real_get_events_data_free (gpointer _data)
{
	ZeitgeistDaemonGetEventsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonGetEventsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base,
                                  guint32* event_ids,
                                  gint event_ids_length1,
                                  GCancellable* cancellable,
                                  const char* sender,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonGetEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GCancellable* _tmp1_;
	char* _tmp2_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonGetEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_get_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->event_ids = event_ids;
	_data_->event_ids_length1 = event_ids_length1;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	_tmp2_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp2_;
	zeitgeist_daemon_real_get_events_co (_data_);
}

static GVariant*
zeitgeist_daemon_get_events_finish (ZeitgeistRemoteLog* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GVariant* result;
	ZeitgeistDaemonGetEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
zeitgeist_daemon_real_get_events_co (ZeitgeistDaemonGetEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->engine;
	_data_->_tmp2_ = zeitgeist_db_reader_get_events ((ZeitgeistDbReader*) _data_->_tmp1_, _data_->event_ids, (gint) _data_->event_ids_length1, NULL, &_data_->_inner_error0_);
	_data_->events = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->timer;
	_data_->_tmp4_ = _data_->events;
	_data_->_tmp5_ = vala_g_ptr_array_get_length (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("zeitgeist-daemon.vala:164: %s executed in %f seconds: got %i events", "Zeitgeist.Daemon.get_events", g_timer_elapsed (_data_->_tmp3_, NULL), _data_->_tmp6_);
	_data_->_tmp8_ = _data_->events;
	_data_->_tmp9_ = zeitgeist_events_to_variant_with_limit (_data_->_tmp8_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_data_->_inner_error0_);
	_data_->_tmp7_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp7_;
	_data_->_tmp7_ = NULL;
	_data_->result = _data_->_tmp10_;
	_g_variant_unref0 (_data_->_tmp7_);
	_g_ptr_array_unref0 (_data_->events);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_find_related_uris_data_free (gpointer _data)
{
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_variant_unref0 (_data_->result_event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindRelatedUrisData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base,
                                         GVariant* time_range,
                                         GVariant* event_templates,
                                         GVariant* result_event_templates,
                                         guint storage_state,
                                         guint num_events,
                                         guint result_type,
                                         GCancellable* cancellable,
                                         const char* sender,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GCancellable* _tmp4_;
	char* _tmp5_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	g_return_if_fail (result_event_templates != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindRelatedUrisData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_related_uris_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (event_templates);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_tmp3_ = _g_variant_ref0 (result_event_templates);
	_g_variant_unref0 (_data_->result_event_templates);
	_data_->result_event_templates = _tmp3_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	_tmp5_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp5_;
	zeitgeist_daemon_real_find_related_uris_co (_data_);
}

static gchar**
zeitgeist_daemon_find_related_uris_finish (ZeitgeistRemoteLog* base,
                                           GAsyncResult* _res_,
                                           gint* result_length1,
                                           GError** error)
{
	gchar** result;
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
zeitgeist_daemon_real_find_related_uris_co (ZeitgeistDaemonFindRelatedUrisData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = zeitgeist_events_from_variant (_data_->result_event_templates, &_data_->_inner_error0_);
	_data_->_tmp4_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->_tmp2_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->engine;
	_data_->_tmp8_ = 0;
	_data_->_tmp9_ = zeitgeist_db_reader_find_related_uris ((ZeitgeistDbReader*) _data_->_tmp7_, _data_->_tmp0_, _data_->_tmp2_, _data_->_tmp4_, _data_->storage_state, _data_->num_events, _data_->result_type, NULL, &_data_->_tmp8_, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp9_;
	_data_->_tmp6__length1 = _data_->_tmp8_;
	_data_->__tmp6__size_ = _data_->_tmp6__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->_tmp4_);
		_g_ptr_array_unref0 (_data_->_tmp2_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp6_;
	_data_->_tmp10__length1 = _data_->_tmp6__length1;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6__length1 = 0;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp11__length1 = _data_->_tmp10__length1;
	_data_->result_length1 = _data_->_tmp11__length1;
	_data_->result = _data_->_tmp11_;
	_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_free), NULL);
	_g_ptr_array_unref0 (_data_->_tmp4_);
	_g_ptr_array_unref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_find_event_ids_data_free (gpointer _data)
{
	ZeitgeistDaemonFindEventIdsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindEventIdsData, _data_);
}

static void
zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base,
                                      GVariant* time_range,
                                      GVariant* event_templates,
                                      guint storage_state,
                                      guint num_events,
                                      guint result_type,
                                      GCancellable* cancellable,
                                      const char* sender,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindEventIdsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GCancellable* _tmp3_;
	char* _tmp4_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindEventIdsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_event_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (event_templates);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	_tmp4_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp4_;
	zeitgeist_daemon_real_find_event_ids_co (_data_);
}

static guint32*
zeitgeist_daemon_find_event_ids_finish (ZeitgeistRemoteLog* base,
                                        GAsyncResult* _res_,
                                        gint* result_length1,
                                        GError** error)
{
	guint32* result;
	ZeitgeistDaemonFindEventIdsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
zeitgeist_daemon_real_find_event_ids_co (ZeitgeistDaemonFindEventIdsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp2_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->engine;
	_data_->_tmp6_ = 0;
	_data_->_tmp7_ = zeitgeist_db_reader_find_event_ids ((ZeitgeistDbReader*) _data_->_tmp5_, _data_->_tmp1_, _data_->_tmp3_, _data_->storage_state, _data_->num_events, _data_->result_type, _data_->sender, &_data_->_tmp6_, &_data_->_inner_error0_);
	_data_->ids = _data_->_tmp7_;
	_data_->ids_length1 = _data_->_tmp6_;
	_data_->_ids_size_ = _data_->ids_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->timer;
	_data_->_tmp9_ = _data_->ids;
	_data_->_tmp9__length1 = _data_->ids_length1;
	g_debug ("zeitgeist-daemon.vala:193: %s executed in %f seconds: found %i event i" \
"ds", "Zeitgeist.Daemon.find_event_ids", g_timer_elapsed (_data_->_tmp8_, NULL), _data_->_tmp9__length1);
	_data_->_tmp10_ = _data_->ids;
	_data_->_tmp10__length1 = _data_->ids_length1;
	_data_->result_length1 = _data_->_tmp10__length1;
	_data_->result = _data_->_tmp10_;
	_g_ptr_array_unref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp1_);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_find_events_data_free (gpointer _data)
{
	ZeitgeistDaemonFindEventsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindEventsData, _data_);
}

static void
zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base,
                                   GVariant* time_range,
                                   GVariant* event_templates,
                                   guint storage_state,
                                   guint num_events,
                                   guint result_type,
                                   GCancellable* cancellable,
                                   const char* sender,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GCancellable* _tmp3_;
	char* _tmp4_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (event_templates);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	_tmp4_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp4_;
	zeitgeist_daemon_real_find_events_co (_data_);
}

static GVariant*
zeitgeist_daemon_find_events_finish (ZeitgeistRemoteLog* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GVariant* result;
	ZeitgeistDaemonFindEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
zeitgeist_daemon_real_find_events_co (ZeitgeistDaemonFindEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp2_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->engine;
	_data_->_tmp6_ = zeitgeist_db_reader_find_events ((ZeitgeistDbReader*) _data_->_tmp5_, _data_->_tmp1_, _data_->_tmp3_, _data_->storage_state, _data_->num_events, _data_->result_type, _data_->sender, &_data_->_inner_error0_);
	_data_->events = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->timer;
	_data_->_tmp8_ = _data_->events;
	_data_->_tmp9_ = vala_g_ptr_array_get_length (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	g_debug ("zeitgeist-daemon.vala:209: %s executed in %f seconds: found %i events", "Zeitgeist.Daemon.find_events", g_timer_elapsed (_data_->_tmp7_, NULL), _data_->_tmp10_);
	_data_->_tmp12_ = _data_->events;
	_data_->_tmp13_ = zeitgeist_events_to_variant_with_limit (_data_->_tmp12_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_data_->_inner_error0_);
	_data_->_tmp11_ = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events);
		_g_ptr_array_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->_tmp11_;
	_data_->_tmp11_ = NULL;
	_data_->result = _data_->_tmp14_;
	_g_variant_unref0 (_data_->_tmp11_);
	_g_ptr_array_unref0 (_data_->events);
	_g_ptr_array_unref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp1_);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_insert_events_data_free (gpointer _data)
{
	ZeitgeistDaemonInsertEventsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->vevents);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonInsertEventsData, _data_);
}

static void
zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base,
                                     GVariant* vevents,
                                     GCancellable* cancellable,
                                     const char* sender,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonInsertEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GCancellable* _tmp2_;
	char* _tmp3_;
	g_return_if_fail (vevents != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonInsertEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_insert_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (vevents);
	_g_variant_unref0 (_data_->vevents);
	_data_->vevents = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_tmp3_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp3_;
	zeitgeist_daemon_real_insert_events_co (_data_);
}

static guint32*
zeitgeist_daemon_insert_events_finish (ZeitgeistRemoteLog* base,
                                       GAsyncResult* _res_,
                                       gint* result_length1,
                                       GError** error)
{
	guint32* result;
	ZeitgeistDaemonInsertEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
zeitgeist_daemon_real_insert_events_co (ZeitgeistDaemonInsertEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_events_from_variant (_data_->vevents, &_data_->_inner_error0_);
	_data_->events = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->engine;
	_data_->_tmp2_ = _data_->events;
	_data_->_tmp3_ = 0;
	_data_->_tmp4_ = zeitgeist_engine_insert_events (_data_->_tmp1_, _data_->_tmp2_, _data_->sender, &_data_->_tmp3_, &_data_->_inner_error0_);
	_data_->event_ids = _data_->_tmp4_;
	_data_->event_ids_length1 = _data_->_tmp3_;
	_data_->_event_ids_size_ = _data_->event_ids_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->min_timestamp = G_MAXINT64;
	_data_->max_timestamp = G_MININT64;
	{
		_data_->i = 0;
		{
			_data_->_tmp5_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = _data_->i;
					_data_->i = _data_->_tmp6_ + 1;
				}
				_data_->_tmp5_ = FALSE;
				_data_->_tmp7_ = _data_->events;
				_data_->_tmp8_ = vala_g_ptr_array_get_length (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				if (!(_data_->i < _data_->_tmp9_)) {
					break;
				}
				_data_->_tmp10_ = _data_->events;
				_data_->_tmp11_ = g_ptr_array_index (_data_->_tmp10_, (guint) _data_->i);
				if (((ZeitgeistEvent*) _data_->_tmp11_) == NULL) {
					continue;
				}
				_data_->_tmp12_ = _data_->events;
				_data_->_tmp13_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->i);
				_data_->_tmp14_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _data_->_tmp13_);
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->min_timestamp = MIN (_data_->min_timestamp, _data_->_tmp15_);
				_data_->_tmp16_ = _data_->events;
				_data_->_tmp17_ = g_ptr_array_index (_data_->_tmp16_, (guint) _data_->i);
				_data_->_tmp18_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->max_timestamp = MAX (_data_->max_timestamp, _data_->_tmp19_);
			}
		}
	}
	if (_data_->min_timestamp < G_MAXINT64) {
		_data_->_tmp20_ = _data_->self->priv->notifications;
		_data_->_tmp21_ = zeitgeist_time_range_new (_data_->min_timestamp, _data_->max_timestamp);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->events;
		zeitgeist_monitor_manager_notify_insert (_data_->_tmp20_, _data_->_tmp22_, _data_->_tmp23_);
		_g_object_unref0 (_data_->_tmp22_);
	}
	_data_->_tmp24_ = _data_->event_ids;
	_data_->_tmp24__length1 = _data_->event_ids_length1;
	_data_->result_length1 = _data_->_tmp24__length1;
	_data_->result = _data_->_tmp24_;
	_g_ptr_array_unref0 (_data_->events);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_delete_events_data_free (gpointer _data)
{
	ZeitgeistDaemonDeleteEventsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonDeleteEventsData, _data_);
}

static void
zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base,
                                     guint32* event_ids,
                                     gint event_ids_length1,
                                     GCancellable* cancellable,
                                     const char* sender,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonDeleteEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GCancellable* _tmp1_;
	char* _tmp2_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonDeleteEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_delete_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->event_ids = event_ids;
	_data_->event_ids_length1 = event_ids_length1;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	_tmp2_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp2_;
	zeitgeist_daemon_real_delete_events_co (_data_);
}

static GVariant*
zeitgeist_daemon_delete_events_finish (ZeitgeistRemoteLog* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GVariant* result;
	ZeitgeistDaemonDeleteEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
zeitgeist_daemon_real_delete_events_co (ZeitgeistDaemonDeleteEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = zeitgeist_engine_delete_events (_data_->_tmp0_, _data_->event_ids, (gint) _data_->event_ids_length1, _data_->sender, &_data_->_inner_error0_);
	_data_->time_range = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->time_range;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->notifications;
		_data_->_tmp4_ = _data_->time_range;
		zeitgeist_monitor_manager_notify_delete (_data_->_tmp3_, _data_->_tmp4_, _data_->event_ids, (gint) _data_->event_ids_length1);
	} else {
		_data_->_tmp5_ = zeitgeist_time_range_new ((gint64) -1, (gint64) -1);
		_g_object_unref0 (_data_->time_range);
		_data_->time_range = _data_->_tmp5_;
	}
	_data_->_tmp6_ = _data_->time_range;
	_data_->_tmp7_ = zeitgeist_time_range_to_variant (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	_g_object_unref0 (_data_->time_range);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_quit_data_free (gpointer _data)
{
	ZeitgeistDaemonQuitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonQuitData, _data_);
}

static void
zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonQuitData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GCancellable* _tmp1_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonQuitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_quit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	zeitgeist_daemon_real_quit_co (_data_);
}

static void
zeitgeist_daemon_quit_finish (ZeitgeistRemoteLog* base,
                              GAsyncResult* _res_,
                              GError** error)
{
	ZeitgeistDaemonQuitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
zeitgeist_daemon_real_quit_co (ZeitgeistDaemonQuitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	zeitgeist_daemon_do_quit (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_do_quit (ZeitgeistDaemon* self)
{
	ZeitgeistEngine* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	zeitgeist_db_reader_close ((ZeitgeistDbReader*) _tmp0_);
	_tmp1_ = zeitgeist_daemon_mainloop;
	g_main_loop_quit (_tmp1_);
}

static void
zeitgeist_daemon_real_install_monitor_data_free (gpointer _data)
{
	ZeitgeistDaemonInstallMonitorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->monitor_path);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_free0 (_data_->owner);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonInstallMonitorData, _data_);
}

static void
zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base,
                                       const char* monitor_path,
                                       GVariant* time_range,
                                       GVariant* event_templates,
                                       const char* owner,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonInstallMonitorData* _data_;
	ZeitgeistDaemon* _tmp0_;
	char* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	char* _tmp4_;
	g_return_if_fail (monitor_path != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonInstallMonitorData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_install_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (monitor_path);
	_g_free0 (_data_->monitor_path);
	_data_->monitor_path = _tmp1_;
	_tmp2_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_variant_ref0 (event_templates);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp3_;
	_tmp4_ = g_strdup (owner);
	_g_free0 (_data_->owner);
	_data_->owner = _tmp4_;
	zeitgeist_daemon_real_install_monitor_co (_data_);
}

static void
zeitgeist_daemon_install_monitor_finish (ZeitgeistRemoteLog* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	ZeitgeistDaemonInstallMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
zeitgeist_daemon_real_install_monitor_co (ZeitgeistDaemonInstallMonitorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_vala_assert (_data_->owner != NULL, "owner != null");
	_data_->_tmp1_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->notifications;
	zeitgeist_monitor_manager_install_monitor (_data_->_tmp4_, _data_->owner, (const gchar*) _data_->monitor_path, _data_->_tmp0_, _data_->_tmp2_);
	_g_ptr_array_unref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_daemon_real_remove_monitor_data_free (gpointer _data)
{
	ZeitgeistDaemonRemoveMonitorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->monitor_path);
	_g_free0 (_data_->owner);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonRemoveMonitorData, _data_);
}

static void
zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base,
                                      const char* monitor_path,
                                      const char* owner,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ZeitgeistDaemon * self;
	ZeitgeistDaemonRemoveMonitorData* _data_;
	ZeitgeistDaemon* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (monitor_path != NULL);
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonRemoveMonitorData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_remove_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (monitor_path);
	_g_free0 (_data_->monitor_path);
	_data_->monitor_path = _tmp1_;
	_tmp2_ = g_strdup (owner);
	_g_free0 (_data_->owner);
	_data_->owner = _tmp2_;
	zeitgeist_daemon_real_remove_monitor_co (_data_);
}

static void
zeitgeist_daemon_remove_monitor_finish (ZeitgeistRemoteLog* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ZeitgeistDaemonRemoveMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
zeitgeist_daemon_real_remove_monitor_co (ZeitgeistDaemonRemoveMonitorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_vala_assert (_data_->owner != NULL, "owner != null");
	_data_->_tmp0_ = _data_->self->priv->notifications;
	zeitgeist_monitor_manager_remove_monitor (_data_->_tmp0_, _data_->owner, (const gchar*) _data_->monitor_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self,
                                       GDBusConnection* conn,
                                       GError** error)
{
	guint _tmp0_ = 0U;
	guint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	self->priv->connection = conn;
	_tmp1_ = zeitgeist_remote_log_register_object ((ZeitgeistRemoteLog*) self, conn, ZEITGEIST_UTILS_ENGINE_DBUS_PATH, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->log_register_id = _tmp0_;
}

void
zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->log_register_id != ((guint) 0)) {
		GDBusConnection* _tmp0_;
		_tmp0_ = self->priv->connection;
		g_dbus_connection_unregister_object (_tmp0_, self->priv->log_register_id);
		self->priv->log_register_id = (guint) 0;
	}
}

static gboolean
zeitgeist_daemon_quit_running_instance (GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (conn != NULL, FALSE);
	{
		ZeitgeistRemoteLog* running_instance = NULL;
		ZeitgeistRemoteLog* _tmp0_;
		_tmp0_ = (ZeitgeistRemoteLog*) g_initable_new (ZEITGEIST_TYPE_REMOTE_LOG_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-connection", conn, "g-object-path", ZEITGEIST_UTILS_ENGINE_DBUS_PATH, "g-interface-name", "org.gnome.zeitgeist.Log", NULL);
		running_instance = (ZeitgeistRemoteLog*) _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		zeitgeist_remote_log_quit (running_instance, NULL, NULL, NULL);
		result = TRUE;
		_g_object_unref0 (running_instance);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("zeitgeist-daemon.vala:314: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static void
zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (conn != NULL);
	zeitgeist_daemon_name_acquired = TRUE;
	if (!zeitgeist_daemon_no_datahub) {
		{
			g_spawn_command_line_async ("zeitgeist-datahub", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* err = NULL;
			GError* _tmp0_;
			const gchar* _tmp1_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp0_ = err;
			_tmp1_ = _tmp0_->message;
			g_warning ("zeitgeist-daemon.vala:333: %s", _tmp1_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gboolean
____lambda4_ (void)
{
	gboolean result;
	if (!zeitgeist_daemon_name_acquired) {
		GMainLoop* _tmp0_;
		g_warning ("zeitgeist-daemon.vala:360: Timeout reached, unable to acquire name!");
		_tmp0_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp0_);
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda4_ ();
	return result;
}

static void
zeitgeist_daemon_name_lost_callback (GDBusConnection* conn)
{
	if (conn == NULL) {
		GMainLoop* _tmp0_;
		_tmp0_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp0_);
	} else {
		gboolean _tmp1_ = FALSE;
		ZeitgeistDaemon* _tmp2_;
		_tmp2_ = zeitgeist_daemon_instance;
		if (_tmp2_ != NULL) {
			_tmp1_ = !zeitgeist_daemon_name_acquired;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			if (!zeitgeist_daemon_replace_mode) {
			}
			g_debug ("zeitgeist-daemon.vala:352: Waiting 10 seconds to acquire name...");
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10000, _____lambda4__gsource_func, NULL, NULL);
		} else {
			gboolean _tmp3_ = FALSE;
			ZeitgeistDaemon* _tmp4_;
			_tmp4_ = zeitgeist_daemon_instance;
			if (_tmp4_ != NULL) {
				_tmp3_ = zeitgeist_daemon_name_acquired;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				GMainLoop* _tmp5_;
				_tmp5_ = zeitgeist_daemon_mainloop;
				g_main_loop_quit (_tmp5_);
			}
		}
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
_zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
	zeitgeist_daemon_name_acquired_callback (connection);
}

static void
_zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	zeitgeist_daemon_name_lost_callback (connection);
}

static void
zeitgeist_daemon_run (GError** error)
{
	GDBusConnection* connection = NULL;
	gboolean name_owned = FALSE;
	guint owner_id = 0U;
	GDBusConnection* _tmp22_;
	GMainLoop* _tmp23_;
	GMainLoop* _tmp24_;
	ZeitgeistDaemon* _tmp25_;
	GError* _inner_error0_ = NULL;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		ZeitgeistRemoteDBus* proxy = NULL;
		GDBusConnection* _tmp3_;
		ZeitgeistRemoteDBus* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ZeitgeistRemoteDBus* _tmp6_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (connection);
		connection = _tmp2_;
		_tmp3_ = connection;
		_tmp4_ = (ZeitgeistRemoteDBus*) g_initable_new (ZEITGEIST_TYPE_REMOTE_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.DBus", "g-connection", _tmp3_, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		proxy = (ZeitgeistRemoteDBus*) _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = proxy;
		_tmp5_ = zeitgeist_remote_dbus_name_has_owner (_tmp6_, ZEITGEIST_UTILS_ENGINE_DBUS_NAME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (proxy);
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		name_owned = _tmp5_;
		_g_object_unref0 (proxy);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error0_ = _tmp8_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (connection);
		return;
	}
	if (name_owned) {
		gboolean _tmp9_ = FALSE;
		if (zeitgeist_daemon_replace_mode) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = zeitgeist_daemon_quit_daemon;
		}
		if (_tmp9_) {
			GDBusConnection* _tmp10_;
			_tmp10_ = connection;
			zeitgeist_daemon_quit_running_instance (_tmp10_);
		} else {
			GError* _tmp11_;
			g_warning ("zeitgeist-daemon.vala:398: %s", "An existing instance was found. Please use " "--replace to stop it and start a new instance.");
			_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE, "Zeitgeist is running already.");
			_inner_error0_ = _tmp11_;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (connection);
			return;
		}
	}
	if (zeitgeist_daemon_quit_daemon) {
		_g_object_unref0 (connection);
		return;
	}
	{
		ZeitgeistDaemon* _tmp12_ = NULL;
		ZeitgeistDaemon* _tmp13_;
		ZeitgeistDaemon* _tmp14_;
		ZeitgeistDaemon* _tmp15_;
		GDBusConnection* _tmp16_;
		_tmp13_ = zeitgeist_daemon_new (&_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = _tmp14_;
		_tmp15_ = zeitgeist_daemon_instance;
		_tmp16_ = connection;
		zeitgeist_daemon_register_dbus_object (_tmp15_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp12_);
			goto __catch1_g_error;
		}
		_g_object_unref0 (_tmp12_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		GError* _tmp20_;
		GError* _tmp21_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = err;
		if (g_error_matches (_tmp17_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			const gchar* _tmp18_;
			_tmp18_ = zeitgeist_utils_get_database_file_path ();
			g_warning ("Could not access the database file.\n" "Please check the permissions of file %s.", _tmp18_);
		} else {
			GError* _tmp19_;
			_tmp19_ = err;
			if (g_error_matches (_tmp19_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
				g_warning ("zeitgeist-daemon.vala:424: %s", "It looks like another Zeitgeist instance " "is already running (the database is locked). " "If you want to start a new instance, use --replace.");
			}
		}
		_tmp20_ = err;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error0_ = _tmp21_;
		_g_error_free0 (err);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp22_ = connection;
	owner_id = g_bus_own_name_on_connection_with_closures (_tmp22_, ZEITGEIST_UTILS_ENGINE_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback, NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
	_tmp23_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (zeitgeist_daemon_mainloop);
	zeitgeist_daemon_mainloop = _tmp23_;
	_tmp24_ = zeitgeist_daemon_mainloop;
	g_main_loop_run (_tmp24_);
	_tmp25_ = zeitgeist_daemon_instance;
	if (_tmp25_ != NULL) {
		ZeitgeistDaemon* _tmp26_;
		g_bus_unown_name (owner_id);
		_tmp26_ = zeitgeist_daemon_instance;
		zeitgeist_daemon_unregister_dbus_object (_tmp26_);
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = NULL;
		{
			GDBusConnection* _tmp27_;
			_tmp27_ = connection;
			g_dbus_connection_flush_sync (_tmp27_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_warning ("zeitgeist-daemon.vala:453: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (connection);
			return;
		}
	}
	_g_object_unref0 (connection);
}

static void
zeitgeist_daemon_safe_exit (void)
{
	ZeitgeistDaemon* _tmp0_;
	_tmp0_ = zeitgeist_daemon_instance;
	zeitgeist_daemon_do_quit (_tmp0_);
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gint
zeitgeist_daemon_vacuum (void)
{
	sqlite3* database = NULL;
	const gchar* db_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint rc = 0;
	const gchar* _tmp2_;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	sqlite3* _tmp10_;
	FILE* _tmp14_;
	gint result;
	if (zeitgeist_utils_using_in_memory_database ()) {
		g_warning ("zeitgeist-daemon.vala:468: Using in-memory database, no VACUUM needed");
	}
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	db_path = _tmp0_;
	_tmp1_ = db_path;
	g_debug ("zeitgeist-daemon.vala:471: Opening database file at %s", _tmp1_);
	_tmp2_ = db_path;
	_tmp4_ = sqlite3_open_v2 (_tmp2_, &_tmp3_, SQLITE_OPEN_READWRITE, NULL);
	_sqlite3_close0 (database);
	database = _tmp3_;
	rc = _tmp4_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp5_;
		sqlite3* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = db_path;
		_tmp6_ = database;
		_tmp7_ = sqlite3_errmsg (_tmp6_);
		g_warning ("zeitgeist-daemon.vala:476: Failed to open database \"%s\" (%s)", _tmp5_, _tmp7_);
		result = rc;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Performing VACUUM operation... ");
	_tmp9_ = stdout;
	fflush (_tmp9_);
	_tmp10_ = database;
	rc = _sqlite3_exec (_tmp10_, "VACUUM", NULL, NULL, NULL);
	if (rc != SQLITE_OK) {
		FILE* _tmp11_;
		sqlite3* _tmp12_;
		const gchar* _tmp13_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "FAIL\n");
		_tmp12_ = database;
		_tmp13_ = sqlite3_errmsg (_tmp12_);
		g_warning ("zeitgeist-daemon.vala:486: %s", _tmp13_);
		result = rc;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp14_ = stdout;
	fprintf (_tmp14_, "OK\n");
	result = 0;
	_sqlite3_close0 (database);
	return result;
}

static void
_zeitgeist_daemon_safe_exit_sighandler_t (gint signal)
{
	zeitgeist_daemon_safe_exit ();
}

static gint
zeitgeist_daemon_main (gchar** args,
                       gint args_length1)
{
	GOptionContext* opt_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result;
	signal (SIGHUP, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGINT, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGTERM, _zeitgeist_daemon_safe_exit_sighandler_t);
	setlocale (LC_ALL, "");
	_tmp0_ = g_option_context_new (" - Zeitgeist daemon");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	g_option_context_add_main_entries (_tmp1_, ZEITGEIST_DAEMON_options, NULL);
	{
		GOptionContext* _tmp2_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp2_ = opt_context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (zeitgeist_daemon_show_version_info) {
			FILE* _tmp3_;
			_tmp3_ = stdout;
			fprintf (_tmp3_, "%s", VERSION "\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		if (zeitgeist_daemon_show_options) {
			FILE* _tmp12_;
			{
				GOptionEntry* entry_collection = NULL;
				gint entry_collection_length1 = 0;
				gint _entry_collection_size_ = 0;
				gint entry_it = 0;
				entry_collection = ZEITGEIST_DAEMON_options;
				entry_collection_length1 = G_N_ELEMENTS (ZEITGEIST_DAEMON_options);
				for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
					GOptionEntry* entry = NULL;
					entry = &entry_collection[entry_it];
					{
						GOptionEntry* _tmp4_;
						const gchar* _tmp5_;
						GOptionEntry* _tmp9_;
						_tmp4_ = entry;
						_tmp5_ = (*_tmp4_).long_name;
						if (_tmp5_ != NULL) {
							FILE* _tmp6_;
							GOptionEntry* _tmp7_;
							const gchar* _tmp8_;
							_tmp6_ = stdout;
							_tmp7_ = entry;
							_tmp8_ = (*_tmp7_).long_name;
							fprintf (_tmp6_, "--%s ", _tmp8_);
						}
						_tmp9_ = entry;
						if (((gint) (*_tmp9_).short_name) != 0) {
							FILE* _tmp10_;
							GOptionEntry* _tmp11_;
							_tmp10_ = stdout;
							_tmp11_ = entry;
							fprintf (_tmp10_, "-%c ", (gint) (*_tmp11_).short_name);
						}
					}
				}
			}
			_tmp12_ = stdout;
			fprintf (_tmp12_, "--help\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		if (zeitgeist_daemon_perform_vacuum) {
			result = zeitgeist_daemon_vacuum ();
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp13_ = zeitgeist_daemon_log_level;
		_tmp14_ = zeitgeist_daemon_log_file;
		zeitgeist_logging_setup_logging (_tmp13_, _tmp14_);
		zeitgeist_daemon_run (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		GError* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		if (g_error_matches (_tmp15_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE)) {
			result = 10;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp16_ = err;
		if (g_error_matches (_tmp16_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			result = 21;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp17_ = err;
		if (g_error_matches (_tmp17_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
			result = 22;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp18_ = err;
		_tmp19_ = _tmp18_->message;
		g_warning ("zeitgeist-daemon.vala:546: %s", _tmp19_);
		result = 1;
		_g_error_free0 (err);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp20_ = -1;
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp20_;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return zeitgeist_daemon_main (argv, argc);
}

static gchar**
zeitgeist_daemon_real_get_extensions (ZeitgeistRemoteLog* base,
                                      gint* result_length1)
{
	gchar** result;
	ZeitgeistDaemon* self;
	gchar** ext = NULL;
	ZeitgeistEngine* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint ext_length1;
	gint _ext_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (ZeitgeistDaemon*) base;
	_tmp0_ = self->priv->engine;
	_tmp2_ = zeitgeist_engine_get_extension_names (_tmp0_, &_tmp1_);
	ext = _tmp2_;
	ext_length1 = _tmp1_;
	_ext_size_ = ext_length1;
	_tmp3_ = ext;
	_tmp3__length1 = ext_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
zeitgeist_daemon_real_get_version (ZeitgeistRemoteLog* base,
                                   ZeitgeistVersionStruct * result)
{
	ZeitgeistDaemon* self;
	ZeitgeistVersionStruct s = {0};
	gchar** ver = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint ver_length1;
	gint _ver_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (ZeitgeistDaemon*) base;
	memset (&s, 0, sizeof (ZeitgeistVersionStruct));
	_tmp1_ = _tmp0_ = g_strsplit (VERSION, ".", 0);
	ver = _tmp1_;
	ver_length1 = _vala_array_length (_tmp0_);
	_ver_size_ = ver_length1;
	_tmp2_ = ver;
	_tmp2__length1 = ver_length1;
	if (_tmp2__length1 >= 1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gint _tmp9_ = 0;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp3_ = ver;
		_tmp3__length1 = ver_length1;
		_tmp4_ = _tmp3_[0];
		s.major = atoi (_tmp4_);
		_tmp6_ = ver;
		_tmp6__length1 = ver_length1;
		if (_tmp6__length1 >= 2) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = ver;
			_tmp7__length1 = ver_length1;
			_tmp8_ = _tmp7_[1];
			_tmp5_ = atoi (_tmp8_);
		} else {
			_tmp5_ = 0;
		}
		s.minor = _tmp5_;
		_tmp10_ = ver;
		_tmp10__length1 = ver_length1;
		if (_tmp10__length1 >= 3) {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			_tmp11_ = ver;
			_tmp11__length1 = ver_length1;
			_tmp12_ = _tmp11_[2];
			_tmp9_ = atoi (_tmp12_);
		} else {
			_tmp9_ = 0;
		}
		s.micro = _tmp9_;
	} else {
		g_warning ("zeitgeist-daemon.vala:125: Unable to parse version info `%s`!", VERSION);
		s.major = 1;
		s.minor = 0;
		s.micro = 0;
	}
	*result = s;
	ver = (_vala_array_free (ver, ver_length1, (GDestroyNotify) g_free), NULL);
	return;
}

static gchar*
zeitgeist_daemon_real_get_datapath (ZeitgeistRemoteLog* base)
{
	gchar* result;
	ZeitgeistDaemon* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ZeitgeistDaemon*) base;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
zeitgeist_daemon_class_init (ZeitgeistDaemonClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	zeitgeist_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistDaemon_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_daemon_get_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_daemon_finalize;
	_tmp0_ = g_strdup ("");
	zeitgeist_daemon_log_level = _tmp0_;
}

static void
zeitgeist_daemon_zeitgeist_remote_log_interface_init (ZeitgeistRemoteLogIface * iface,
                                                      gpointer iface_data)
{
	zeitgeist_daemon_zeitgeist_remote_log_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_events = (void (*) (ZeitgeistRemoteLog*, guint32*, gint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_get_events;
	iface->get_events_finish = (GVariant* (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_get_events_finish;
	iface->find_related_uris = (void (*) (ZeitgeistRemoteLog*, GVariant*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_related_uris;
	iface->find_related_uris_finish = (gchar** (*) (ZeitgeistRemoteLog*, GAsyncResult*, gint*, GError**)) zeitgeist_daemon_find_related_uris_finish;
	iface->find_event_ids = (void (*) (ZeitgeistRemoteLog*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_event_ids;
	iface->find_event_ids_finish = (guint32* (*) (ZeitgeistRemoteLog*, GAsyncResult*, gint*, GError**)) zeitgeist_daemon_find_event_ids_finish;
	iface->find_events = (void (*) (ZeitgeistRemoteLog*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_events;
	iface->find_events_finish = (GVariant* (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_find_events_finish;
	iface->insert_events = (void (*) (ZeitgeistRemoteLog*, GVariant*, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_insert_events;
	iface->insert_events_finish = (guint32* (*) (ZeitgeistRemoteLog*, GAsyncResult*, gint*, GError**)) zeitgeist_daemon_insert_events_finish;
	iface->delete_events = (void (*) (ZeitgeistRemoteLog*, guint32*, gint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_delete_events;
	iface->delete_events_finish = (GVariant* (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_delete_events_finish;
	iface->quit = (void (*) (ZeitgeistRemoteLog*, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_quit;
	iface->quit_finish = (void (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_quit_finish;
	iface->install_monitor = (void (*) (ZeitgeistRemoteLog*, const char*, GVariant*, GVariant*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_install_monitor;
	iface->install_monitor_finish = (void (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_install_monitor_finish;
	iface->remove_monitor = (void (*) (ZeitgeistRemoteLog*, const char*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_remove_monitor;
	iface->remove_monitor_finish = (void (*) (ZeitgeistRemoteLog*, GAsyncResult*, GError**)) zeitgeist_daemon_remove_monitor_finish;
	iface->get_extensions = zeitgeist_daemon_real_get_extensions;
	iface->get_version = zeitgeist_daemon_real_get_version;
	iface->get_datapath = zeitgeist_daemon_real_get_datapath;
}

static void
zeitgeist_daemon_instance_init (ZeitgeistDaemon * self,
                                gpointer klass)
{
	ZeitgeistRegisterExtensionFunc* _tmp0_;
	self->priv = zeitgeist_daemon_get_instance_private (self);
	_tmp0_ = g_new0 (ZeitgeistRegisterExtensionFunc, 0);
	self->priv->builtins = _tmp0_;
	self->priv->builtins_length1 = 0;
	self->priv->_builtins_size_ = self->priv->builtins_length1;
}

static void
zeitgeist_daemon_finalize (GObject * obj)
{
	ZeitgeistDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon);
	self->priv->builtins = (g_free (self->priv->builtins), NULL);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (zeitgeist_daemon_parent_class)->finalize (obj);
}

static GType
zeitgeist_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDaemon), 0, (GInstanceInitFunc) zeitgeist_daemon_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_log_info = { (GInterfaceInitFunc) zeitgeist_daemon_zeitgeist_remote_log_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType zeitgeist_daemon_type_id;
	zeitgeist_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDaemon", &g_define_type_info, 0);
	g_type_add_interface_static (zeitgeist_daemon_type_id, ZEITGEIST_TYPE_REMOTE_LOG, &zeitgeist_remote_log_info);
	ZeitgeistDaemon_private_offset = g_type_add_instance_private (zeitgeist_daemon_type_id, sizeof (ZeitgeistDaemonPrivate));
	return zeitgeist_daemon_type_id;
}

GType
zeitgeist_daemon_get_type (void)
{
	static volatile gsize zeitgeist_daemon_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_daemon_type_id__once)) {
		GType zeitgeist_daemon_type_id;
		zeitgeist_daemon_type_id = zeitgeist_daemon_get_type_once ();
		g_once_init_leave (&zeitgeist_daemon_type_id__once, zeitgeist_daemon_type_id);
	}
	return zeitgeist_daemon_type_id__once;
}

static void
_vala_zeitgeist_daemon_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ZeitgeistDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

