#include "livekit/video_frame_buffer.h"
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

namespace {
template <bool> struct deleter_if {
  template <typename T> void operator()(T *) {}
};
template <> struct deleter_if<true> {
  template <typename T> void operator()(T *ptr) { ptr->~T(); }
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

namespace livekit {
  enum class VideoFrameBufferType : ::std::int32_t;
  using VideoFrameBuffer = ::livekit::VideoFrameBuffer;
  using PlanarYuvBuffer = ::livekit::PlanarYuvBuffer;
  using PlanarYuv8Buffer = ::livekit::PlanarYuv8Buffer;
  using PlanarYuv16BBuffer = ::livekit::PlanarYuv16BBuffer;
  using BiplanarYuvBuffer = ::livekit::BiplanarYuvBuffer;
  using BiplanarYuv8Buffer = ::livekit::BiplanarYuv8Buffer;
  using I420Buffer = ::livekit::I420Buffer;
  using I420ABuffer = ::livekit::I420ABuffer;
  using I422Buffer = ::livekit::I422Buffer;
  using I444Buffer = ::livekit::I444Buffer;
  using I010Buffer = ::livekit::I010Buffer;
  using NV12Buffer = ::livekit::NV12Buffer;
  using PlatformImageBuffer = ::livekit::PlatformImageBuffer;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType
#define CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType
enum class VideoFrameBufferType : ::std::int32_t {
  Native = 0,
  I420 = 1,
  I420A = 2,
  I422 = 3,
  I444 = 4,
  I010 = 5,
  NV12 = 6,
};
#endif // CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType

extern "C" {
::livekit::VideoFrameBufferType livekit$cxxbridge1$VideoFrameBuffer$buffer_type(::livekit::VideoFrameBuffer const &self) noexcept {
  ::livekit::VideoFrameBufferType (::livekit::VideoFrameBuffer::*buffer_type$)() const = &::livekit::VideoFrameBuffer::buffer_type;
  return (self.*buffer_type$)();
}

::std::uint32_t livekit$cxxbridge1$VideoFrameBuffer$width(::livekit::VideoFrameBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrameBuffer::*width$)() const = &::livekit::VideoFrameBuffer::width;
  return (self.*width$)();
}

::std::uint32_t livekit$cxxbridge1$VideoFrameBuffer$height(::livekit::VideoFrameBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrameBuffer::*height$)() const = &::livekit::VideoFrameBuffer::height;
  return (self.*height$)();
}

::livekit::I420Buffer *livekit$cxxbridge1$VideoFrameBuffer$to_i420(::livekit::VideoFrameBuffer const &self) noexcept {
  ::std::unique_ptr<::livekit::I420Buffer> (::livekit::VideoFrameBuffer::*to_i420$)() const = &::livekit::VideoFrameBuffer::to_i420;
  return (self.*to_i420$)().release();
}

::livekit::I420Buffer *livekit$cxxbridge1$VideoFrameBuffer$get_i420(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::I420Buffer> (::livekit::VideoFrameBuffer::*get_i420$)() = &::livekit::VideoFrameBuffer::get_i420;
  return (self.*get_i420$)().release();
}

::livekit::I420ABuffer *livekit$cxxbridge1$VideoFrameBuffer$get_i420a(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::I420ABuffer> (::livekit::VideoFrameBuffer::*get_i420a$)() = &::livekit::VideoFrameBuffer::get_i420a;
  return (self.*get_i420a$)().release();
}

::livekit::I422Buffer *livekit$cxxbridge1$VideoFrameBuffer$get_i422(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::I422Buffer> (::livekit::VideoFrameBuffer::*get_i422$)() = &::livekit::VideoFrameBuffer::get_i422;
  return (self.*get_i422$)().release();
}

::livekit::I444Buffer *livekit$cxxbridge1$VideoFrameBuffer$get_i444(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::I444Buffer> (::livekit::VideoFrameBuffer::*get_i444$)() = &::livekit::VideoFrameBuffer::get_i444;
  return (self.*get_i444$)().release();
}

::livekit::I010Buffer *livekit$cxxbridge1$VideoFrameBuffer$get_i010(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::I010Buffer> (::livekit::VideoFrameBuffer::*get_i010$)() = &::livekit::VideoFrameBuffer::get_i010;
  return (self.*get_i010$)().release();
}

::livekit::NV12Buffer *livekit$cxxbridge1$VideoFrameBuffer$get_nv12(::livekit::VideoFrameBuffer &self) noexcept {
  ::std::unique_ptr<::livekit::NV12Buffer> (::livekit::VideoFrameBuffer::*get_nv12$)() = &::livekit::VideoFrameBuffer::get_nv12;
  return (self.*get_nv12$)().release();
}

::std::uint32_t livekit$cxxbridge1$PlanarYuvBuffer$chroma_width(::livekit::PlanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::PlanarYuvBuffer::*chroma_width$)() const = &::livekit::PlanarYuvBuffer::chroma_width;
  return (self.*chroma_width$)();
}

::std::uint32_t livekit$cxxbridge1$PlanarYuvBuffer$chroma_height(::livekit::PlanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::PlanarYuvBuffer::*chroma_height$)() const = &::livekit::PlanarYuvBuffer::chroma_height;
  return (self.*chroma_height$)();
}

::std::uint32_t livekit$cxxbridge1$PlanarYuvBuffer$stride_y(::livekit::PlanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::PlanarYuvBuffer::*stride_y$)() const = &::livekit::PlanarYuvBuffer::stride_y;
  return (self.*stride_y$)();
}

::std::uint32_t livekit$cxxbridge1$PlanarYuvBuffer$stride_u(::livekit::PlanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::PlanarYuvBuffer::*stride_u$)() const = &::livekit::PlanarYuvBuffer::stride_u;
  return (self.*stride_u$)();
}

::std::uint32_t livekit$cxxbridge1$PlanarYuvBuffer$stride_v(::livekit::PlanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::PlanarYuvBuffer::*stride_v$)() const = &::livekit::PlanarYuvBuffer::stride_v;
  return (self.*stride_v$)();
}

::std::uint8_t const *livekit$cxxbridge1$PlanarYuv8Buffer$data_y(::livekit::PlanarYuv8Buffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::PlanarYuv8Buffer::*data_y$)() const = &::livekit::PlanarYuv8Buffer::data_y;
  return (self.*data_y$)();
}

::std::uint8_t const *livekit$cxxbridge1$PlanarYuv8Buffer$data_u(::livekit::PlanarYuv8Buffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::PlanarYuv8Buffer::*data_u$)() const = &::livekit::PlanarYuv8Buffer::data_u;
  return (self.*data_u$)();
}

::std::uint8_t const *livekit$cxxbridge1$PlanarYuv8Buffer$data_v(::livekit::PlanarYuv8Buffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::PlanarYuv8Buffer::*data_v$)() const = &::livekit::PlanarYuv8Buffer::data_v;
  return (self.*data_v$)();
}

::std::uint16_t const *livekit$cxxbridge1$PlanarYuv16BBuffer$data_y(::livekit::PlanarYuv16BBuffer const &self) noexcept {
  ::std::uint16_t const *(::livekit::PlanarYuv16BBuffer::*data_y$)() const = &::livekit::PlanarYuv16BBuffer::data_y;
  return (self.*data_y$)();
}

::std::uint16_t const *livekit$cxxbridge1$PlanarYuv16BBuffer$data_u(::livekit::PlanarYuv16BBuffer const &self) noexcept {
  ::std::uint16_t const *(::livekit::PlanarYuv16BBuffer::*data_u$)() const = &::livekit::PlanarYuv16BBuffer::data_u;
  return (self.*data_u$)();
}

::std::uint16_t const *livekit$cxxbridge1$PlanarYuv16BBuffer$data_v(::livekit::PlanarYuv16BBuffer const &self) noexcept {
  ::std::uint16_t const *(::livekit::PlanarYuv16BBuffer::*data_v$)() const = &::livekit::PlanarYuv16BBuffer::data_v;
  return (self.*data_v$)();
}

::std::uint32_t livekit$cxxbridge1$BiplanarYuvBuffer$chroma_width(::livekit::BiplanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::BiplanarYuvBuffer::*chroma_width$)() const = &::livekit::BiplanarYuvBuffer::chroma_width;
  return (self.*chroma_width$)();
}

::std::uint32_t livekit$cxxbridge1$BiplanarYuvBuffer$chroma_height(::livekit::BiplanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::BiplanarYuvBuffer::*chroma_height$)() const = &::livekit::BiplanarYuvBuffer::chroma_height;
  return (self.*chroma_height$)();
}

::std::uint32_t livekit$cxxbridge1$BiplanarYuvBuffer$stride_y(::livekit::BiplanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::BiplanarYuvBuffer::*stride_y$)() const = &::livekit::BiplanarYuvBuffer::stride_y;
  return (self.*stride_y$)();
}

::std::uint32_t livekit$cxxbridge1$BiplanarYuvBuffer$stride_uv(::livekit::BiplanarYuvBuffer const &self) noexcept {
  ::std::uint32_t (::livekit::BiplanarYuvBuffer::*stride_uv$)() const = &::livekit::BiplanarYuvBuffer::stride_uv;
  return (self.*stride_uv$)();
}

::std::uint8_t const *livekit$cxxbridge1$BiplanarYuv8Buffer$data_y(::livekit::BiplanarYuv8Buffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::BiplanarYuv8Buffer::*data_y$)() const = &::livekit::BiplanarYuv8Buffer::data_y;
  return (self.*data_y$)();
}

::std::uint8_t const *livekit$cxxbridge1$BiplanarYuv8Buffer$data_uv(::livekit::BiplanarYuv8Buffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::BiplanarYuv8Buffer::*data_uv$)() const = &::livekit::BiplanarYuv8Buffer::data_uv;
  return (self.*data_uv$)();
}

::std::uint32_t livekit$cxxbridge1$I420ABuffer$stride_a(::livekit::I420ABuffer const &self) noexcept {
  ::std::uint32_t (::livekit::I420ABuffer::*stride_a$)() const = &::livekit::I420ABuffer::stride_a;
  return (self.*stride_a$)();
}

::std::uint8_t const *livekit$cxxbridge1$I420ABuffer$data_a(::livekit::I420ABuffer const &self) noexcept {
  ::std::uint8_t const *(::livekit::I420ABuffer::*data_a$)() const = &::livekit::I420ABuffer::data_a;
  return (self.*data_a$)();
}

::livekit::I420Buffer *livekit$cxxbridge1$copy_i420_buffer(::std::unique_ptr<::livekit::I420Buffer> const &i420) noexcept {
  ::std::unique_ptr<::livekit::I420Buffer> (*copy_i420_buffer$)(::std::unique_ptr<::livekit::I420Buffer> const &) = ::livekit::copy_i420_buffer;
  return copy_i420_buffer$(i420).release();
}

::livekit::I420Buffer *livekit$cxxbridge1$new_i420_buffer(::std::int32_t width, ::std::int32_t height, ::std::int32_t stride_y, ::std::int32_t stride_u, ::std::int32_t stride_v) noexcept {
  ::std::unique_ptr<::livekit::I420Buffer> (*new_i420_buffer$)(::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t) = ::livekit::new_i420_buffer;
  return new_i420_buffer$(width, height, stride_y, stride_u, stride_v).release();
}

::livekit::I422Buffer *livekit$cxxbridge1$new_i422_buffer(::std::int32_t width, ::std::int32_t height, ::std::int32_t stride_y, ::std::int32_t stride_u, ::std::int32_t stride_v) noexcept {
  ::std::unique_ptr<::livekit::I422Buffer> (*new_i422_buffer$)(::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t) = ::livekit::new_i422_buffer;
  return new_i422_buffer$(width, height, stride_y, stride_u, stride_v).release();
}

::livekit::I444Buffer *livekit$cxxbridge1$new_i444_buffer(::std::int32_t width, ::std::int32_t height, ::std::int32_t stride_y, ::std::int32_t stride_u, ::std::int32_t stride_v) noexcept {
  ::std::unique_ptr<::livekit::I444Buffer> (*new_i444_buffer$)(::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t) = ::livekit::new_i444_buffer;
  return new_i444_buffer$(width, height, stride_y, stride_u, stride_v).release();
}

::livekit::I010Buffer *livekit$cxxbridge1$new_i010_buffer(::std::int32_t width, ::std::int32_t height, ::std::int32_t stride_y, ::std::int32_t stride_u, ::std::int32_t stride_v) noexcept {
  ::std::unique_ptr<::livekit::I010Buffer> (*new_i010_buffer$)(::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t) = ::livekit::new_i010_buffer;
  return new_i010_buffer$(width, height, stride_y, stride_u, stride_v).release();
}

::livekit::NV12Buffer *livekit$cxxbridge1$new_nv12_buffer(::std::int32_t width, ::std::int32_t height, ::std::int32_t stride_y, ::std::int32_t stride_uv) noexcept {
  ::std::unique_ptr<::livekit::NV12Buffer> (*new_nv12_buffer$)(::std::int32_t, ::std::int32_t, ::std::int32_t, ::std::int32_t) = ::livekit::new_nv12_buffer;
  return new_nv12_buffer$(width, height, stride_y, stride_uv).release();
}

::livekit::VideoFrameBuffer *livekit$cxxbridge1$new_native_buffer_from_platform_image_buffer(::livekit::PlatformImageBuffer *platform_native_buffer) noexcept {
  ::std::unique_ptr<::livekit::VideoFrameBuffer> (*new_native_buffer_from_platform_image_buffer$)(::livekit::PlatformImageBuffer *) = ::livekit::new_native_buffer_from_platform_image_buffer;
  return new_native_buffer_from_platform_image_buffer$(platform_native_buffer).release();
}

::livekit::PlatformImageBuffer *livekit$cxxbridge1$native_buffer_to_platform_image_buffer(::std::unique_ptr<::livekit::VideoFrameBuffer> const &buffer) noexcept {
  ::livekit::PlatformImageBuffer *(*native_buffer_to_platform_image_buffer$)(::std::unique_ptr<::livekit::VideoFrameBuffer> const &) = ::livekit::native_buffer_to_platform_image_buffer;
  return native_buffer_to_platform_image_buffer$(buffer);
}

::livekit::VideoFrameBuffer const *livekit$cxxbridge1$yuv_to_vfb(::livekit::PlanarYuvBuffer const *yuv) noexcept {
  ::livekit::VideoFrameBuffer const *(*yuv_to_vfb$)(::livekit::PlanarYuvBuffer const *) = ::livekit::yuv_to_vfb;
  return yuv_to_vfb$(yuv);
}

::livekit::VideoFrameBuffer const *livekit$cxxbridge1$biyuv_to_vfb(::livekit::BiplanarYuvBuffer const *yuv) noexcept {
  ::livekit::VideoFrameBuffer const *(*biyuv_to_vfb$)(::livekit::BiplanarYuvBuffer const *) = ::livekit::biyuv_to_vfb;
  return biyuv_to_vfb$(yuv);
}

::livekit::PlanarYuvBuffer const *livekit$cxxbridge1$yuv8_to_yuv(::livekit::PlanarYuv8Buffer const *yuv8) noexcept {
  ::livekit::PlanarYuvBuffer const *(*yuv8_to_yuv$)(::livekit::PlanarYuv8Buffer const *) = ::livekit::yuv8_to_yuv;
  return yuv8_to_yuv$(yuv8);
}

::livekit::PlanarYuvBuffer const *livekit$cxxbridge1$yuv16b_to_yuv(::livekit::PlanarYuv16BBuffer const *yuv16b) noexcept {
  ::livekit::PlanarYuvBuffer const *(*yuv16b_to_yuv$)(::livekit::PlanarYuv16BBuffer const *) = ::livekit::yuv16b_to_yuv;
  return yuv16b_to_yuv$(yuv16b);
}

::livekit::BiplanarYuvBuffer const *livekit$cxxbridge1$biyuv8_to_biyuv(::livekit::BiplanarYuv8Buffer const *biyuv8) noexcept {
  ::livekit::BiplanarYuvBuffer const *(*biyuv8_to_biyuv$)(::livekit::BiplanarYuv8Buffer const *) = ::livekit::biyuv8_to_biyuv;
  return biyuv8_to_biyuv$(biyuv8);
}

::livekit::PlanarYuv8Buffer const *livekit$cxxbridge1$i420_to_yuv8(::livekit::I420Buffer const *i420) noexcept {
  ::livekit::PlanarYuv8Buffer const *(*i420_to_yuv8$)(::livekit::I420Buffer const *) = ::livekit::i420_to_yuv8;
  return i420_to_yuv8$(i420);
}

::livekit::PlanarYuv8Buffer const *livekit$cxxbridge1$i420a_to_yuv8(::livekit::I420ABuffer const *i420a) noexcept {
  ::livekit::PlanarYuv8Buffer const *(*i420a_to_yuv8$)(::livekit::I420ABuffer const *) = ::livekit::i420a_to_yuv8;
  return i420a_to_yuv8$(i420a);
}

::livekit::PlanarYuv8Buffer const *livekit$cxxbridge1$i422_to_yuv8(::livekit::I422Buffer const *i422) noexcept {
  ::livekit::PlanarYuv8Buffer const *(*i422_to_yuv8$)(::livekit::I422Buffer const *) = ::livekit::i422_to_yuv8;
  return i422_to_yuv8$(i422);
}

::livekit::PlanarYuv8Buffer const *livekit$cxxbridge1$i444_to_yuv8(::livekit::I444Buffer const *i444) noexcept {
  ::livekit::PlanarYuv8Buffer const *(*i444_to_yuv8$)(::livekit::I444Buffer const *) = ::livekit::i444_to_yuv8;
  return i444_to_yuv8$(i444);
}

::livekit::PlanarYuv16BBuffer const *livekit$cxxbridge1$i010_to_yuv16b(::livekit::I010Buffer const *i010) noexcept {
  ::livekit::PlanarYuv16BBuffer const *(*i010_to_yuv16b$)(::livekit::I010Buffer const *) = ::livekit::i010_to_yuv16b;
  return i010_to_yuv16b$(i010);
}

::livekit::BiplanarYuv8Buffer const *livekit$cxxbridge1$nv12_to_biyuv8(::livekit::NV12Buffer const *nv12) noexcept {
  ::livekit::BiplanarYuv8Buffer const *(*nv12_to_biyuv8$)(::livekit::NV12Buffer const *) = ::livekit::nv12_to_biyuv8;
  return nv12_to_biyuv8$(nv12);
}

::livekit::VideoFrameBuffer *livekit$cxxbridge1$_unique_video_frame_buffer() noexcept {
  ::std::unique_ptr<::livekit::VideoFrameBuffer> (*_unique_video_frame_buffer$)() = ::livekit::_unique_video_frame_buffer;
  return _unique_video_frame_buffer$().release();
}
} // extern "C"
} // namespace livekit

extern "C" {
static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::I420Buffer>::type>::value, "definition of `::livekit::I420Buffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::I420Buffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::I420Buffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$I420Buffer$null(::std::unique_ptr<::livekit::I420Buffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I420Buffer>();
}
void cxxbridge1$unique_ptr$livekit$I420Buffer$raw(::std::unique_ptr<::livekit::I420Buffer> *ptr, ::std::unique_ptr<::livekit::I420Buffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I420Buffer>(raw);
}
::std::unique_ptr<::livekit::I420Buffer>::element_type const *cxxbridge1$unique_ptr$livekit$I420Buffer$get(::std::unique_ptr<::livekit::I420Buffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::I420Buffer>::pointer cxxbridge1$unique_ptr$livekit$I420Buffer$release(::std::unique_ptr<::livekit::I420Buffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$I420Buffer$drop(::std::unique_ptr<::livekit::I420Buffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::I420Buffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::I420ABuffer>::type>::value, "definition of `::livekit::I420ABuffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::I420ABuffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::I420ABuffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$I420ABuffer$null(::std::unique_ptr<::livekit::I420ABuffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I420ABuffer>();
}
void cxxbridge1$unique_ptr$livekit$I420ABuffer$raw(::std::unique_ptr<::livekit::I420ABuffer> *ptr, ::std::unique_ptr<::livekit::I420ABuffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I420ABuffer>(raw);
}
::std::unique_ptr<::livekit::I420ABuffer>::element_type const *cxxbridge1$unique_ptr$livekit$I420ABuffer$get(::std::unique_ptr<::livekit::I420ABuffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::I420ABuffer>::pointer cxxbridge1$unique_ptr$livekit$I420ABuffer$release(::std::unique_ptr<::livekit::I420ABuffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$I420ABuffer$drop(::std::unique_ptr<::livekit::I420ABuffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::I420ABuffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::I422Buffer>::type>::value, "definition of `::livekit::I422Buffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::I422Buffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::I422Buffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$I422Buffer$null(::std::unique_ptr<::livekit::I422Buffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I422Buffer>();
}
void cxxbridge1$unique_ptr$livekit$I422Buffer$raw(::std::unique_ptr<::livekit::I422Buffer> *ptr, ::std::unique_ptr<::livekit::I422Buffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I422Buffer>(raw);
}
::std::unique_ptr<::livekit::I422Buffer>::element_type const *cxxbridge1$unique_ptr$livekit$I422Buffer$get(::std::unique_ptr<::livekit::I422Buffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::I422Buffer>::pointer cxxbridge1$unique_ptr$livekit$I422Buffer$release(::std::unique_ptr<::livekit::I422Buffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$I422Buffer$drop(::std::unique_ptr<::livekit::I422Buffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::I422Buffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::I444Buffer>::type>::value, "definition of `::livekit::I444Buffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::I444Buffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::I444Buffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$I444Buffer$null(::std::unique_ptr<::livekit::I444Buffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I444Buffer>();
}
void cxxbridge1$unique_ptr$livekit$I444Buffer$raw(::std::unique_ptr<::livekit::I444Buffer> *ptr, ::std::unique_ptr<::livekit::I444Buffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I444Buffer>(raw);
}
::std::unique_ptr<::livekit::I444Buffer>::element_type const *cxxbridge1$unique_ptr$livekit$I444Buffer$get(::std::unique_ptr<::livekit::I444Buffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::I444Buffer>::pointer cxxbridge1$unique_ptr$livekit$I444Buffer$release(::std::unique_ptr<::livekit::I444Buffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$I444Buffer$drop(::std::unique_ptr<::livekit::I444Buffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::I444Buffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::I010Buffer>::type>::value, "definition of `::livekit::I010Buffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::I010Buffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::I010Buffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$I010Buffer$null(::std::unique_ptr<::livekit::I010Buffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I010Buffer>();
}
void cxxbridge1$unique_ptr$livekit$I010Buffer$raw(::std::unique_ptr<::livekit::I010Buffer> *ptr, ::std::unique_ptr<::livekit::I010Buffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::I010Buffer>(raw);
}
::std::unique_ptr<::livekit::I010Buffer>::element_type const *cxxbridge1$unique_ptr$livekit$I010Buffer$get(::std::unique_ptr<::livekit::I010Buffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::I010Buffer>::pointer cxxbridge1$unique_ptr$livekit$I010Buffer$release(::std::unique_ptr<::livekit::I010Buffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$I010Buffer$drop(::std::unique_ptr<::livekit::I010Buffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::I010Buffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::NV12Buffer>::type>::value, "definition of `::livekit::NV12Buffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::NV12Buffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::NV12Buffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$NV12Buffer$null(::std::unique_ptr<::livekit::NV12Buffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::NV12Buffer>();
}
void cxxbridge1$unique_ptr$livekit$NV12Buffer$raw(::std::unique_ptr<::livekit::NV12Buffer> *ptr, ::std::unique_ptr<::livekit::NV12Buffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::NV12Buffer>(raw);
}
::std::unique_ptr<::livekit::NV12Buffer>::element_type const *cxxbridge1$unique_ptr$livekit$NV12Buffer$get(::std::unique_ptr<::livekit::NV12Buffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::NV12Buffer>::pointer cxxbridge1$unique_ptr$livekit$NV12Buffer$release(::std::unique_ptr<::livekit::NV12Buffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$NV12Buffer$drop(::std::unique_ptr<::livekit::NV12Buffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::NV12Buffer>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::VideoFrameBuffer>::type>::value, "definition of `::livekit::VideoFrameBuffer` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::VideoFrameBuffer>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::VideoFrameBuffer>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$VideoFrameBuffer$null(::std::unique_ptr<::livekit::VideoFrameBuffer> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrameBuffer>();
}
void cxxbridge1$unique_ptr$livekit$VideoFrameBuffer$raw(::std::unique_ptr<::livekit::VideoFrameBuffer> *ptr, ::std::unique_ptr<::livekit::VideoFrameBuffer>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrameBuffer>(raw);
}
::std::unique_ptr<::livekit::VideoFrameBuffer>::element_type const *cxxbridge1$unique_ptr$livekit$VideoFrameBuffer$get(::std::unique_ptr<::livekit::VideoFrameBuffer> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::VideoFrameBuffer>::pointer cxxbridge1$unique_ptr$livekit$VideoFrameBuffer$release(::std::unique_ptr<::livekit::VideoFrameBuffer> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$VideoFrameBuffer$drop(::std::unique_ptr<::livekit::VideoFrameBuffer> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::VideoFrameBuffer>::value>{}(ptr);
}
} // extern "C"
