/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigationCurrentEntryChangeEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigationHistoryEntry.h"
#include "JSNavigationNavigationType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<NavigationCurrentEntryChangeEvent::Init>> convertDictionary<NavigationCurrentEntryChangeEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    NavigationCurrentEntryChangeEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue fromValue;
    if (isNullOrUndefined)
        fromValue = jsUndefined();
    else {
        fromValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "from"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (fromValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "from"_s, "NavigationCurrentEntryChangeEventInit"_s, "NavigationHistoryEntry"_s);
        return ConversionResultException { };
    }
    auto fromConversionResult = convert<IDLInterface<NavigationHistoryEntry>>(lexicalGlobalObject, fromValue);
    if (fromConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.from = fromConversionResult.releaseReturnValue();
    JSValue navigationTypeValue;
    if (isNullOrUndefined)
        navigationTypeValue = jsUndefined();
    else {
        navigationTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "navigationType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto navigationTypeConversionResult = convertOptionalWithDefault<IDLNullable<IDLEnumeration<NavigationNavigationType>>>(lexicalGlobalObject, navigationTypeValue, [&]() -> ConversionResult<IDLNullable<IDLEnumeration<NavigationNavigationType>>> { return typename Converter<IDLNullable<IDLEnumeration<NavigationNavigationType>>>::ReturnType { std::nullopt }; });
    if (navigationTypeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.navigationType = navigationTypeConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEvent_navigationType);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEvent_from);

class JSNavigationCurrentEntryChangeEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationCurrentEntryChangeEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationCurrentEntryChangeEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationCurrentEntryChangeEventPrototype>(vm)) JSNavigationCurrentEntryChangeEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationCurrentEntryChangeEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationCurrentEntryChangeEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationCurrentEntryChangeEventPrototype, JSNavigationCurrentEntryChangeEventPrototype::Base);

using JSNavigationCurrentEntryChangeEventDOMConstructor = JSDOMConstructor<JSNavigationCurrentEntryChangeEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSNavigationCurrentEntryChangeEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSNavigationCurrentEntryChangeEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<NavigationCurrentEntryChangeEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = NavigationCurrentEntryChangeEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<NavigationCurrentEntryChangeEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<NavigationCurrentEntryChangeEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSNavigationCurrentEntryChangeEventDOMConstructorConstruct, JSNavigationCurrentEntryChangeEventDOMConstructor::construct);

template<> const ClassInfo JSNavigationCurrentEntryChangeEventDOMConstructor::s_info = { "NavigationCurrentEntryChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationCurrentEntryChangeEventDOMConstructor) };

template<> JSValue JSNavigationCurrentEntryChangeEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSNavigationCurrentEntryChangeEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigationCurrentEntryChangeEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigationCurrentEntryChangeEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSNavigationCurrentEntryChangeEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationCurrentEntryChangeEventConstructor, 0 } },
    HashTableValue { "navigationType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationCurrentEntryChangeEvent_navigationType, 0 } },
    HashTableValue { "from"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationCurrentEntryChangeEvent_from, 0 } },
};

const ClassInfo JSNavigationCurrentEntryChangeEventPrototype::s_info = { "NavigationCurrentEntryChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationCurrentEntryChangeEventPrototype) };

void JSNavigationCurrentEntryChangeEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigationCurrentEntryChangeEvent::info(), JSNavigationCurrentEntryChangeEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigationCurrentEntryChangeEvent::s_info = { "NavigationCurrentEntryChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationCurrentEntryChangeEvent) };

JSNavigationCurrentEntryChangeEvent::JSNavigationCurrentEntryChangeEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigationCurrentEntryChangeEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<NavigationCurrentEntryChangeEvent> JSNavigationCurrentEntryChangeEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigationCurrentEntryChangeEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigationCurrentEntryChangeEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationCurrentEntryChangeEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNavigationCurrentEntryChangeEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigationCurrentEntryChangeEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigationCurrentEntryChangeEvent>(vm, globalObject);
}

JSValue JSNavigationCurrentEntryChangeEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationCurrentEntryChangeEventDOMConstructor, DOMConstructorID::NavigationCurrentEntryChangeEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationCurrentEntryChangeEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigationCurrentEntryChangeEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigationCurrentEntryChangeEvent_navigationTypeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationCurrentEntryChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<NavigationNavigationType>>>(lexicalGlobalObject, throwScope, impl.navigationType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEvent_navigationType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationCurrentEntryChangeEvent>::get<jsNavigationCurrentEntryChangeEvent_navigationTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationCurrentEntryChangeEvent_fromGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationCurrentEntryChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NavigationHistoryEntry>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.from())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationCurrentEntryChangeEvent_from, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationCurrentEntryChangeEvent>::get<jsNavigationCurrentEntryChangeEvent_fromGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSNavigationCurrentEntryChangeEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigationCurrentEntryChangeEvent, UseCustomHeapCellType::No>(vm, "JSNavigationCurrentEntryChangeEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigationCurrentEntryChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigationCurrentEntryChangeEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigationCurrentEntryChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigationCurrentEntryChangeEvent = std::forward<decltype(space)>(space); }
    );
}

void JSNavigationCurrentEntryChangeEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigationCurrentEntryChangeEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigationCurrentEntryChangeEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore33NavigationCurrentEntryChangeEventE[]; }
#endif
template<std::same_as<NavigationCurrentEntryChangeEvent> T>
static inline void verifyVTable(NavigationCurrentEntryChangeEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigationCurrentEntryChangeEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore33NavigationCurrentEntryChangeEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigationCurrentEntryChangeEvent has subclasses. If NavigationCurrentEntryChangeEvent has subclasses that get passed
        // to toJS() we currently require NavigationCurrentEntryChangeEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigationCurrentEntryChangeEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NavigationCurrentEntryChangeEvent>(impl.ptr());
#endif
    return createWrapper<NavigationCurrentEntryChangeEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigationCurrentEntryChangeEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
